/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.Inventory;
import com.clustercontrol.cloud.aws.presenter.Region;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EC2Service
extends Element
implements IEC2Service {
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Inventory iv;
    private Map<String, Region> regions;

    public EC2Service(Inventory iv) {
        this.iv = iv;
    }

    public Region[] getRegions() {
        return this.getRegionsMap().values().toArray(new Region[0]);
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.iv.getCloudResourceManager();
    }

    public Inventory getInventory() {
        return this.iv;
    }

    @Override
    public Region getRegion(String regionName) {
        Region r = this.getRegionsMap().get(regionName);
        if (r == null) {
            throw new CloudModelException(this.bundle_messages.getString("model.warning.not_found_specified_region"), "EC2Service.InvaidRegionId.NotFound");
        }
        return r;
    }

    private Map<String, Region> getRegionsMap() {
        if (this.regions == null) {
            HashMap<String, Region> tempRegions = new HashMap<String, Region>();
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            try {
                List rs = ce.getAllRegion();
                for (com.clustercontrol.ws.cloud.Region r : rs) {
                    Region cr = new Region(this);
                    cr.setResionName(r.getRegionName());
                    tempRegions.put(r.getRegionName(), cr);
                }
            }
            catch (Exception e) {
                throw new CloudModelException(this.bundle_messages.getString("model.warning.fail_to_get_specified_region"), e);
            }
            this.regions = tempRegions;
        }
        return this.regions;
    }
}

