/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.HinemosService;
import com.clustercontrol.cloud.aws.presenter.ICloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.IEndpointManager;
import com.clustercontrol.cloud.aws.presenter.IHinemosService;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IInventory;
import com.clustercontrol.cloud.aws.presenter.IdentityManagement;
import com.clustercontrol.cloud.aws.presenter.Inventory;
import com.clustercontrol.cloud.commons.util.MessageManager;

public class CloudResourceManager
extends Element
implements ICloudResourceManager {
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private IEndpointManager endpointManager;
    private IdentityManagement im;
    private HinemosService hs;
    private Inventory iv;

    public CloudResourceManager(IEndpointManager endpointManager) {
        this.endpointManager = endpointManager;
    }

    @Override
    public IdentityManagement getIdentityManagement() {
        if (this.im == null) {
            this.im = new IdentityManagement(this);
        }
        return this.im;
    }

    @Override
    public IHinemosService getHinemosService() {
        if (this.hs == null) {
            this.hs = new HinemosService(this);
        }
        return this.hs;
    }

    public <T> T getEndpoint(Class<T> clazz) {
        return this.endpointManager.getEndpoint(clazz);
    }

    @Override
    public String getAccountName() {
        return this.endpointManager.getAccountName();
    }

    @Override
    public IInventory getInventory() throws CloudModelException {
        if (this.iv == null) {
            Inventory iv = new Inventory(this);
            IIdentity credential = iv.getCredential();
            if (credential == null) {
                throw new CloudModelException(this.bundle_messages.getString("model.warning.not_found_specified_user"), "IdentityManagement.InvaidCloudUser.NotFound");
            }
            this.iv = iv;
        }
        return this.iv;
    }
}

