/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.commons.util.MessageManager;

public class CloudModelException
extends RuntimeException {
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private static final long serialVersionUID = -5229536826531257547L;
    private String errorCode = "Unexpected";

    public CloudModelException() {
        super(bundle_messages.getString("model.warning.unexpected_error"));
    }

    public CloudModelException(String message, Throwable cause) {
        super(message, cause);
    }

    public CloudModelException(String message) {
        super(message);
    }

    public CloudModelException(String message, String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public CloudModelException(Throwable cause) {
        super(bundle_messages.getString("model.warning.unexpected_error"), cause);
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return super.toString() + " : ErrorCode=" + this.errorCode;
    }
}

