/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateIdentityRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.Identity;
import com.clustercontrol.cloud.aws.presenter.IdentityManagement;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudType;
import com.clustercontrol.ws.cloud.CloudUser;
import com.clustercontrol.ws.cloud.CloudUserType;
import com.clustercontrol.ws.cloud.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Category
extends Element
implements ICategory {
    private String id;
    private String name;
    private String description;
    private IdentityManagement im;
    private List<Identity> identities = new ArrayList<Identity>();

    public Identity[] getIdentities() {
        return this.identities.toArray(new Identity[0]);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IdentityManagement getIdentityManagement() {
        return this.im;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentityManagement(IdentityManagement im) {
        this.im = im;
    }

    public CloudResourceManager getCloudManager() {
        return this.im.getCloudResourceManager();
    }

    public void addChildIdentity(Identity child) {
        if (!this.identities.contains(child)) {
            this.identities.add(child);
            this.fireElementAdded(ICategory.p2.identities, child);
        }
    }

    public void removeChildIdentity(IIdentity child) {
        if (this.identities.contains(child)) {
            this.identities.remove(child);
            this.fireElementRemoved(ICategory.p2.identities, child);
        }
    }

    public static Category createCategory(CloudType cloudType, CloudResourceManager root, IdentityManagement im) {
        Category c = new Category();
        c.setId(cloudType.getCloudId());
        c.setName(cloudType.getCloudName());
        c.setDescription(cloudType.getDescription());
        c.setIdentityManagement(im);
        return c;
    }

    @Override
    public void createChildIdentity(CreateIdentityRequest request) {
        CloudEndpoint ce = this.getCloudManager().getEndpoint(CloudEndpoint.class);
        CloudUser cu = new CloudUser();
        cu.setCloudUserName(request.name);
        cu.setCloudUserId(request.id);
        cu.setDescription(request.description);
        cu.setAccessKey(request.key.getAccessKey());
        cu.setSecretKey(request.key.getSecretKey());
        cu.setCloudId(this.getId());
        cu.setCloudUserType(CloudUserType.PARENT);
        cu.setUserId(request.hinemosUserId);
        try {
            CloudUser newCu = ce.addCloudUser(cu);
            Identity child = Identity.createIdentiry(newCu, this.getCloudManager(), this, null);
            this.addChildIdentity(child);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void deleteChildIdentity(String childId) {
        for (Identity id : this.identities) {
            if (!childId.equals(id.getId())) continue;
            CloudEndpoint ce = this.getCloudManager().getEndpoint(CloudEndpoint.class);
            try {
                ce.removeCloudUser(id.getId());
                this.removeChildIdentity(id);
                return;
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
    }

    @Override
    public void update() throws InvalidStateException {
        CloudEndpoint ce = this.getCloudManager().getEndpoint(CloudEndpoint.class);
        Filter f1 = new Filter();
        f1.setName("cloudId");
        f1.getValues().add(this.getId());
        Filter f2 = new Filter();
        f2.setName("parentCloudUserId");
        f2.getValues().add(null);
        List users = null;
        try {
            users = ce.getCloudUsers(Arrays.asList(f1, f2));
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        ArrayList<Identity> identityList = new ArrayList<Identity>(this.identities);
        ArrayList<Identity> newIdentityList = new ArrayList<Identity>();
        Iterator userIter = users.iterator();
        while (userIter.hasNext()) {
            CloudUser cu = (CloudUser)userIter.next();
            Iterator identityIter = identityList.iterator();
            while (identityIter.hasNext()) {
                Identity id = (Identity)identityIter.next();
                if (!cu.getCloudUserId().equals(id.getId())) continue;
                newIdentityList.add(id);
                userIter.remove();
                identityIter.remove();
            }
        }
        for (Identity id : identityList) {
            try {
                this.removeChildIdentity(id);
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        for (CloudUser cu : users) {
            try {
                Identity child = Identity.createIdentiry(cu, this.getCloudManager(), this, null);
                this.addChildIdentity(child);
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        for (Identity id : this.identities) {
            id.update();
        }
        super.update();
    }
}

