/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BillingAlarmService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.ModifyBillingAlarmRequest;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.Date;
import java.util.List;

public class BillingAlarm
extends Element
implements IBillingAlarm {
    private BillingAlarmService service;
    private String alarmId;
    private String alarmName;
    private String application;
    private String cloudId;
    private String cloudUserId;
    private String description;
    private String notifyGroupId;
    private List<NotifyRelationInfo> notifyRelationInfos;
    private String target;
    private Double thresholdInfoLimit;
    private Double thresholdWarnLimit;
    private Boolean validFlg;
    private Date regDate;
    private Date updateDate;
    private String regUser;
    private String updateUser;

    public BillingAlarm(BillingAlarmService service) {
        this.service = service;
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.getBillingAlarmService().getCloudResourceManager();
    }

    @Override
    public BillingAlarmService getBillingAlarmService() {
        return this.service;
    }

    @Override
    public String getAlarmId() {
        return this.alarmId;
    }

    public void setAlarmId(String alarmId) {
        this.alarmId = alarmId;
    }

    @Override
    public String getAlarmName() {
        return this.alarmName;
    }

    public void setAlarmName(String alarmName) {
        this.internalSet("alarmName", IBillingAlarm.p2.alarmName, alarmName);
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    @Override
    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @Override
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    public void setCloudUserId(String cloudUserId) {
        this.cloudUserId = cloudUserId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.internalSet("description", IBillingAlarm.p2.description, description);
    }

    @Override
    public String getNotifyGroupId() {
        return this.notifyGroupId;
    }

    public void setNotifyGroupId(String notifyGroupId) {
        this.notifyGroupId = notifyGroupId;
    }

    @Override
    public List<NotifyRelationInfo> getNotifyRelationInfos() {
        return this.notifyRelationInfos;
    }

    public void setNotifyRelationInfos(List<NotifyRelationInfo> notifyRelationInfos) {
        this.notifyRelationInfos = notifyRelationInfos;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public Double getThresholdInfoLimit() {
        return this.thresholdInfoLimit;
    }

    public void setThresholdInfoLimit(Double thresholdInfoLimit) {
        this.internalSet("thresholdInfoLimit", IBillingAlarm.p2.thresholdInfoLimit, thresholdInfoLimit);
    }

    @Override
    public Double getThresholdWarnLimit() {
        return this.thresholdWarnLimit;
    }

    public void setThresholdWarnLimit(Double thresholdWarnLimit) {
        this.internalSet("thresholdWarnLimit", IBillingAlarm.p2.thresholdWarnLimit, thresholdWarnLimit);
    }

    @Override
    public Boolean getValidFlg() {
        return this.validFlg;
    }

    public void setValidFlg(Boolean validFlg) {
        this.internalSet("validFlg", IBillingAlarm.p2.validFlg, validFlg);
    }

    @Override
    public Date getRegDate() {
        return this.regDate;
    }

    public void setRegDate(Date regDate) {
        this.internalSet("regDate", IBillingAlarm.p2.regDate, regDate);
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.internalSet("updateDate", IBillingAlarm.p2.updateDate, updateDate);
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    public void setRegUser(String regUser) {
        this.regUser = regUser;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public void modify(ModifyBillingAlarmRequest request) {
        try {
            com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
            ba.setAlarmId(this.getAlarmId());
            ba.setAlarmName(request.getAlarmName());
            ba.setDescription(request.getDescription());
            ba.setNotifyGroupId(this.getNotifyGroupId());
            ba.setTarget(request.getTarget());
            ba.setThresholdInfoLimit(request.getThresholdInfoLimit());
            ba.setThresholdWarnLimit(request.getThresholdWarnLimit());
            ba.setValidFlg(request.isValidFlg());
            ba.getNotifyRelationInfos().addAll(request.getNotifyRelationInfos());
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            com.clustercontrol.ws.cloud.BillingAlarm wsBa = ce.modifyBillingAlarm(ba);
            this.overwriteByBillingAlarm(wsBa);
        }
        catch (CloudModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void enableAlarm() {
        try {
            com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
            ba.setAlarmId(this.getAlarmId());
            ba.setValidFlg(Boolean.valueOf(true));
            CloudEndpoint ce = this.getBillingAlarmService().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            ce.modifyBillingAlarm(ba);
            this.setValidFlg(true);
        }
        catch (CloudModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void disableAlarm() {
        try {
            com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
            ba.setAlarmId(this.getAlarmId());
            ba.setValidFlg(Boolean.valueOf(false));
            CloudEndpoint ce = this.getBillingAlarmService().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            ce.modifyBillingAlarm(ba);
            this.setValidFlg(false);
        }
        catch (CloudModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void update() throws InvalidStateException {
        try {
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            com.clustercontrol.ws.cloud.BillingAlarm newBa = ce.getBillingAlarm(this.getAlarmId());
            this.internalUpdate(newBa);
        }
        catch (CloudModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public void internalUpdate(com.clustercontrol.ws.cloud.BillingAlarm billingAlarm) {
        this.overwriteByBillingAlarm(billingAlarm);
        super.update();
    }

    protected void overwriteByBillingAlarm(com.clustercontrol.ws.cloud.BillingAlarm billingAlarm) {
        this.setAlarmId(billingAlarm.getAlarmId());
        this.setAlarmName(billingAlarm.getAlarmName());
        this.setApplication(billingAlarm.getApplication());
        this.setCloudId(billingAlarm.getCloudId());
        this.setCloudUserId(billingAlarm.getCloudUserId());
        this.setDescription(billingAlarm.getDescription());
        this.setNotifyGroupId(billingAlarm.getNotifyGroupId());
        this.setNotifyRelationInfos(billingAlarm.getNotifyRelationInfos());
        this.setTarget(billingAlarm.getTarget());
        this.setThresholdInfoLimit(billingAlarm.getThresholdInfoLimit());
        this.setThresholdWarnLimit(billingAlarm.getThresholdWarnLimit());
        this.setValidFlg(billingAlarm.isValidFlg());
        this.setRegDate(billingAlarm.getRegDate() != null ? new Date(billingAlarm.getRegDate()) : null);
        this.setUpdateDate(billingAlarm.getUpdateDate() != null ? new Date(billingAlarm.getUpdateDate()) : null);
        this.setRegUser(billingAlarm.getRegUser());
        this.setUpdateUser(billingAlarm.getUpdateUser());
    }

    public static BillingAlarm createBillingAlarm(BillingAlarmService service, com.clustercontrol.ws.cloud.BillingAlarm wsBillingAlarm) {
        BillingAlarm billingAlarm = new BillingAlarm(service);
        billingAlarm.overwriteByBillingAlarm(wsBillingAlarm);
        return billingAlarm;
    }
}

