SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

BEGIN;

    
CREATE TABLE cc_cloud_type_mst (
	cloud_id varchar(64) NOT NULL,
	cloud_name varchar(128) NOT NULL,
	description varchar(256)
);

ALTER TABLE ONLY cc_cloud_type_mst
    ADD CONSTRAINT p_key_cc_cloud_type_mst PRIMARY KEY (cloud_id);

COMMIT;

BEGIN;

--
-- Name: cc_cloud_instance; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cloud_instance (
    instance_id character varying(64) NOT NULL,
    instance_name character varying(64),
	cloud_id varchar(64) NOT NULL,
    cloud_user_id varchar(64) NOT NULL,
    cloud_account_id varchar(128) NOT NULL,
    facility_id character varying(64),
    region character varying(64) NOT NULL,
    availavility_zone character varying(64) NOT NULL,
	regist_status smallint NOT NULL,
	template_id varchar(64),
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

--
-- Name: p_key_cc_cloud_instance; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT p_key_cc_cloud_instance PRIMARY KEY (instance_id, region);

ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT f_key_cc_cloud_instance_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON DELETE CASCADE;
    
ALTER TABLE ONLY cc_cloud_instance
    ADD CONSTRAINT f_key_cc_cloud_instance_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);


COMMIT;

BEGIN;


CREATE TABLE cc_cloud_user (
	cloud_user_id varchar(64) NOT NULL,
	cloud_user_name varchar(128) NOT NULL,
    cloud_resource_id varchar(128) NOT NULL,
	secret_key varchar(64) NOT NULL,
	access_key varchar(64) NOT NULL,
	cloud_id varchar(64),
	description varchar(256),
	cloud_user_type smallint,
	parent_cloud_user_id varchar(64),
	user_id varchar(64),
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT p_key_cc_cloud_user PRIMARY KEY (cloud_user_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT f_key_cc_cloud_user_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT f_key_cc_cloud_user_user_id FOREIGN KEY (user_id) REFERENCES cc_cfg_user(user_id);
    
ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT u_key_cc_cloud_user_user_id UNIQUE (user_id);

ALTER TABLE ONLY cc_cloud_user
    ADD CONSTRAINT f_key_cc_cloud_user_parent_cloud_user_id FOREIGN KEY (parent_cloud_user_id) REFERENCES cc_cloud_user(cloud_user_id);


COMMIT;

BEGIN;

CREATE TABLE cc_cloud_billing_alarm (
	alarm_id varchar(64) NOT NULL,
	alarm_name varchar(128) NOT NULL,
	cloud_id varchar(64) NOT NULL,
	cloud_user_id varchar(64) NOT NULL,
	description varchar(256),
	target varchar(64),
	threshold_info_limit double precision,
	threshold_warn_limit double precision,
	notify_group_id varchar(1024),
	application varchar(64),
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64),
	valid_flg smallint
);

ALTER TABLE ONLY cc_cloud_billing_alarm
    ADD CONSTRAINT p_key_cc_cloud_billing_alarm PRIMARY KEY (alarm_id);

ALTER TABLE cc_cloud_billing_alarm
    ADD CONSTRAINT f_key_cc_cloud_billing_alarm_cloud_user_id FOREIGN KEY (cloud_user_id) REFERENCES cc_cloud_user(cloud_user_id);

ALTER TABLE ONLY cc_cloud_billing_alarm
    ADD CONSTRAINT f_key_cc_cloud_billing_alarm_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);
    
COMMIT;

BEGIN;

    
CREATE TABLE cc_cloud_instance_backup (
	image_id varchar(64) NOT NULL,
	image_name varchar(128),
	cloud_id varchar(64) NOT NULL,
	cloud_user_id varchar(64) NOT NULL,
    cloud_account_id varchar(128) NOT NULL,
	facility_id varchar(64) NOT NULL,
	facility_name varchar(128),
	instance_id varchar(64) NOT NULL,
	instance_name varchar(128),
	description varchar(256),
	region varchar(64) NOT NULL,
	availability_zone varchar(64) NOT NULL,
	node_name varchar(128) NOT NULL,
	key_name varchar(64) NOT NULL,
	restore_status smallint NOT NULL,
	reg_date timestamp without time zone,
	reg_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT p_key_cc_cloud_instance_backup PRIMARY KEY (region, image_id, cloud_account_id);

--ALTER TABLE ONLY cc_cloud_instance_backup
--    ADD CONSTRAINT f_key_cc_cloud_instance_backup_instance_id FOREIGN KEY (instance_id, region) REFERENCES cc_cloud_instance(instance_id, region);

ALTER TABLE ONLY cc_cloud_instance_backup
    ADD CONSTRAINT f_key_cc_cloud_instance_backup_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);
    

COMMIT;

BEGIN;

    
CREATE TABLE cc_cloud_storage (
	storage_id varchar(64) NOT NULL,
	storage_name varchar(128),
	storage_type varchar(64) NOT NULL,
	cloud_id varchar(64) NOT NULL,
	cloud_user_id varchar(64) NOT NULL,
    cloud_account_id varchar(128) NOT NULL,
	facility_id varchar(64),
	device_index integer,
	device_type varchar(32),
	device_name varchar(128),
	region varchar(64) NOT NULL,
	availability_zone varchar(64) NOT NULL,
	regist_status smallint NOT NULL,
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT p_key_cc_cloud_storage PRIMARY KEY (storage_id, region, cloud_account_id);

-- ALTER TABLE ONLY cc_cloud_storage
--    ADD CONSTRAINT f_key_cc_cloud_storage_facility_id_device_index_device_type_dev FOREIGN KEY (facility_id, device_index, device_type, device_name) REFERENCES cc_cfg_node_disk(facility_id, device_index, device_type, device_name);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT f_key_cc_cloud_storage_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);

ALTER TABLE ONLY cc_cloud_storage
    ADD CONSTRAINT f_key_cc_cloud_storage_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON DELETE CASCADE;

    
COMMIT;

BEGIN;

    
CREATE TABLE cc_cloud_storage_backup (
	snapshot_id varchar(64) NOT NULL,
	snapshot_name varchar(128),
	cloud_id varchar(64) NOT NULL,
	cloud_user_id varchar(64) NOT NULL,
    cloud_account_id varchar(128) NOT NULL,
	storage_id varchar(64) NOT NULL,
	storage_name varchar(128),
	description varchar(256),
	region varchar(64) NOT NULL,
	availability_zone varchar(64) NOT NULL,
	restore_status smallint NOT NULL,
	storage_size integer NOT NULL,
	reg_date timestamp without time zone,
	reg_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT p_key_cc_cloud_storage_backup PRIMARY KEY (snapshot_id, region);

--ALTER TABLE ONLY cc_cloud_storage_backup
--    ADD CONSTRAINT f_key_cc_cloud_storage_backup_storage_id FOREIGN KEY (storage_id, region) REFERENCES cc_cloud_storage(storage_id, region);

ALTER TABLE ONLY cc_cloud_storage_backup
    ADD CONSTRAINT f_key_cc_cloud_storage_backup_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);
    

COMMIT;


BEGIN;

    
CREATE TABLE cc_cloud_template (
	template_id varchar(64) NOT NULL,
	template_name varchar(128),
	cloud_id varchar(64) NOT NULL,
	cloud_user_id varchar(64) NOT NULL,
    cloud_account_id varchar(128) NOT NULL,
	image_id varchar(64) NOT NULL,
	jobunit_id varchar(64) NOT NULL,
	launch_job_id varchar(64),
	start_job_id varchar(64),
	stop_job_id varchar(64),
	region varchar(64) NOT NULL,
	reg_date timestamp without time zone,
	update_date timestamp without time zone,
	reg_user varchar(64),
	update_user varchar(64)
);

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT p_key_cc_cloud_template PRIMARY KEY (template_id);

ALTER TABLE ONLY cc_cloud_template
    ADD CONSTRAINT f_key_cc_cloud_template_cloud_id FOREIGN KEY (cloud_id) REFERENCES cc_cloud_type_mst(cloud_id);
    
--ALTER TABLE ONLY cc_cloud_template
--    ADD CONSTRAINT f_key_cc_cloud_template_launch_job_id FOREIGN KEY (jobunit_id, launch_job_id) REFERENCES cc_job_mst(jobunit_id, job_id);
    
--ALTER TABLE ONLY cc_cloud_template
--    ADD CONSTRAINT f_key_cc_cloud_template_start_job_id FOREIGN KEY (jobunit_id, start_job_id) REFERENCES cc_job_mst(jobunit_id, job_id);
    
--ALTER TABLE ONLY cc_cloud_template
--    ADD CONSTRAINT f_key_cc_cloud_template_stop_job_id FOREIGN KEY (jobunit_id, stop_job_id) REFERENCES cc_job_mst(jobunit_id, job_id);
    

COMMIT;