#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

. /opt/hinemos/hinemos.cfg
cd `dirname $0`
. conf.sh

if [ ! -e "/opt/hinemos/_version" ]; then
	echo "error : You must install Hinemos v${REQUIRED_HINEMOS_VERSION} or later in order to install this option on this box!!"
	exit 1
fi

INSTALLED_HINEMOS_VERSION=`cat '/opt/hinemos/_version'`
echo "Installed Hinemos version is ${INSTALLED_HINEMOS_VERSION}."

REQUIRE=( `echo ${REQUIRED_HINEMOS_VERSION} | sed -e 's/[^0-9]*\([1-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\).*\|.*/\1 \2 \3/'` )
if [ ${#REQUIRE[*]} != 3 ]; then
	echo "error : Required Hinemos version(${REQUIRED_HINEMOS_VERSION}) is invalid format."
	exit 1
fi

INSTALED=( `echo ${INSTALLED_HINEMOS_VERSION} | sed -e 's/[^0-9]*\([1-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\).*\|.*/\1 \2 \3/'` )
if [ ${#INSTALED[*]} != 3 ]; then
	echo "error : Installed Hinemos version(${INSTALLED_HINEMOS_VERSION}) is invalid format."
	exit 1
fi

if [ ${REQUIRE[0]} -ne ${INSTALED[0]} -o  ${REQUIRE[1]} -ne ${INSTALED[1]} ]; then
	echo "error : Not match major version. required=${REQUIRED_HINEMOS_VERSION}, installed=${INSTALLED_HINEMOS_VERSION}"
	exit 1
fi

if [ ${REQUIRE[2]} -gt ${INSTALED[2]} ]; then
	echo "error : You must install Hinemos v${REQUIRED_HINEMOS_VERSION} or later in order to install this option on this box!!"
	exit 1
fi

INSTALL_SQL_DATA=$1

for INSTALL_JAR in ${INSTALL_JARS}
do
	if ! ls ${INSTALL_JAR} >/dev/null 2>&1; then
	    echo install-package is lacking !
	    exit 1
	fi
done

echo version check succeeded!
echo
echo ----- ${OPTION_PACKAGE_NAME} start ----------

for INSTALL_JAR in ${INSTALL_JARS}
do
	cd - >/dev/null 2>&1
	cd `dirname $0`
	rm -f ${LIBDIR}/${INSTALL_JAR}
	mkdir -p ${LIBDIR}
	cp -p ${INSTALL_JAR} ${LIBDIR}
	chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${LIBDIR}
	
	cd - >/dev/null 2>&1
	cd ${JBOSS_LIB}
	if [ ! -f ${INSTALL_JAR} ]; then
	    ln -s ${LIBDIR}/${INSTALL_JAR}
	fi
	RET=$?
	if [ ${RET} -ne 0 ]; then
	    echo link failed at lib-dir !
	    #exit 1
	fi
	chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${INSTALL_JAR}
	cd - >/dev/null 2>&1
	cd ${DEPLOY_DIR}
	if [ ! -f ${INSTALL_JAR} ]; then
	    ln -s ${LIBDIR}/${INSTALL_JAR}
	fi
	RET=$?
	if [ ${RET} -ne 0 ]; then
	    echo link failed at deploy-dir !
	    #exit 1
	fi
	chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${INSTALL_JAR}
done

cd - >/dev/null 2>&1
cd /opt/hinemos
echo ${VERSION_NUMBER} | cat > ${VERSION_FILE_NAME} 
chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${VERSION_FILE_NAME}

echo ----- ${OPTION_PACKAGE_NAME} end   ----------
echo
echo ----- Service start  -------

cd - >/dev/null 2>&1
cd `dirname $0`
rm -f ${ETC_JBOSS}/${SERVICE_XML}
cp -p ${SERVICE_XML} ${ETC_JBOSS}/${SERVICE_XML}
chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${ETC_JBOSS}/${SERVICE_XML}

cd - >/dev/null 2>&1
cd ${DEPLOY_DIR}
if [ ! -f ${SERVICE_XML} ]; then
    ln -s ${ETC_JBOSS}/${SERVICE_XML}
fi
RET=$?
if [ ${RET} -ne 0 ]; then
    echo link failed at service-file !
    #exit 1
fi
chown -R ${INSTALL_USER}:${INSTALL_GROUP} ${SERVICE_XML}

echo ----- Service end   --------
echo
echo ----- db start  ------------

cd - >/dev/null 2>&1
cd `dirname $0`
read -p "Postgres Password (default hinemos) : " PASSWD
if [ "${PASSWD}" != "" ] ; then
    export PGPASSWORD=${PASSWD}
fi

${PG}/bin/psql -p 24001 -U ${HINEMOS_PG_USER} -f ${INSTALL_SQL} 1>/dev/null
RET=$?
if [ ${RET} -ne 0 ]; then
    echo SQL failed !
    #exit 1
fi

cd - >/dev/null 2>&1

${PG}/bin/psql -p 24001 -U ${HINEMOS_PG_USER} -f ${INSTALL_SQL_DATA} 1>/dev/null
RET=$?
if [ ${RET} -ne 0 ]; then
    echo SQL failed !
    #exit 1
fi

cd - >/dev/null 2>&1

echo ----- db end   -------------
echo
echo install succeeded !
exit 0