/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloud;

import com.clustercontrol.cloud.bean.AvailabilityZone;
import com.clustercontrol.cloud.bean.BillingAlarm;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.KeyPair;
import com.clustercontrol.cloud.bean.Region;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.SecurityGroup;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Subnet;
import com.clustercontrol.cloud.ejb.session.CloudControllerLocal;
import com.clustercontrol.cloud.ejb.session.CloudControllerLocalHome;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.cloud.validation.annotation.FilterCondition;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IntoEntity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.endpoint.HttpAuthenticator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;
import org.jnp.interfaces.NamingContext;

@WebService(serviceName="CloudEndpointService", portName="CloudEndpointPort", targetNamespace="http://cloud.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.cloud.CloudEndpoint")
public class CloudEndpointImpl
implements CloudEndpoint,
CloudRoleConstants {
    @Resource
    private WebServiceContext wsctx;

    private void validate(String methodName, Class<?>[] paramTypes, Object[] params, String group) throws ValidationFault {
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (method != null) {
            ValidationUtil.getMethodValidator().validate(method, params, group);
        }
    }

    public String echo(String str) throws InvalidUserPass, InvalidRole, HinemosUnknown {
        ArrayList roleList = new ArrayList();
        HttpAuthenticator.authCheck((WebServiceContext)this.wsctx, roleList);
        return str + ", " + str;
    }

    private CloudControllerLocal getCloudControllerLocal() throws CloudManagerFault, InvalidUserPass {
        CloudControllerLocal cloud = null;
        try {
            String acount = HttpAuthenticator.getAccount((WebServiceContext)this.wsctx);
            NamingContext namingContext = HttpAuthenticator.getContext((String)acount);
            CloudControllerLocalHome localHome = (CloudControllerLocalHome)namingContext.lookup("CloudControllerLocal");
            cloud = localHome.create();
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        return cloud;
    }

    private void authCheck(String ... demandingRight) throws InvalidUserPass, InvalidRole, HinemosUnknown {
        HttpAuthenticator.authCheck((WebServiceContext)this.wsctx, new ArrayList<String>(Arrays.asList(demandingRight)));
    }

    @Override
    public CloudInstance addInstance(@NotNull @IntoEntity CreateInstanceRequest instance) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addInstance");
        try {
            this.validate("addInstance", new Class[]{CreateInstanceRequest.class}, new Object[]{instance}, "addInstance");
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().createInstance(instance);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstance addInstanceByTemplate(@NotNull @IntoEntity CreateInstanceByTemplateRequest request) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling addInstanceByTemplate");
        try {
            this.validate("addInstanceByTemplate", new Class[]{CreateInstanceByTemplateRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            this.authCheck("JobManagementRead");
            this.authCheck("JobManagementWrite");
            this.authCheck("JobManagementExecute");
            return this.getCloudControllerLocal().createInstanceByTemplate(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstance restoreInstance(@NotNull @IntoEntity RestoreInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling restoreInstance");
        try {
            this.validate("restoreInstance", new Class[]{RestoreInstanceRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().restoreInstance(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeInstance(@NotNull String region, @NotNull String instanceId) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeInstance");
        try {
            this.validate("removeInstance", new Class[]{String.class, String.class}, new Object[]{region, instanceId}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().removeInstance(region, instanceId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstance getInstance(@NotNull String region, @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getInstances");
        try {
            this.validate("getInstance", new Class[]{String.class, String.class}, new Object[]{region, instanceId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findInstance(region, instanceId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudInstance> getInstancesByRegion(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getInstancesByRegion");
        try {
            this.validate("getInstancesByRegion", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findInstancesByRegion(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public InstanceStateChange startInstance(@NotNull StartInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling startInstance");
        try {
            this.validate("startInstance", new Class[]{StartInstanceRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            if (request.getRunJobFlg().booleanValue()) {
                this.authCheck("JobManagementRead");
                this.authCheck("JobManagementWrite");
                this.authCheck("JobManagementExecute");
            }
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return controller.startInstance(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public InstanceStateChange stopInstance(@NotNull StopInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling stopInstance");
        try {
            this.validate("stopInstance", new Class[]{StopInstanceRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            if (request.getRunJobFlg().booleanValue()) {
                this.authCheck("JobManagementRead");
                this.authCheck("JobManagementWrite");
                this.authCheck("JobManagementExecute");
            }
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return controller.stopInstance(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpoint.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public BillingAlarm addBillingAlarm(@NotNull @IntoEntity BillingAlarm alarm) throws CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addBillingAlarm");
        try {
            this.validate("addBillingAlarm", new Class[]{BillingAlarm.class}, new Object[]{alarm}, "creation");
            this.authCheck("CloudManagementWrite");
            return this.getCloudControllerLocal().createBillingAlarm(alarm);
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public BillingAlarm getBillingAlarm(@Identity String alarmId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getBillingAlarm");
        try {
            this.validate("getBillingAlarm", new Class[]{String.class}, new Object[]{alarmId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findBillingAlarm(alarmId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeBillingAlarm(@Identity String alarmId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeBillingAlarm");
        try {
            this.validate("removeBillingAlarm", new Class[]{String.class}, new Object[]{alarmId}, null);
            this.authCheck("CloudManagementWrite");
            this.getCloudControllerLocal().removeBillingAlarm(alarmId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<BillingAlarm> getAllBillingAlarm() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllBillingAlarm");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findAllBillingAlarm());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public BillingAlarm modifyBillingAlarm(@NotNull @IntoEntity BillingAlarm ba) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling modifyBillingAlarm");
        try {
            this.validate("modifyBillingAlarm", new Class[]{BillingAlarm.class}, new Object[]{ba}, null);
            this.authCheck("CloudManagementWrite");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            controller.modifyBillingAlarm(ba);
            return controller.findBillingAlarm(ba.getAlarmId());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudUser addCloudUser(@NotNull @IntoEntity CloudUser cu) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addCloudUser");
        try {
            this.validate("addCloudUser", new Class[]{CloudUser.class}, new Object[]{cu}, "creation");
            this.authCheck("CloudManagementWrite");
            return this.getCloudControllerLocal().createCloudUser(cu);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudUser> getAllCloudUser() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllCloudUser");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findAllCloudUser());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudUser getCloudUser(@Identity(elementId="cloudUser.cloudUserId") String cloudUserId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getCloudUser");
        try {
            this.validate("getCloudUser", new Class[]{String.class}, new Object[]{cloudUserId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findCloudUser(cloudUserId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudUser> getCloudUsers(@NotNullContainer @NotNull @FilterCondition(filters={"cloudUserId", "cloudUserName", "secretKey", "accessKey", "cloudId", "description", "cloudUserType", "parentCloudUserId", "userId", "regDate", "updateDate", "regUser", "rpdateUser"}) List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getCloudUsers");
        try {
            this.validate("getCloudUsers", new Class[]{List.class}, new Object[]{filters}, null);
            this.authCheck("CloudManagementRead");
            CloudUser[] cus = this.getCloudControllerLocal().findCloudUsers(filters.toArray(new Filter[0]));
            return Arrays.asList(cus);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeCloudUser(@Identity(elementId="cloudUser.cloudUserId") String cloudUserId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeBillingAlarm");
        try {
            this.validate("removeBillingAlarm", new Class[]{String.class}, new Object[]{cloudUserId}, null);
            this.authCheck("CloudManagementWrite");
            this.getCloudControllerLocal().removeCloudUser(cloudUserId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudUser modifyCloudUser(@NotNull @IntoEntity CloudUser cu) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling modifyCloudUser");
        try {
            this.validate("modifyCloudUser", new Class[]{CloudUser.class}, new Object[]{cu}, "modification");
            this.authCheck("CloudManagementWrite");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            controller.modifyCloudUser(cu);
            return controller.findCloudUser(cu.getCloudUserId());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudType> getAllCloudType() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllCloudType");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findAllCloudType());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<SecurityGroup> getSecurityGroupsByRegion(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getSecurityGroupsByRegion");
        try {
            this.validate("getSecurityGroupsByRegion", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getSecurityGroupsByRegion(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<Region> getAllRegion() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllRegion");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getAllRegion());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<AvailabilityZone> getAvailabilityZones(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAvailabilityZones");
        try {
            this.validate("getAvailabilityZones", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getAvailabilityZones(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<Image> getImages(@NotNull String regionName, @NotNull @NotNullContainer @IntoEntity List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getImages");
        try {
            this.validate("getImages", new Class[]{String.class, List.class}, new Object[]{regionName, filters}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getImages(regionName, filters.toArray(new Filter[0])));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<SecurityGroup> getSecurityGroups(@NotNull String regionName, @NotNull @NotNullContainer @IntoEntity List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getSecurityGroups");
        try {
            this.validate("getSecurityGroups", new Class[]{String.class, List.class}, new Object[]{regionName, filters}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getSecurityGroups(regionName, filters.toArray(new Filter[0])));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<String> getAllInstanceType() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllInstanceType");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getAllInstanceType());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<KeyPair> getKeyNames(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getKeyNames");
        try {
            this.validate("getKeyNames", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getKeyNames(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public String getWindowsPassword(@NotNull String regionName, @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getWindowsPassword");
        try {
            this.validate("getWindowsPassword", new Class[]{String.class, String.class}, new Object[]{regionName, instanceId}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().getWindowsPassword(regionName, instanceId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<Subnet> getSubnets(@NotNull String regionName, @NotNull @NotNullContainer @IntoEntity List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getSubnets");
        try {
            this.validate("getSubnets", new Class[]{String.class, List.class}, new Object[]{regionName, filters}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getSubnets(regionName, filters.toArray(new Filter[0])));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<Snapshot> getSnapshots(@NotNull String regionName, @NotNull @NotNullContainer @IntoEntity List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getSnapshots");
        try {
            this.validate("getSnapshots", new Class[]{String.class, List.class}, new Object[]{regionName, filters}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getSnapshots(regionName, filters.toArray(new Filter[0])));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<String> getAllVolumeType() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllInstanceType");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getAllVolumeType());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void attachStorage(@NotNull String regionName, @NotNull String instanceId, @NotNull String storageId, @NotNull String deviceName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling attachStorage");
        try {
            this.validate("attachStorage", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{regionName, instanceId, storageId, deviceName}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().attachStorage(regionName, instanceId, storageId, deviceName);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void detachStorage(@NotNull String regionName, @NotNull String instanceId, @NotNull String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling detachStorage");
        try {
            this.validate("detachStorage", new Class[]{String.class, String.class, String.class}, new Object[]{regionName, instanceId, storageId}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().detachStorage(regionName, instanceId, storageId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudStorage addStorage(@NotNull @IntoEntity CreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addStorage");
        try {
            this.validate("addStorage", new Class[]{CreateStorageRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().createStorage(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudStorage restoreStorage(@NotNull @IntoEntity CreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling restoreStorage");
        try {
            this.validate("restoreStorage", new Class[]{CreateStorageRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().restoreStorage(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeStorage(@NotNull String regionName, @NotNull String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeStorage");
        try {
            this.validate("removeStorage", new Class[]{String.class, String.class}, new Object[]{regionName, storageId}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().removeStorage(regionName, storageId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudStorage getStorage(@NotNull String regionName, @NotNull String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getStorage");
        try {
            this.validate("getStorage", new Class[]{String.class, String.class}, new Object[]{regionName, storageId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findStorage(regionName, storageId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudStorage> getStoragesByRegion(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getStorages");
        try {
            this.validate("getStoragesByRegion", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findStoragesByRegion(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudStorageBackup addStorageBackup(@NotNull @IntoEntity CreateStorageBackupRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addStoreageBackup");
        try {
            this.validate("addStorageBackup", new Class[]{CreateStorageBackupRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().createStorageBackup(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeStorageBackup(@NotNull String regionName, @NotNull String snapshotId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeStorageBackup");
        try {
            this.validate("removeStorageBackup", new Class[]{String.class, String.class}, new Object[]{regionName, snapshotId}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().removeStorageBackup(regionName, snapshotId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudStorageBackup getStorageBackup(@NotNull String regionName, @NotNull String snapshotId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getStorageBackup");
        try {
            this.validate("getStorageBackup", new Class[]{String.class, String.class}, new Object[]{regionName, snapshotId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findStorageBackup(regionName, snapshotId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudStorageBackup> getStorageBackupsByRegion(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getStorageBackups");
        try {
            this.validate("getStorageBackupsByRegion", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findStorageBackupsByRegion(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstanceBackup addInstanceBackup(@NotNull @IntoEntity CreateInstanceBackupRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling addInstanceBackup");
        try {
            this.validate("addInstanceBackup", new Class[]{CreateInstanceBackupRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementExecute");
            return this.getCloudControllerLocal().createInstanceBackup(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeInstanceBackup(@NotNull String regionName, @NotNull String imageId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling removeInstanceBackup");
        try {
            this.validate("removeInstanceBackup", new Class[]{String.class, String.class}, new Object[]{regionName, imageId}, null);
            this.authCheck("CloudManagementExecute");
            this.getCloudControllerLocal().removeInstanceBackup(regionName, imageId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstanceBackup getInstanceBackup(@NotNull String regionName, @NotNull String imageId) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getInstanceBackup");
        try {
            this.validate("getInstanceBackup", new Class[]{String.class, String.class}, new Object[]{regionName, imageId}, null);
            this.authCheck("CloudManagementRead");
            return this.getCloudControllerLocal().findInstanceBackup(regionName, imageId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(@NotNull String regionName) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getInstanceBackups");
        try {
            this.validate("getInstanceBackupsByRegion", new Class[]{String.class}, new Object[]{regionName}, null);
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().findInstanceBackupsByRegion(regionName));
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstance registNode(@NotNull @IntoEntity RegistNodeRequest request) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling registNode");
        try {
            this.validate("registNode", new Class[]{RegistNodeRequest.class}, new Object[]{request}, null);
            this.authCheck("CloudManagementWrite");
            return this.getCloudControllerLocal().registNode(request);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void unregistNode(@NotNull String regionName, @NotNull String instanceId) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling registNode");
        try {
            this.validate("unregistNode", new Class[]{String.class, String.class}, new Object[]{regionName, instanceId}, null);
            this.authCheck("CloudManagementWrite");
            this.getCloudControllerLocal().unregistNode(regionName, instanceId);
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ValidationFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<String> getAllServiceName() throws InvalidUserPass, InvalidRole, CloudManagerFault {
        Logger.getLogger(CloudEndpointImpl.class).debug((Object)"calling getAllServiceName");
        try {
            this.authCheck("CloudManagementRead");
            return Arrays.asList(this.getCloudControllerLocal().getAllServiceName());
        }
        catch (InvalidUserPass e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InvalidRole e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CloudManagerFault e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger(CloudEndpointImpl.class).error((Object)e.getMessage(), (Throwable)e);
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudTemplate addTemplate(CloudTemplate template) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling addTemplate");
        try {
            this.validate("addTemplate", new Class[]{CloudTemplate.class}, new Object[]{template}, null);
            this.authCheck("CloudManagementWrite");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return controller.createTemplate(template);
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (InvalidRole e) {
            throw e;
        }
        catch (ValidationFault e) {
            throw e;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeTemplate(String templateId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling removeTemplate");
        try {
            this.authCheck("CloudManagementWrite");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            controller.removeTemplate(templateId);
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (InvalidRole e) {
            throw e;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void modifyTemplate(CloudTemplate template) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling modifyTemplate");
        try {
            this.validate("modifyTemplate", new Class[]{CloudTemplate.class}, new Object[]{template}, null);
            this.authCheck("CloudManagementWrite");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            controller.modifyTemplate(template);
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (InvalidRole e) {
            throw e;
        }
        catch (ValidationFault e) {
            throw e;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudTemplate getTemplate(String templateId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling getTemplate");
        try {
            this.authCheck("CloudManagementRead");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return controller.findTemplate(templateId);
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (InvalidRole e) {
            throw e;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<CloudTemplate> getAllTemplates() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling getTemplates");
        try {
            this.authCheck("CloudManagementRead");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return Arrays.asList(controller.findAllTemplates());
        }
        catch (InvalidUserPass e) {
            throw e;
        }
        catch (InvalidRole e) {
            throw e;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public List<String> getTemplateScripts() throws CloudManagerFault {
        Logger.getLogger(CloudEndpoint.class).debug((Object)"calling getTemplateScripts");
        try {
            this.validate("getTemplateScripts", new Class[0], new Object[0], null);
            this.authCheck("CloudManagementRead");
            CloudControllerLocal controller = this.getCloudControllerLocal();
            return Arrays.asList(controller.findTemplateScripts());
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }
}

