/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloud;

import com.clustercontrol.cloud.bean.AvailabilityZone;
import com.clustercontrol.cloud.bean.BillingAlarm;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.KeyPair;
import com.clustercontrol.cloud.bean.Region;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.SecurityGroup;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Subnet;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

@WebService(targetNamespace="http://cloud.ws.clustercontrol.com")
public interface CloudEndpoint {
    @WebMethod
    public CloudInstance addInstance(@WebParam(name="request") CreateInstanceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstance addInstanceByTemplate(CreateInstanceByTemplateRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstance restoreInstance(@WebParam(name="request") RestoreInstanceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeInstance(@WebParam(name="region") String var1, @WebParam(name="instanceId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstance getInstance(@WebParam(name="regionName") String var1, @WebParam(name="instanceId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudInstance> getInstancesByRegion(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public InstanceStateChange startInstance(@WebParam(name="request") StartInstanceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public InstanceStateChange stopInstance(@WebParam(name="request") StopInstanceRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public BillingAlarm addBillingAlarm(@WebParam(name="alarm") BillingAlarm var1) throws CloudManagerFault;

    @WebMethod
    public BillingAlarm getBillingAlarm(@WebParam(name="alarmId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeBillingAlarm(@WebParam(name="alarmId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<BillingAlarm> getAllBillingAlarm() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public BillingAlarm modifyBillingAlarm(@WebParam(name="billingAlarm") BillingAlarm var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudUser addCloudUser(@WebParam(name="cloudUser") CloudUser var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudUser getCloudUser(@WebParam(name="userId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudUser> getCloudUsers(@WebParam(name="filters") List<Filter> var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeCloudUser(@WebParam(name="userId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudUser> getAllCloudUser() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public CloudUser modifyCloudUser(@WebParam(name="cloudUser") CloudUser var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudType> getAllCloudType() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<Subnet> getSubnets(@WebParam(name="regionName") String var1, @WebParam(name="filters") List<Filter> var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<Region> getAllRegion() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<AvailabilityZone> getAvailabilityZones(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<Image> getImages(@WebParam(name="regionName") String var1, @WebParam(name="filters") List<Filter> var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<SecurityGroup> getSecurityGroupsByRegion(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<SecurityGroup> getSecurityGroups(@WebParam(name="regionName") String var1, @WebParam(name="filters") List<Filter> var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<String> getAllInstanceType() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getAllServiceName() throws InvalidUserPass, InvalidRole, CloudManagerFault;

    @WebMethod
    public List<KeyPair> getKeyNames(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public String getWindowsPassword(@WebParam(name="regionName") String var1, @WebParam(name="instanceId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<Snapshot> getSnapshots(@WebParam(name="regionName") String var1, @WebParam(name="filter") List<Filter> var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<String> getAllVolumeType() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public void attachStorage(@WebParam(name="regionName") String var1, @WebParam(name="instanceId") String var2, @WebParam(name="storageId") String var3, @WebParam(name="device") String var4) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void detachStorage(@WebParam(name="regionName") String var1, @WebParam(name="instanceId") String var2, @WebParam(name="storageId") String var3) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudStorage addStorage(@WebParam(name="request") CreateStorageRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudStorage restoreStorage(@WebParam(name="request") CreateStorageRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeStorage(@WebParam(name="regionName") String var1, @WebParam(name="storageId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudStorage getStorage(@WebParam(name="regionName") String var1, @WebParam(name="storageId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudStorage> getStoragesByRegion(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudStorageBackup addStorageBackup(@WebParam(name="request") CreateStorageBackupRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeStorageBackup(@WebParam(name="regionName") String var1, @WebParam(name="snapshotId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudStorageBackup getStorageBackup(@WebParam(name="regionName") String var1, @WebParam(name="snapshotId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudStorageBackup> getStorageBackupsByRegion(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstanceBackup addInstanceBackup(@WebParam(name="request") CreateInstanceBackupRequest var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeInstanceBackup(@WebParam(name="regionName") String var1, @WebParam(name="imageId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstanceBackup getInstanceBackup(@WebParam(name="regionName") String var1, @WebParam(name="imageId") String var2) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(@WebParam(name="regionName") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudInstance registNode(@WebParam(name="request") RegistNodeRequest var1) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault;

    @WebMethod
    public void unregistNode(@WebParam(name="regionName") String var1, @WebParam(name="instanceId") String var2) throws InvalidUserPass, InvalidRole, ValidationFault, CloudManagerFault;

    @WebMethod
    public CloudTemplate addTemplate(@WebParam(name="template") CloudTemplate var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void removeTemplate(@WebParam(name="templateId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public void modifyTemplate(@WebParam(name="template") CloudTemplate var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public CloudTemplate getTemplate(@WebParam(name="templateId") String var1) throws CloudManagerFault, InvalidUserPass, InvalidRole, ValidationFault;

    @WebMethod
    public List<CloudTemplate> getAllTemplates() throws CloudManagerFault, InvalidUserPass, InvalidRole;

    @WebMethod
    public List<String> getTemplateScripts() throws CloudManagerFault;
}

