/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.validation.CommonValidatorEx;
import com.clustercontrol.cloud.validation.ContainerValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.EntityValidatorImpl;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.MethodValidatorImpl;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationMessages;
import com.clustercontrol.cloud.validation.Validator;
import com.clustercontrol.cloud.validation.annotation.DoubleRange;
import com.clustercontrol.cloud.validation.annotation.FilterCondition;
import com.clustercontrol.cloud.validation.annotation.FilterListCondition;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IdentityNullAllow;
import com.clustercontrol.cloud.validation.annotation.IntRange;
import com.clustercontrol.cloud.validation.annotation.IntoEntity;
import com.clustercontrol.cloud.validation.annotation.ListElement;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.cloud.validation.annotation.Pattern;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.cloud.validation.annotation.ValidateNotifyRelationInfo;
import com.clustercontrol.commons.util.CommonValidator;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValidationUtil {
    private static EntityValidator entityValidator;
    private static MethodValidator methodValidator;

    public static synchronized EntityValidator getEntityValidator() {
        if (entityValidator == null) {
            entityValidator = new EntityValidatorImpl();
        }
        return entityValidator;
    }

    public static synchronized MethodValidator getMethodValidator() {
        if (methodValidator == null) {
            methodValidator = new MethodValidatorImpl();
        }
        return methodValidator;
    }

    public static class NotNullContainerValidator
    extends AbstractValidator<NotNullContainer, Object>
    implements ContainerValidator<NotNullContainer, Object> {
        @Override
        public void init(NotNullContainer annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        @Override
        protected void internalValidate(Object property, String group) throws ValidationFault {
            if (property == null) {
                throw this.createValidationFault(ValidationMessages.getString("validation.notnull.message", new Object[]{this.getElementString()}), null);
            }
        }
    }

    public static class ValidateNotifyRelationInfoValidator
    extends AbstractValidator<ValidateNotifyRelationInfo, NotifyRelationInfo> {
        @Override
        public void init(ValidateNotifyRelationInfo annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        @Override
        protected void internalValidate(NotifyRelationInfo property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            try {
                CommonValidator.validateNotifyId((String)property.getNotifyId(), (boolean)true);
            }
            catch (InvalidSetting e) {
                throw this.createValidationFault(e.getMessage(), null);
            }
            catch (Exception e) {
                throw this.createValidationFault(e.getMessage(), e, null);
            }
        }
    }

    public static class FilterListConditionValidator
    extends AbstractValidator<FilterListCondition, List<Filter>>
    implements ContainerValidator<FilterListCondition, List<Filter>> {
        String[] requiredFilters;

        @Override
        public void init(FilterListCondition annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.requiredFilters = annotation.requiredFilters();
        }

        @Override
        protected void internalValidate(List<Filter> property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            boolean doit = true;
            if (this.requiredFilters != null && this.requiredFilters.length > 0) {
                ArrayList<String> required = new ArrayList<String>(Arrays.asList(this.requiredFilters));
                Iterator requiredIter = required.iterator();
                block0: while (requiredIter.hasNext()) {
                    String filterName = (String)requiredIter.next();
                    for (Filter filter : property) {
                        if (!filter.getName().equals(filterName)) continue;
                        requiredIter.remove();
                        continue block0;
                    }
                }
                if (required.size() > 0) {
                    doit = false;
                }
            }
            if (!doit) {
                StringBuilder sb = new StringBuilder();
                for (String string : this.requiredFilters) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(string);
                }
                String filtersString = sb.toString();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("requiredFilters", filtersString);
                throw this.createValidationFault(ValidationMessages.getString("validation.filterListCondition.message", this.getElementString(), filtersString), params);
            }
        }
    }

    public static class FilterConditionValidator
    extends AbstractValidator<FilterCondition, Filter> {
        String[] filters;

        @Override
        public void init(FilterCondition annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.filters = annotation.filters();
        }

        @Override
        protected void internalValidate(Filter property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            String filterName = null;
            boolean doit = true;
            if (this.filters != null && this.filters.length > 0) {
                doit = false;
                for (String f : this.filters) {
                    filterName = property.getName();
                    if (!f.equals(filterName)) continue;
                    doit = true;
                    break;
                }
            }
            if (!doit) {
                StringBuilder sb = new StringBuilder();
                for (String f : this.filters) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(f);
                }
                String filtersString = sb.toString();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("filters", filtersString);
                throw this.createValidationFault(ValidationMessages.getString("validation.filterCondition.message", this.getElementString(), filterName, filtersString), params);
            }
        }
    }

    public static class ListElementValidator
    extends AbstractValidator<ListElement, List<?>> {
        @Override
        public void init(ListElement annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        @Override
        protected void internalValidate(List<?> property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            try {
                for (Object element : property) {
                    ValidationUtil.getEntityValidator().validate(element, group);
                }
            }
            catch (ValidationFault e) {
                throw this.createValidationFault(ValidationMessages.getString("validation.listElement.message", new Object[]{this.getElementString()}), e, null);
            }
        }
    }

    public static class IntoEntityValidator
    extends AbstractValidator<IntoEntity, Object> {
        @Override
        public void init(IntoEntity annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        @Override
        protected void internalValidate(Object property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            ValidationUtil.getEntityValidator().validate(property, group);
        }
    }

    public static class NotNullValidator
    extends AbstractValidator<NotNull, Object> {
        @Override
        public void init(NotNull annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        @Override
        protected void internalValidate(Object property, String group) throws ValidationFault {
            if (property == null) {
                throw this.createValidationFault(ValidationMessages.getString("validation.notnull.message", new Object[]{this.getElementString()}), null);
            }
        }
    }

    public static class IdNullAllowValidator
    extends AbstractValidator<IdentityNullAllow, String> {
        private int max;

        @Override
        public void init(IdentityNullAllow annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.max = annotation.max();
        }

        @Override
        protected void internalValidate(String property, String group) throws ValidationFault {
            if (property == null || property.isEmpty()) {
                return;
            }
            try {
                CommonValidatorEx.validateId((String)this.getElementString(), (String)property, (int)this.max);
            }
            catch (InvalidSetting e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("max", String.valueOf(this.max));
                throw this.createValidationFault(e.getMessage(), params);
            }
        }
    }

    public static class PatternValidator
    extends AbstractValidator<Pattern, String> {
        private java.util.regex.Pattern pattern;

        @Override
        public void init(Pattern annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.pattern = java.util.regex.Pattern.compile(annotation.pattern());
        }

        @Override
        protected void internalValidate(String property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            if (!this.pattern.matcher(property).matches()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("pattern", this.pattern.pattern());
                throw this.createValidationFault(ValidationMessages.getString("validation.pattern.message", this.getElementString(), this.pattern), params);
            }
        }
    }

    public static class DoubleRangeValidator
    extends AbstractValidator<DoubleRange, Double> {
        private double min;
        private double max;

        @Override
        public void init(DoubleRange annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.min = annotation.min();
            this.max = annotation.max();
        }

        @Override
        protected void internalValidate(Double property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            try {
                CommonValidatorEx.validateDouble((String)this.getElementString(), (double)property, (double)this.min, (double)this.max);
            }
            catch (InvalidSetting e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("min", String.valueOf(this.min));
                params.put("max", String.valueOf(this.max));
                throw this.createValidationFault(e.getMessage(), params);
            }
        }
    }

    public static class IntRangeValidator<T extends Number>
    extends AbstractValidator<IntRange, T> {
        private long min;
        private long max;

        @Override
        public void init(IntRange annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.min = annotation.min();
            this.max = annotation.max();
        }

        @Override
        protected void internalValidate(T property, String group) throws ValidationFault {
            if (property == null) {
                return;
            }
            try {
                CommonValidatorEx.validateLong(this.getElementString(), ((Number)property).longValue(), this.min, this.max);
            }
            catch (InvalidSetting e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("min", String.valueOf(this.min));
                params.put("max", String.valueOf(this.max));
                throw this.createValidationFault(e.getMessage(), params);
            }
        }
    }

    public static class SizeValidator
    extends AbstractValidator<Size, String> {
        private int min;
        private int max;

        @Override
        public void init(Size annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.max = annotation.max();
            this.min = annotation.min();
        }

        @Override
        protected void internalValidate(String property, String group) throws ValidationFault {
            try {
                CommonValidatorEx.validateString((String)this.getElementString(), (String)property, (boolean)false, (int)this.min, (int)this.max);
            }
            catch (InvalidSetting e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("min", String.valueOf(this.min));
                params.put("max", String.valueOf(this.max));
                throw this.createValidationFault(e.getMessage(), params);
            }
        }
    }

    public static class IdentityValidator
    extends AbstractValidator<Identity, String> {
        private int max;

        @Override
        public void init(Identity annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
            this.max = annotation.max();
        }

        @Override
        protected void internalValidate(String property, String group) throws ValidationFault {
            try {
                CommonValidatorEx.validateId((String)this.getElementString(), (String)property, (int)this.max);
            }
            catch (InvalidSetting e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("max", String.valueOf(this.max));
                throw this.createValidationFault(e.getMessage(), params);
            }
        }
    }

    public static abstract class AbstractValidator<A extends Annotation, T>
    implements Validator<A, T> {
        private String elementId;
        private String validationId;
        private String[] groups;

        @Override
        public String getElementId() {
            return this.elementId;
        }

        @Override
        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public String getValidationId() {
            return this.validationId;
        }

        @Override
        public void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        @Override
        public String[] getGroups() {
            return this.groups;
        }

        @Override
        public void setGroups(String[] groups) {
            this.groups = groups == null ? new String[]{} : groups;
        }

        @Override
        public void validate(T property, String group) throws ValidationFault {
            if (this.groups != null && this.groups.length != 0) {
                if (group == null) {
                    return;
                }
                boolean doit = false;
                for (String g : this.groups) {
                    if (!g.equals(group)) continue;
                    doit = true;
                    break;
                }
                if (!doit) {
                    return;
                }
            }
            this.internalValidate(property, group);
        }

        protected abstract void internalValidate(T var1, String var2) throws ValidationFault;

        protected ValidationFault createValidationFault(String message, Map<String, String> params) {
            ValidationFault v = new ValidationFault(message);
            v.setElementId(this.getElementId());
            v.setValidationId(this.getValidationId());
            if (params != null) {
                v.getParameter().putAll(params);
            }
            return v;
        }

        protected ValidationFault createValidationFault(String message, Exception e, Map<String, String> params) {
            ValidationFault v = new ValidationFault(message, e);
            v.setElementId(this.getElementId());
            v.setValidationId(this.getValidationId());
            if (params != null) {
                v.getParameter().putAll(params);
            }
            return v;
        }

        protected String getElementString() {
            return ValidationMessages.getString(this.getElementId());
        }

        protected String getValidationMessage() {
            return ValidationMessages.getString(this.getElementId());
        }
    }
}

