/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.amazonaws.services.ec2.model.IpPermission;
import com.clustercontrol.cloud.bean.SecurityGroup;
import com.clustercontrol.cloud.bean.UserIdGroupPair;
import java.util.ArrayList;

public class SecurityGroupUtil {
    public static SecurityGroup convertToSecrurityGroup(String region, com.amazonaws.services.ec2.model.SecurityGroup awsSg) {
        SecurityGroup sg = new SecurityGroup();
        sg.setOwnerId(awsSg.getOwnerId());
        sg.setGroupId(awsSg.getGroupId());
        sg.setGroupName(awsSg.getGroupName());
        sg.setDescription(awsSg.getDescription());
        sg.setVpcId(awsSg.getVpcId());
        ArrayList<com.clustercontrol.cloud.bean.IpPermission> ipPermissions = new ArrayList<com.clustercontrol.cloud.bean.IpPermission>();
        for (IpPermission awsIpPermission : awsSg.getIpPermissions()) {
            com.clustercontrol.cloud.bean.IpPermission ipPermission = SecurityGroupUtil.convertToIpPermission(awsIpPermission);
            ipPermissions.add(ipPermission);
        }
        sg.setIpPermissions(ipPermissions);
        ArrayList<com.clustercontrol.cloud.bean.IpPermission> ipPermissionsEgress = new ArrayList<com.clustercontrol.cloud.bean.IpPermission>();
        for (IpPermission awsIpPermission : awsSg.getIpPermissionsEgress()) {
            com.clustercontrol.cloud.bean.IpPermission ipPermission = SecurityGroupUtil.convertToIpPermission(awsIpPermission);
            ipPermissionsEgress.add(ipPermission);
        }
        sg.setIpPermissionsEgress(ipPermissionsEgress);
        return sg;
    }

    public static com.clustercontrol.cloud.bean.IpPermission convertToIpPermission(IpPermission awsIpPermission) {
        com.clustercontrol.cloud.bean.IpPermission ipPermission = new com.clustercontrol.cloud.bean.IpPermission();
        ipPermission.setFromPort(awsIpPermission.getFromPort());
        ipPermission.setToPort(awsIpPermission.getToPort());
        ipPermission.setIpProtocol(awsIpPermission.getIpProtocol());
        ipPermission.setIpRanges(awsIpPermission.getIpRanges());
        ArrayList<UserIdGroupPair> userIdGroupPairs = new ArrayList<UserIdGroupPair>();
        for (com.amazonaws.services.ec2.model.UserIdGroupPair uig : awsIpPermission.getUserIdGroupPairs()) {
            UserIdGroupPair pair = new UserIdGroupPair();
            pair.setGroupId(uig.getGroupId());
            pair.setGroupName(uig.getGroupName());
            pair.setUserId(uig.getUserId());
        }
        ipPermission.setUserIdGroupPairs(userIdGroupPairs);
        return ipPermission;
    }
}

