/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.repository.bean.NodeDiskInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocalHome;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;

public class HinemosUtil {
    public static final String awsRootScopeId = "AWS";
    public static final String awsRootScopeName = "AmazonWebService";

    public static ScopeInfo createScope(String facilityId, String facilityName) {
        ScopeInfo scope = new ScopeInfo();
        scope.setFacilityName(facilityName);
        scope.setFacilityId(facilityId);
        scope.setFacilityType(Integer.valueOf(0));
        scope.setDisplaySortOrder(Integer.valueOf(100));
        scope.setValid(Boolean.valueOf(true));
        scope.setCreateDatetime(Long.valueOf(System.currentTimeMillis()));
        scope.setModifyDatetime(Long.valueOf(System.currentTimeMillis()));
        scope.setBuiltInFlg(Boolean.valueOf(false));
        return scope;
    }

    public static NodeInfo createNodeInfo(String facilityId, String facilityName, String nodeName, String description, String cloudId, String region, String instanceId, String availabilityZone, String platform) {
        NodeInfo nodeInfo = new NodeInfo();
        HinemosUtil.setDefaultValue(nodeInfo);
        nodeInfo.setFacilityId(facilityId);
        nodeInfo.setFacilityName(facilityName);
        nodeInfo.setPlatformFamily(platform == null ? "LINUX" : "WINDOWS");
        nodeInfo.setIpAddressVersion(Integer.valueOf(4));
        nodeInfo.setIpAddressV4("123.123.123.123");
        nodeInfo.setNodeName(nodeName);
        nodeInfo.setDescription(description);
        nodeInfo.setNodeVariableInfo(new ArrayList());
        NodeVariableInfo nvi1 = new NodeVariableInfo();
        nvi1.setNodeVariableName("cloudId");
        nvi1.setNodeVariableValue(cloudId);
        nodeInfo.getNodeVariableInfo().add(nvi1);
        NodeVariableInfo nvi2 = new NodeVariableInfo();
        nvi2.setNodeVariableName("instanceId");
        nvi2.setNodeVariableValue(instanceId);
        nodeInfo.getNodeVariableInfo().add(nvi2);
        NodeVariableInfo nvi3 = new NodeVariableInfo();
        nvi3.setNodeVariableName("instanceType");
        nvi3.setNodeVariableValue("EC2");
        nodeInfo.getNodeVariableInfo().add(nvi3);
        NodeVariableInfo nvi4 = new NodeVariableInfo();
        nvi4.setNodeVariableName("region");
        nvi4.setNodeVariableValue(region);
        nodeInfo.getNodeVariableInfo().add(nvi4);
        NodeVariableInfo nvi5 = new NodeVariableInfo();
        nvi5.setNodeVariableName("availabilityZone");
        nvi5.setNodeVariableValue(availabilityZone);
        nodeInfo.getNodeVariableInfo().add(nvi5);
        return nodeInfo;
    }

    public static NodeInfo resetNodeInfo(NodeInfo nodeInfo, String facilityName, String nodeName, String description, String cloudId, String region, String instanceId, String availabilityZone, String platform) {
        nodeInfo.setFacilityName(facilityName);
        nodeInfo.setPlatformFamily(platform == null ? "LINUX" : "WINDOWS");
        nodeInfo.setIpAddressVersion(Integer.valueOf(4));
        nodeInfo.setIpAddressV4("123.123.123.123");
        nodeInfo.setNodeName(nodeName);
        nodeInfo.setDescription(description);
        nodeInfo.setNodeVariableInfo(new ArrayList());
        NodeVariableInfo nvi1 = new NodeVariableInfo();
        nvi1.setNodeVariableName("cloudId");
        nvi1.setNodeVariableValue(cloudId);
        nodeInfo.getNodeVariableInfo().add(nvi1);
        NodeVariableInfo nvi2 = new NodeVariableInfo();
        nvi2.setNodeVariableName("instanceId");
        nvi2.setNodeVariableValue(instanceId);
        nodeInfo.getNodeVariableInfo().add(nvi2);
        NodeVariableInfo nvi3 = new NodeVariableInfo();
        nvi3.setNodeVariableName("instanceType");
        nvi3.setNodeVariableValue("EC2");
        nodeInfo.getNodeVariableInfo().add(nvi3);
        NodeVariableInfo nvi4 = new NodeVariableInfo();
        nvi4.setNodeVariableName("region");
        nvi4.setNodeVariableValue(region);
        nodeInfo.getNodeVariableInfo().add(nvi4);
        NodeVariableInfo nvi5 = new NodeVariableInfo();
        nvi5.setNodeVariableName("availabilityZone");
        nvi5.setNodeVariableValue(availabilityZone);
        nodeInfo.getNodeVariableInfo().add(nvi5);
        ArrayList disklist = new ArrayList();
        nodeInfo.setNodeDiskInfo(disklist);
        return nodeInfo;
    }

    public static void clearNodeInfo(NodeInfo nodeInfo) {
        String[] names;
        nodeInfo.setNodeVariableInfo(new ArrayList(nodeInfo.getNodeVariableInfo()));
        block0: for (String name : names = new String[]{"cloudId", "instanceId", "instanceType", "region", "availabilityZone"}) {
            for (int i = 0; i < nodeInfo.getNodeVariableInfo().size(); ++i) {
                NodeVariableInfo info = (NodeVariableInfo)nodeInfo.getNodeVariableInfo().get(i);
                if (!info.getNodeVariableName().equals(name)) continue;
                nodeInfo.getNodeVariableInfo().remove(i);
                continue block0;
            }
        }
        nodeInfo.setNodeDiskInfo(new ArrayList(nodeInfo.getNodeDiskInfo()));
        Iterator iter = nodeInfo.getNodeDiskInfo().iterator();
        while (iter.hasNext()) {
            NodeDiskInfo info = (NodeDiskInfo)iter.next();
            if (!info.getDeviceDescription().startsWith("storageId=")) continue;
            iter.remove();
        }
    }

    public static void attachScope(RepositoryControllerLocal repositoryController, String regionName, String availabilityZone, String facilityId) throws CloudManagerFault {
        try {
            try {
                repositoryController.assignNodeScope(availabilityZone, new String[]{facilityId});
            }
            catch (InvalidSetting e) {
                ScopeInfo scopeInfo;
                try {
                    repositoryController.getScope(awsRootScopeId);
                }
                catch (FacilityNotFound e1) {
                    scopeInfo = HinemosUtil.createScope(awsRootScopeId, awsRootScopeName);
                    repositoryController.addScope(null, scopeInfo);
                }
                try {
                    repositoryController.getScope(regionName);
                }
                catch (FacilityNotFound e1) {
                    scopeInfo = HinemosUtil.createScope(regionName, regionName);
                    repositoryController.addScope(awsRootScopeId, scopeInfo);
                }
                try {
                    repositoryController.getScope(availabilityZone);
                }
                catch (FacilityNotFound e1) {
                    scopeInfo = HinemosUtil.createScope(availabilityZone, availabilityZone);
                    repositoryController.addScope(regionName, scopeInfo);
                }
                repositoryController.assignNodeScope(availabilityZone, new String[]{facilityId});
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public static void setDefaultValue(NodeInfo nodeInfo) {
        nodeInfo.setFacilityType(Integer.valueOf(1));
        nodeInfo.setDisplaySortOrder(Integer.valueOf(100));
        if (nodeInfo.getFacilityId() == null) {
            nodeInfo.setFacilityId("");
        }
        if (nodeInfo.getFacilityName() == null) {
            nodeInfo.setFacilityName("");
        }
        if (nodeInfo.getDescription() == null) {
            nodeInfo.setDescription("");
        }
        if (nodeInfo.isValid() == null) {
            nodeInfo.setValid(Boolean.TRUE);
        }
        if (nodeInfo.getCreateUserId() == null) {
            nodeInfo.setCreateUserId("");
        }
        if (nodeInfo.getCreateDatetime() == null) {
            nodeInfo.setCreateDatetime(null);
        }
        if (nodeInfo.getModifyUserId() == null) {
            nodeInfo.setModifyUserId("");
        }
        if (nodeInfo.getModifyDatetime() == null) {
            nodeInfo.setModifyDatetime(null);
        }
        if (nodeInfo.getPlatformFamily() == null) {
            nodeInfo.setPlatformFamily("");
        }
        if (nodeInfo.getHardwareType() == null) {
            nodeInfo.setHardwareType("");
        }
        if (nodeInfo.getIconImage() == null) {
            nodeInfo.setIconImage("");
        }
        if (nodeInfo.getIpAddressVersion() == null) {
            nodeInfo.setIpAddressVersion(Integer.valueOf(-1));
        }
        if (nodeInfo.getIpAddressV4() == null) {
            nodeInfo.setIpAddressV4("");
        }
        if (nodeInfo.getIpAddressV6() == null) {
            nodeInfo.setIpAddressV6("");
        }
        if (nodeInfo.getNodeName() == null) {
            nodeInfo.setNodeName("");
        }
        if (nodeInfo.getOsName() == null) {
            nodeInfo.setOsName("");
        }
        if (nodeInfo.getOsRelease() == null) {
            nodeInfo.setOsRelease("");
        }
        if (nodeInfo.getOsVersion() == null) {
            nodeInfo.setOsVersion("");
        }
        if (nodeInfo.getCharacterSet() == null) {
            nodeInfo.setCharacterSet("");
        }
        if (nodeInfo.getSnmpPort() == null) {
            nodeInfo.setSnmpPort(Integer.valueOf(161));
        }
        if (nodeInfo.getSnmpCommunity() == null) {
            nodeInfo.setSnmpCommunity("public");
        }
        if (nodeInfo.getSnmpVersion() == null) {
            nodeInfo.setSnmpVersion("2c");
        }
        if (nodeInfo.getSnmpTimeout() == null || nodeInfo.getSnmpTimeout() == -1) {
            nodeInfo.setSnmpTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getSnmpRetryCount() == null || nodeInfo.getSnmpRetryCount() == -1) {
            nodeInfo.setSnmpRetryCount(Integer.valueOf(3));
        }
        if (nodeInfo.getSnmpProxy() == null) {
            nodeInfo.setSnmpProxy("");
        }
        if (nodeInfo.getWbemUser() == null || "".equals(nodeInfo.getWbemUser())) {
            nodeInfo.setWbemUser("root");
        }
        if (nodeInfo.getWbemUserPassword() == null) {
            nodeInfo.setWbemUserPassword("");
        }
        if (nodeInfo.getWbemPort() == null || nodeInfo.getWbemPort() == -1) {
            nodeInfo.setWbemPort(Integer.valueOf(5988));
        }
        if (nodeInfo.getWbemProtocol() == null || "".equals(nodeInfo.getWbemProtocol())) {
            nodeInfo.setWbemProtocol("http");
        }
        if (nodeInfo.getWbemTimeout() == null || nodeInfo.getWbemTimeout() == -1) {
            nodeInfo.setWbemTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getWbemRetryCount() == null || nodeInfo.getWbemRetryCount() == -1) {
            nodeInfo.setWbemRetryCount(Integer.valueOf(3));
        }
        if (nodeInfo.getIpmiIpAddress() == null) {
            nodeInfo.setIpmiIpAddress("");
        }
        if (nodeInfo.getIpmiPort() == null || nodeInfo.getIpmiPort() == -1) {
            nodeInfo.setIpmiPort(Integer.valueOf(0));
        }
        if (nodeInfo.getIpmiUser() == null) {
            nodeInfo.setIpmiUser("");
        }
        if (nodeInfo.getIpmiUserPassword() == null) {
            nodeInfo.setIpmiUserPassword("");
        }
        if (nodeInfo.getIpmiTimeout() == null || nodeInfo.getIpmiTimeout() == -1) {
            nodeInfo.setIpmiTimeout(Integer.valueOf(0));
        }
        if (nodeInfo.getIpmiRetries() == null || nodeInfo.getIpmiRetries() == -1) {
            nodeInfo.setIpmiRetries(Integer.valueOf(3));
        }
        if (nodeInfo.getIpmiProtocol() == null || "".equals(nodeInfo.getIpmiProtocol())) {
            nodeInfo.setIpmiProtocol("RMCP+");
        }
        if (nodeInfo.getIpmiLevel() == null) {
            nodeInfo.setIpmiLevel("");
        }
        if (nodeInfo.getWinrmUser() == null) {
            nodeInfo.setWinrmUser("");
        }
        if (nodeInfo.getWinrmUserPassword() == null) {
            nodeInfo.setWinrmUserPassword("");
        }
        if (nodeInfo.getWinrmVersion() == null || "".equals(nodeInfo.getWinrmVersion())) {
            nodeInfo.setWinrmVersion("2.0");
        }
        if (nodeInfo.getWinrmPort() == null || nodeInfo.getWinrmPort() == -1) {
            nodeInfo.setWinrmPort(Integer.valueOf(5985));
        }
        if (nodeInfo.getWinrmProtocol() == null || "".equals(nodeInfo.getWinrmProtocol())) {
            nodeInfo.setWinrmProtocol("http");
        }
        if (nodeInfo.getWinrmTimeout() == null || nodeInfo.getWinrmTimeout() == -1) {
            nodeInfo.setWinrmTimeout(Integer.valueOf(5000));
        }
        if (nodeInfo.getWinrmRetries() == null || nodeInfo.getWinrmRetries() == -1) {
            nodeInfo.setWinrmRetries(Integer.valueOf(3));
        }
        if (nodeInfo.getVirtualizationNodeType() == null) {
            nodeInfo.setVirtualizationNodeType("");
        }
        if (nodeInfo.getVmManagementNode() == null) {
            nodeInfo.setVmManagementNode("");
        }
        if (nodeInfo.getVmIndex() == null) {
            nodeInfo.setVmIndex(Integer.valueOf(-1));
        }
        if (nodeInfo.getVmName() == null) {
            nodeInfo.setVmName("");
        }
        if (nodeInfo.getVirtualizationSolution() == null) {
            nodeInfo.setVirtualizationSolution("");
        }
        if (nodeInfo.getVmId() == null) {
            nodeInfo.setVmId("");
        }
        if (nodeInfo.getVmUser() == null) {
            nodeInfo.setVmUser("");
        }
        if (nodeInfo.getVmUserPassword() == null) {
            nodeInfo.setVmUserPassword("");
        }
        if (nodeInfo.getVmProtocol() == null) {
            nodeInfo.setVmProtocol("");
        }
        if (nodeInfo.getOpenFlowDataPathId() == null) {
            nodeInfo.setOpenFlowDataPathId("");
        }
        if (nodeInfo.getOpenFlowCtrlIpAddress() == null) {
            nodeInfo.setOpenFlowCtrlIpAddress("");
        }
        if (nodeInfo.getAdministrator() == null) {
            nodeInfo.setAdministrator("");
        }
        if (nodeInfo.getContact() == null) {
            nodeInfo.setContact("");
        }
    }

    public static String getFacilityName(RepositoryControllerLocal repositoryController, String facilityId) {
        try {
            NodeInfo nodeInfo = repositoryController.getNode(facilityId);
            return nodeInfo.getFacilityName();
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(HinemosUtil.class);
            logger.error((Object)("Not got facilityId (" + facilityId + ")"));
            return null;
        }
    }

    public static String getFacilityName(String facilityId) {
        try {
            RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
            RepositoryControllerLocal repositoryLocal = repositoryHome.create();
            return HinemosUtil.getFacilityName(repositoryLocal, facilityId);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(HinemosUtil.class);
            logger.error((Object)("Not got facilityId (" + facilityId + ")"));
            return null;
        }
    }
}

