/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmazonResourceNameUtil {
    public static String getAccountIdFromIAM(String arn) {
        return new AMIArn((String)arn).accountId;
    }

    public static class AMIArn {
        public static final String root = "root";
        public static final String userPrefix = "user/";
        public String arn;
        public String accountId;
        public String userName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AMIArn(String arn) {
            Pattern p = Pattern.compile("^arn:aws:iam::([0-9]+):(.+)$");
            Matcher m = p.matcher(arn);
            if (!m.matches()) throw new IllegalStateException();
            this.accountId = m.group(1);
            this.userName = m.group(2);
            if (root.equals(this.userName)) return;
            if (!this.userName.startsWith(userPrefix)) throw new IllegalStateException();
            this.userName = this.userName.substring(userPrefix.length());
        }

        public boolean isRoot() {
            return root.equals(this.userName);
        }
    }
}

