/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class AWSUtil {
    public static String getAccountIdFromIAM(String arn) {
        return new AMIArn((String)arn).accountId;
    }

    public static void addTag(AmazonEC2 ec2, String resourceId, String key, String value) {
        AWSUtil.addTags(ec2, resourceId, new Tag(key, value));
    }

    public static void addTags(AmazonEC2 ec2, String resourceId, List<Tag> tags) {
        AWSUtil.addTags(ec2, resourceId, tags.toArray(new Tag[0]));
    }

    public static void addTags(AmazonEC2 ec2, String resourceId, Tag ... tags) {
        int count = 0;
        while (true) {
            try {
                CreateTagsRequest createTagsRequest = new CreateTagsRequest();
                createTagsRequest.withTags(tags).withResources(new String[]{resourceId});
                ec2.createTags(createTagsRequest);
            }
            catch (AmazonServiceException e) {
                Logger logger = Logger.getLogger(AWSUtil.class);
                logger.debug((Object)e.getMessage(), (Throwable)e);
                if (++count == 3) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            break;
        }
    }

    public static class AMIArn {
        public static final String root = "root";
        public static final String userPrefix = "user/";
        public String arn;
        public String accountId;
        public String userName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AMIArn(String arn) {
            Pattern p = Pattern.compile("^arn:aws:iam::([0-9]+):(.+)$");
            Matcher m = p.matcher(arn);
            if (!m.matches()) throw new IllegalStateException();
            this.accountId = m.group(1);
            this.userName = m.group(2);
            if (root.equals(this.userName)) return;
            if (!this.userName.startsWith(userPrefix)) throw new IllegalStateException();
            this.userName = this.userName.substring(userPrefix.length());
        }

        public boolean isRoot() {
            return root.equals(this.userName);
        }
    }
}

