/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.jmx;

import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.AlarmServiceManager;
import com.clustercontrol.cloud.factory.AutoDetectionServiceManager;
import com.clustercontrol.cloud.jmx.CloudServiceMBean;
import com.clustercontrol.commons.jmx.HinemosService;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.ws.cloud.CloudEndpointImpl;
import com.sun.net.httpserver.HttpsServer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.ws.Endpoint;
import org.jboss.system.ServiceMBeanSupport;

public class CloudService
extends ServiceMBeanSupport
implements CloudServiceMBean {
    private static ArrayList<Endpoint> endpointList = new ArrayList();

    public void createService() throws Exception {
        this.log.info((Object)"creating a MBean of CloudService...");
        this.log.info((Object)"successful in creating a MBean of CloudService...");
        for (CloudPropertyConstants value : CloudPropertyConstants.values()) {
            this.log.info((Object)(value.id + " = " + value.value() + " (" + value.defaultValue() + ")"));
        }
    }

    public void startService() throws Exception {
        String mode = null;
        this.log.info((Object)"starting a MBean of CloudService...");
        mode = System.getProperty("hinemos.manager.mode");
        if (mode != null && mode.equals("maintenance")) {
            this.log.info((Object)"do nothing, because of maintenance mode.");
        }
        this.publish("/HinemosWS/CloudEndpoint", new CloudEndpointImpl());
        this.log.info((Object)"successful in starting a MBean of CloudService...");
        AlarmServiceManager.getService().start();
        AutoDetectionServiceManager.getService().start();
    }

    private void publish(String postAddress, Object endpointInstance) {
        String preAddress = HinemosProperties.getProperty((String)"common.ws.address", (String)"http://0.0.0.0:8080");
        URL url = null;
        try {
            url = new URL(preAddress);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if ("https".equals(url.getProtocol())) {
            HttpsServer server = null;
            Field field = null;
            Boolean accesible = null;
            try {
                field = HinemosService.class.getDeclaredField("httpsServer");
                accesible = field.isAccessible();
                field.setAccessible(true);
                server = (HttpsServer)field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (accesible != null) {
                    field.setAccessible(accesible);
                }
            }
            ThreadPoolExecutor _threadPool = null;
            Field field2 = null;
            Boolean accesible2 = null;
            try {
                field2 = HinemosService.class.getDeclaredField("_threadPool");
                accesible2 = field2.isAccessible();
                field2.setAccessible(true);
                _threadPool = (ThreadPoolExecutor)field2.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (accesible2 != null) {
                    field2.setAccessible(accesible2);
                }
            }
            String address = preAddress + postAddress;
            this.log.info((Object)("publish " + address));
            Endpoint endpoint = Endpoint.create((Object)endpointInstance);
            endpoint.setExecutor((Executor)_threadPool);
            endpoint.publish((Object)server.createContext(postAddress));
            endpointList.add(endpoint);
        } else {
            try {
                String address = preAddress + postAddress;
                this.log.info((Object)("publish " + address));
                endpointList.add(Endpoint.publish((String)address, (Object)endpointInstance));
            }
            catch (Exception e) {
                this.log.error((Object)("publish " + e.getClass().getSimpleName() + ", " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void stopService() throws Exception {
        this.log.info((Object)"stopping a MBean of CloudService...");
        AlarmServiceManager.getService().stop();
        for (Endpoint endpoint : endpointList) {
            this.log.info((Object)"endpoint stop");
            try {
                endpoint.stop();
            }
            catch (Exception e) {
                this.log.warn((Object)("stop endpoint : " + e.getMessage()));
            }
        }
        this.log.info((Object)"successful in stopping a MBean of CloudService...");
    }

    public void destroyService() throws Exception {
        this.log.info((Object)"destroying a MBean of CloudService...");
        this.log.info((Object)"successful in destroying a MBean of CloudService...");
    }
}

