/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AttachVolumeResult;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.StorageRegistStateType;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudInstancePK;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceUtil;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupPK;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupUtil;
import com.clustercontrol.cloud.ejb.entity.CloudStorageData;
import com.clustercontrol.cloud.ejb.entity.CloudStorageLocal;
import com.clustercontrol.cloud.ejb.entity.CloudStorageLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudStoragePK;
import com.clustercontrol.cloud.ejb.entity.CloudStorageUtil;
import com.clustercontrol.cloud.ejb.entity.CloudTypeLocal;
import com.clustercontrol.cloud.ejb.entity.CloudTypeUtil;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.CloudCommandFacade;
import com.clustercontrol.cloud.factory.InstanceOperator;
import com.clustercontrol.cloud.util.aws.AWSErrorCode;
import com.clustercontrol.cloud.util.aws.AWSUtil;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import com.clustercontrol.cloud.util.aws.HinemosUtil;
import com.clustercontrol.repository.bean.NodeDiskInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocalHome;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.FinderException;
import org.jboss.logging.Logger;

public class StorageOperator {
    private Logger logger;
    private CloudUser user;
    private CloudTypeLocal cloudType;
    private RepositoryControllerLocal repositoryLocal;
    private CloudStorageLocalHome cloudStorageLocalHome;
    private boolean update;
    private boolean regist;
    private boolean mount;

    private StorageOperator(CloudUser user, boolean update, boolean regist, boolean mount) throws CloudManagerFault {
        assert (user != null);
        this.user = user;
        assert (this.cloudType != null);
        this.update = update;
        this.regist = regist;
        this.mount = mount;
    }

    public CloudStorage createStorage(CreateStorageRequest request) throws CloudManagerFault {
        AmazonEC2 ec2 = this.getAmazonEC2(request.getRegion());
        Volume volume = null;
        boolean success = false;
        try {
            CreateVolumeRequest awsRequest = new CreateVolumeRequest().withAvailabilityZone(request.getAvailabilityZone()).withIops(request.getIops()).withSize(request.getStorageSize()).withSnapshotId(request.getSnapshotId()).withVolumeType(request.getStorageKind());
            CreateVolumeResult result = ec2.createVolume(awsRequest);
            volume = result.getVolume();
            AWSUtil.addTag(ec2, volume.getVolumeId(), "Name", request.getStorageName());
            CloudStorageLocal cloudStorage = this.createCloudStorageLocal(volume, request.getRegion(), request.getStorageName());
            success = true;
            CloudStorage cloudStorage2 = new CloudStorage(cloudStorage.getDetail(), volume, null);
            return cloudStorage2;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        finally {
            if (!success && volume != null) {
                try {
                    DeleteVolumeRequest awsRequest = new DeleteVolumeRequest().withVolumeId(volume.getSnapshotId());
                    ec2.deleteVolume(awsRequest);
                }
                catch (Exception e) {}
            }
        }
    }

    public CloudStorage restoreStorage(CreateStorageRequest request) throws CloudManagerFault {
        CloudStorageBackupLocal backup = null;
        try {
            backup = CloudStorageBackupUtil.getLocalHome().findByPrimaryKey(new CloudStorageBackupPK(request.getSnapshotId(), AWSUtil.getAccountIdFromIAM(this.getCloudUser().getCloudResourceId()), request.getRegion()));
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        CreateStorageRequest createRequest = new CreateStorageRequest();
        createRequest.setRegion(backup.getRegion());
        createRequest.setAvailabilityZone(request.getAvailabilityZone() != null ? request.getAvailabilityZone() : backup.getAvailabilityZone());
        createRequest.setSnapshotId(request.getSnapshotId());
        createRequest.setStorageName(request.getStorageName() != null ? request.getStorageName() : backup.getStorageName());
        createRequest.setStorageSize(request.getStorageSize() != null ? request.getStorageSize() : backup.getStorageSize());
        createRequest.setStorageKind(request.getStorageKind());
        createRequest.setIops(request.getIops());
        return this.createStorage(createRequest);
    }

    public void removeStorage(String regionName, final String storageId) throws CloudManagerFault {
        try {
            DeleteVolumeRequest awsRequest;
            Logger logger;
            CloudStorageLocal storageLocal = null;
            CloudStorageLocalHome home = CloudStorageUtil.getLocalHome();
            try {
                storageLocal = home.findByPrimaryKey(new CloudStoragePK(storageId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                logger = Logger.getLogger(this.getClass());
                logger.debug((Object)("Not exist storage(" + storageId + ")."));
            }
            if (storageLocal != null) {
                switch (StorageRegistStateType.byNumber(storageLocal.getRegistStatus())) {
                    case exist: {
                        try {
                            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                            awsRequest = new DeleteVolumeRequest().withVolumeId(storageId);
                            ec2.deleteVolume(awsRequest);
                            break;
                        }
                        catch (AmazonServiceException e) {
                            if (AWSErrorCode.InvalidVolume_NotFound.match(e.getErrorCode()) || AWSErrorCode.OperationNotPermitted.match(e.getErrorCode())) {
                                logger = Logger.getLogger(this.getClass());
                                logger.warn((Object)e.getMessage(), (Throwable)e);
                                break;
                            }
                            throw e;
                        }
                    }
                }
                final String facilityId = storageLocal.getFacilityId();
                home.remove(storageLocal.getPrimaryKey());
                if (storageLocal != null) {
                    final boolean autoRegist = ActionMode.isAutoDetection();
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (autoRegist) {
                                    ActionMode.enterAutoDetection();
                                }
                                StorageOperator.this.removeDiskInfo(facilityId, storageId);
                            }
                            catch (Exception e) {
                                Logger logger = Logger.getLogger(CloudCommandFacade.class);
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (autoRegist) {
                                    ActionMode.leaveAutoDetection();
                                }
                            }
                        }
                    });
                    t.start();
                }
            } else {
                AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                awsRequest = new DeleteVolumeRequest().withVolumeId(storageId);
                ec2.deleteVolume(awsRequest);
            }
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public UpdateResult update(String regionName, String storageId) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter update()");
        AmazonEC2 ec2 = this.getAmazonEC2(regionName);
        try {
            CloudStorageLocal cloudStorageLocal = null;
            Volume volume = null;
            try {
                cloudStorageLocal = this.getCloudStorageLocalHome().findByPrimaryKey(new CloudStoragePK(storageId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                // empty catch block
            }
            if (cloudStorageLocal == null || cloudStorageLocal.getRegistStatus() != StorageRegistStateType.deleted.number()) {
                block9: {
                    try {
                        DescribeVolumesRequest request = new DescribeVolumesRequest().withVolumeIds(new String[]{storageId});
                        DescribeVolumesResult result = ec2.describeVolumes(request);
                        volume = (Volume)result.getVolumes().get(0);
                    }
                    catch (AmazonServiceException e1) {
                        if (AWSErrorCode.InvalidVolume_NotFound.match(e1.getErrorCode())) break block9;
                        throw new CloudManagerFault(e1);
                    }
                }
                if ("deleting".equals(volume.getState())) {
                    volume = null;
                }
            }
            UpdateResult result = this.internalUpdate(regionName, cloudStorageLocal, volume);
            this.getLogger().debug((Object)"exit update()");
            return result;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private UpdateResult internalUpdate(String regionName, CloudStorageLocal cloudStorageLocal, Volume volume) throws CloudManagerFault {
        try {
            if (volume != null) {
                if (cloudStorageLocal == null) {
                    if (this.update) {
                        cloudStorageLocal = this.createCloudStorageLocal(volume, regionName, null);
                        if (this.mount) {
                            this.addStorageRelation(regionName, cloudStorageLocal, volume);
                        }
                    }
                } else {
                    if (this.update) {
                        this.updateCloudStorageLocal(cloudStorageLocal, volume);
                    }
                    if (this.mount) {
                        this.updateStorageRelation(regionName, cloudStorageLocal, volume);
                    }
                }
            } else if (cloudStorageLocal != null) {
                if (this.update && cloudStorageLocal.getRegistStatus() != StorageRegistStateType.deleted.number()) {
                    cloudStorageLocal.setRegistStatus(StorageRegistStateType.deleted.number());
                }
                if (this.mount) {
                    this.removeStorageRelation(cloudStorageLocal);
                }
                if (cloudStorageLocal.getFacilityId() == null) {
                    this.deleteStorage(cloudStorageLocal);
                    cloudStorageLocal = null;
                }
            }
            return new UpdateResult(volume, cloudStorageLocal);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void updateCloudStorageLocal(CloudStorageLocal storageLocal, Volume volume) throws CloudManagerFault {
        String storageName = null;
        for (Tag t : volume.getTags()) {
            if (!t.getKey().equals("Name")) continue;
            storageName = t.getValue();
            break;
        }
        if (storageName != null) {
            if (!storageName.equals(storageLocal.getStorageName())) {
                storageLocal.setStorageName(storageName);
            }
        } else if (storageLocal.getStorageName() != null) {
            storageLocal.setStorageName(null);
        }
    }

    private void updateStorageRelation(String regionName, CloudStorageLocal cloudStorageLocal, Volume volume) throws CloudManagerFault {
        if (volume.getAttachments().isEmpty() || "detaching".equals(((VolumeAttachment)volume.getAttachments().get(0)).getState()) || "detached".equals(((VolumeAttachment)volume.getAttachments().get(0)).getState())) {
            this.removeStorageRelation(cloudStorageLocal);
        } else {
            this.addStorageRelation(regionName, cloudStorageLocal, volume);
        }
    }

    private CloudStorageLocal createCloudStorageLocal(Volume volume, String regionName, String storageName) throws CloudManagerFault {
        try {
            CloudStorageData detail = new CloudStorageData();
            detail.setStorageId(volume.getVolumeId());
            detail.setStorageType("EBS");
            detail.setCloudId(this.getCloudType().getId());
            detail.setRegion(regionName);
            detail.setAvailabilityZone(volume.getAvailabilityZone());
            detail.setCloudUserId(this.getCloudUser().getCloudUserId());
            detail.setRegistStatus(StorageRegistStateType.exist.number());
            detail.setCloudAccountId(this.getAccountId());
            if (storageName == null) {
                for (Tag t : volume.getTags()) {
                    if (!t.getKey().equals("Name")) continue;
                    detail.setStorageName(t.getValue());
                    break;
                }
            } else {
                detail.setStorageName(storageName);
            }
            return this.getCloudStorageLocalHome().create(detail);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void deleteStorage(CloudStorageLocal cloudStorage) throws CloudManagerFault {
        try {
            this.getCloudStorageLocalHome().remove(cloudStorage.getPrimaryKey());
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public UpdateAllResult updateAll(String regionName) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter updateAll()");
        try {
            UpdateResult updateResult;
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            DescribeVolumesResult result = ec2.describeVolumes();
            CloudStorageLocalHome home = CloudStorageUtil.getLocalHome();
            Filter filter = new Filter("region", regionName);
            Filter filter2 = new Filter("cloudAccountId", this.getAccountId());
            ArrayList csList = new ArrayList(home.findByFilter(new Filter[]{filter, filter2}));
            ArrayList vList = new ArrayList(result.getVolumes());
            Iterator vIter = vList.iterator();
            ArrayList<StorageMapping> storageMappings = new ArrayList<StorageMapping>();
            block3: while (vIter.hasNext()) {
                Volume v = (Volume)vIter.next();
                Iterator csIter = csList.iterator();
                if ("deleting".equals(v.getState())) {
                    vIter.remove();
                    continue;
                }
                while (csIter.hasNext()) {
                    CloudStorageLocal cs = (CloudStorageLocal)csIter.next();
                    if (!v.getVolumeId().equals(cs.getStorageId())) continue;
                    storageMappings.add(new StorageMapping(v, cs));
                    vIter.remove();
                    csIter.remove();
                    continue block3;
                }
            }
            ArrayList<StorageMapping> both = new ArrayList<StorageMapping>();
            ArrayList<StorageMapping> onlyAws = new ArrayList<StorageMapping>();
            ArrayList<CloudStorageLocal> onlyCloud = new ArrayList<CloudStorageLocal>();
            for (StorageMapping storageMapping : storageMappings) {
                this.internalUpdate(regionName, storageMapping.cloudStorage, storageMapping.volume);
            }
            both.addAll(storageMappings);
            for (Volume v : vList) {
                updateResult = this.internalUpdate(regionName, null, v);
                if (updateResult.cloudStorage != null) {
                    onlyAws.add(new StorageMapping(updateResult.awsVolume, updateResult.cloudStorage));
                }
                this.getLogger().debug((Object)("AWS : volumeId=" + v.getVolumeId()));
            }
            for (CloudStorageLocal cs : csList) {
                updateResult = this.internalUpdate(regionName, cs, null);
                if (updateResult.cloudStorage == null) continue;
                onlyCloud.add(updateResult.cloudStorage);
            }
            this.getLogger().debug((Object)"exit updateAll()");
            return new UpdateAllResult(regionName, both, onlyAws, onlyCloud);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void addStorageRelation(String regionName, CloudStorageLocal cloudStorageLocal, Volume volume) throws CloudManagerFault {
        if (volume.getAttachments().isEmpty() || "detaching".equals(((VolumeAttachment)volume.getAttachments().get(0)).getState()) || "detached".equals(((VolumeAttachment)volume.getAttachments().get(0)).getState())) {
            return;
        }
        VolumeAttachment va = (VolumeAttachment)volume.getAttachments().get(0);
        CloudInstanceLocal cloudInstance = null;
        try {
            CloudInstanceLocalHome instanceHome = CloudInstanceUtil.getLocalHome();
            cloudInstance = instanceHome.findByPrimaryKey(new CloudInstancePK(va.getInstanceId(), this.getAccountId(), regionName));
        }
        catch (FinderException e) {
            return;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        try {
            String volumeName = null;
            for (Tag t : volume.getTags()) {
                if (!t.getKey().equals("Name")) continue;
                volumeName = t.getValue();
                break;
            }
            volumeName = volumeName != null ? volumeName : va.getDevice();
            this.addDiskInfo(cloudInstance, cloudStorageLocal, volume, va);
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void addDiskInfo(CloudInstanceLocal cloudInstance, CloudStorageLocal cloudStorageLocal, Volume volume, VolumeAttachment va) throws CloudManagerFault {
        try {
            if (cloudInstance.getFacilityId() != null) {
                NodeInfo nodeInfo = this.getRepositoryControllerLocal().getNode(cloudInstance.getFacilityId());
                NodeDiskInfo nodeDiskInfo = null;
                for (NodeDiskInfo diskInfo : nodeInfo.getNodeDiskInfo()) {
                    if (!("storageId=" + volume.getVolumeId()).equals(diskInfo.getDeviceDescription())) continue;
                    nodeDiskInfo = diskInfo;
                    break;
                }
                if (nodeDiskInfo == null) {
                    nodeDiskInfo = new NodeDiskInfo();
                    nodeDiskInfo.setDeviceType("disk");
                    nodeDiskInfo.setDeviceName(va.getDevice());
                    HashSet<Integer> indexs = new HashSet<Integer>();
                    for (NodeDiskInfo diskInfo : nodeInfo.getNodeDiskInfo()) {
                        indexs.add(diskInfo.getDeviceIndex());
                    }
                    for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                        if (indexs.contains(i)) continue;
                        nodeDiskInfo.setDeviceIndex(Integer.valueOf(i));
                        break;
                    }
                    nodeDiskInfo.setDeviceSize(volume.getSize());
                    nodeDiskInfo.setDeviceSizeUnit("Gib");
                    nodeDiskInfo.setDeviceDescription("storageId=" + volume.getVolumeId());
                    nodeDiskInfo.setDeviceDisplayName(cloudStorageLocal.getStorageName() == null ? va.getDevice() : cloudStorageLocal.getStorageName());
                    ArrayList<NodeDiskInfo> disklist = new ArrayList<NodeDiskInfo>(nodeInfo.getNodeDiskInfo());
                    disklist.add(nodeDiskInfo);
                    nodeInfo.setNodeDiskInfo(disklist);
                    if (ActionMode.isAutoDetection()) {
                        Logger logger = Logger.getLogger(this.getClass());
                        logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + nodeInfo.getFacilityId() + ", InstanceId=" + cloudInstance.getInstanceId() + ", AddDisk=" + va.getDevice() + ", VolumeId=" + volume.getVolumeId()));
                    }
                    this.getRepositoryControllerLocal().modifyNode(nodeInfo);
                }
                if (cloudStorageLocal.getFacilityId() == null) {
                    cloudStorageLocal.setDeviceIndex(nodeDiskInfo.getDeviceIndex());
                    cloudStorageLocal.setDeviceName(nodeDiskInfo.getDeviceName());
                    cloudStorageLocal.setDeviceType(nodeDiskInfo.getDeviceType());
                    cloudStorageLocal.setFacilityId(nodeInfo.getFacilityId());
                    cloudStorageLocal.setRegistStatus(StorageRegistStateType.exist.number());
                }
            }
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void removeStorageRelation(CloudStorageLocal cloudStorageLocal) throws CloudManagerFault {
        if (cloudStorageLocal.getFacilityId() == null) {
            return;
        }
        this.removeDiskInfo(cloudStorageLocal.getFacilityId(), cloudStorageLocal.getStorageId());
        cloudStorageLocal.setFacilityId(null);
        cloudStorageLocal.setDeviceIndex(null);
        cloudStorageLocal.setDeviceName(null);
        cloudStorageLocal.setDeviceType(null);
    }

    private void removeDiskInfo(String facilityId, String storageId) throws CloudManagerFault {
        block7: {
            try {
                NodeInfo nodeInfo = this.getRepositoryControllerLocal().getNode(facilityId);
                if (nodeInfo == null || nodeInfo.getNodeDiskInfo() == null) break block7;
                for (NodeDiskInfo disk : nodeInfo.getNodeDiskInfo()) {
                    if (!("storageId=" + storageId).equals(disk.getDeviceDescription())) continue;
                    ArrayList disklist = new ArrayList(nodeInfo.getNodeDiskInfo());
                    disklist.remove(disk);
                    if (ActionMode.isAutoDetection()) {
                        CloudInstanceLocal cloudInstance = null;
                        try {
                            CloudInstanceLocalHome instanceHome = CloudInstanceUtil.getLocalHome();
                            List cloudInstances = (List)instanceHome.findByFilter(new Filter[]{new Filter("facilityId", nodeInfo.getFacilityId())});
                            if (!cloudInstances.isEmpty()) {
                                cloudInstance = (CloudInstanceLocal)cloudInstances.get(0);
                            }
                        }
                        catch (Exception e) {
                            return;
                        }
                        Logger logger = Logger.getLogger(this.getClass());
                        logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + nodeInfo.getFacilityId() + ", InstanceId=" + (cloudInstance != null ? cloudInstance.getInstanceId() : null) + ", DelDisk=" + disk.getDeviceName() + ", VolumeId=" + storageId));
                    }
                    nodeInfo.setNodeDiskInfo(disklist);
                    break;
                }
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
    }

    public void attachStorage(String regionName, String instanceId, String storageId, String device) throws CloudManagerFault {
        boolean success = false;
        AttachVolumeResult result = null;
        try {
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            AttachVolumeRequest attachVolumeRequest = new AttachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId).withDevice(device);
            result = ec2.attachVolume(attachVolumeRequest);
            DescribeVolumesRequest describeVolumesRequest = new DescribeVolumesRequest().withVolumeIds(new String[]{storageId});
            Volume volume = (Volume)ec2.describeVolumes(describeVolumesRequest).getVolumes().get(0);
            CloudStorageLocal cloudStorageLocal = null;
            try {
                cloudStorageLocal = this.getCloudStorageLocalHome().findByPrimaryKey(new CloudStoragePK(storageId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                // empty catch block
            }
            this.internalUpdate(regionName, cloudStorageLocal, volume);
            success = true;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        finally {
            if (!success && result != null) {
                try {
                    AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                    DetachVolumeRequest detachVolumeRequest = new DetachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId);
                    ec2.detachVolume(detachVolumeRequest);
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void detachStorage(String regionName, String instanceId, String storageId) throws CloudManagerFault {
        boolean success = false;
        DetachVolumeResult result = null;
        try {
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            DetachVolumeRequest detachVolumeRequest = new DetachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId);
            result = this.getAmazonEC2(regionName).detachVolume(detachVolumeRequest);
            DescribeVolumesRequest describeVolumesRequest = new DescribeVolumesRequest().withVolumeIds(new String[]{storageId});
            Volume volume = (Volume)ec2.describeVolumes(describeVolumesRequest).getVolumes().get(0);
            CloudStorageLocal cloudStorageLocal = null;
            try {
                cloudStorageLocal = this.getCloudStorageLocalHome().findByPrimaryKey(new CloudStoragePK(storageId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                // empty catch block
            }
            this.internalUpdate(regionName, cloudStorageLocal, volume);
            success = true;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        finally {
            if (!success && result != null) {
                try {
                    AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                    AttachVolumeRequest attachVolumeRequest = new AttachVolumeRequest().withInstanceId(instanceId).withVolumeId(storageId).withDevice(result.getAttachment().getDevice());
                    ec2.attachVolume(attachVolumeRequest);
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String getAccountId() {
        return AWSUtil.getAccountIdFromIAM(this.user.getCloudResourceId());
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(InstanceOperator.class);
        }
        return this.logger;
    }

    private CloudUser getCloudUser() {
        return this.user;
    }

    private CloudTypeLocal getCloudType() throws CloudManagerFault {
        if (this.cloudType == null) {
            try {
                this.cloudType = (CloudTypeLocal)CloudTypeUtil.getLocalHome().findAll().iterator().next();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.cloudType;
    }

    private AmazonEC2 getAmazonEC2(String regionName) throws CloudManagerFault {
        return AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(this.getCloudUser().getAccessKey(), this.getCloudUser().getSecretKey()), regionName);
    }

    private RepositoryControllerLocal getRepositoryControllerLocal() throws CloudManagerFault {
        if (this.repositoryLocal == null) {
            try {
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                this.repositoryLocal = repositoryHome.create();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.repositoryLocal;
    }

    private CloudStorageLocalHome getCloudStorageLocalHome() throws CloudManagerFault {
        if (this.cloudStorageLocalHome == null) {
            try {
                this.cloudStorageLocalHome = CloudStorageUtil.getLocalHome();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.cloudStorageLocalHome;
    }

    public static StorageOperator createStorageOperator(CloudUser user) throws CloudManagerFault {
        return new StorageOperator(user, true, CloudPropertyConstants.autoregist_storage.match("on"), true);
    }

    public static StorageOperator createStorageOperator(CloudUser user, boolean update, boolean regist, boolean mount) throws CloudManagerFault {
        return new StorageOperator(user, update, regist, mount);
    }

    private static class StorageMapping {
        public Volume volume;
        public CloudStorageLocal cloudStorage;

        StorageMapping(Volume volume, CloudStorageLocal cloudStorage) {
            this.volume = volume;
            this.cloudStorage = cloudStorage;
        }
    }

    public class UpdateResult {
        public final Volume awsVolume;
        public final CloudStorageLocal cloudStorage;

        public UpdateResult(Volume awsVolume, CloudStorageLocal cloudStorage) {
            this.awsVolume = awsVolume;
            this.cloudStorage = cloudStorage;
        }

        public CloudStorage getCloudStorage() {
            if (this.cloudStorage != null) {
                if (this.awsVolume != null) {
                    return new CloudStorage(this.cloudStorage.getDetail(), this.awsVolume, HinemosUtil.getFacilityName(this.cloudStorage.getFacilityId()));
                }
                return new CloudStorage(this.cloudStorage.getDetail(), HinemosUtil.getFacilityName(this.cloudStorage.getFacilityId()));
            }
            return null;
        }
    }

    public class UpdateAllResult {
        public final String regionName;
        public final List<StorageMapping> both;
        public final List<StorageMapping> onlyAws;
        public final List<CloudStorageLocal> onlyCloud;

        public UpdateAllResult(String regionName, List<StorageMapping> both, List<StorageMapping> onlyAws, List<CloudStorageLocal> onlyCloud) {
            this.regionName = regionName;
            this.both = Collections.unmodifiableList(both);
            this.onlyAws = Collections.unmodifiableList(onlyAws);
            this.onlyCloud = Collections.unmodifiableList(onlyCloud);
        }

        public List<CloudStorage> getCloudStorages() {
            ArrayList<CloudStorage> cloudStorages = new ArrayList<CloudStorage>();
            for (StorageMapping mapping : this.both) {
                cloudStorages.add(new CloudStorage(mapping.cloudStorage.getDetail(), mapping.volume, HinemosUtil.getFacilityName(mapping.cloudStorage.getFacilityId())));
                StorageOperator.this.getLogger().debug((Object)("Both : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId()));
            }
            for (StorageMapping mapping : this.onlyAws) {
                cloudStorages.add(new CloudStorage(mapping.cloudStorage.getDetail(), mapping.volume, HinemosUtil.getFacilityName(mapping.cloudStorage.getFacilityId())));
                StorageOperator.this.getLogger().debug((Object)("AWS : facilityId=" + mapping.cloudStorage.getFacilityId() + ", storageId=" + mapping.cloudStorage.getStorageId()));
            }
            for (CloudStorageLocal cs : this.onlyCloud) {
                cloudStorages.add(new CloudStorage(cs.getDetail(), HinemosUtil.getFacilityName(cs.getFacilityId())));
                StorageOperator.this.getLogger().debug((Object)("Cloud : facilityId=" + cs.getFacilityId() + ", storageId=" + cs.getStorageId()));
            }
            return cloudStorages;
        }
    }
}

