/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.InstanceStatus;
import com.clustercontrol.cloud.bean.AvailabilityZone;
import com.clustercontrol.cloud.bean.BillingAlarm;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.GroupIdentifier;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.IpPermission;
import com.clustercontrol.cloud.bean.KeyPair;
import com.clustercontrol.cloud.bean.Region;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.SecurityGroup;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Subnet;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmData;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmLocal;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmLocalHome;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmUtil;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudInstancePK;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceUtil;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateData;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateLocal;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudTemplatePK;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateUtil;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.CloudCommandFacade;
import com.clustercontrol.cloud.factory.DescribeGroupIdentifierRequest;
import com.clustercontrol.cloud.factory.DescribeRegionsRequest;
import com.clustercontrol.cloud.factory.DescribeSubnetsRequest;
import com.clustercontrol.cloud.factory.ICloudCommandFacade;
import com.clustercontrol.cloud.factory.InstanceOperator;
import com.clustercontrol.cloud.factory.StorageOperator;
import com.clustercontrol.cloud.factory.TemplateJobOperator;
import com.clustercontrol.cloud.util.aws.AWSUtil;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import com.clustercontrol.cloud.util.aws.AmazonResourceNameUtil;
import com.clustercontrol.cloud.util.aws.TemplateUtil;
import com.clustercontrol.cloud.validation.ValidationMessages;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ejb.FinderException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

public class NewCloudCommandFacade
implements ICloudCommandFacade {
    private SessionContext context;
    private CloudCommandFacade oldFacade = new CloudCommandFacade();
    private CloudType cloudType;
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private NewCloudCommandFacade() {
    }

    private static WrappedRuntimeException wrappedRuntimeException(Exception e) {
        if (e instanceof WrappedRuntimeException) {
            return (WrappedRuntimeException)e;
        }
        return new WrappedRuntimeException(e);
    }

    @Override
    public CloudUser getCurrentCloudUserInfo() throws CloudManagerFault {
        try {
            CloudUser[] users = this.findCloudUsers(new Filter[]{new Filter("userId", this.context.getCallerPrincipal().getName())});
            if (users.length == 0) {
                CloudManagerFault v = new CloudManagerFault(ValidationMessages.getString("validation.cloud_user.message4", new Object[]{this.context.getCallerPrincipal().getName()}));
                throw v;
            }
            return users[0];
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    private CloudType getAWSCloudType() throws CloudManagerFault {
        if (this.cloudType == null) {
            try {
                this.cloudType = this.oldFacade.findAllCloudType()[0];
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.cloudType;
    }

    @Override
    public void setSessionContext(SessionContext context) {
        this.context = context;
        this.oldFacade.setSessionContext(context);
    }

    @Override
    public BillingAlarm createBillingAlarm(BillingAlarm billingAlarm) throws CloudManagerFault {
        try {
            CloudUser user = this.getCurrentCloudUserInfo();
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
            nc.addNotifyRelation(billingAlarm.getNotifyRelationInfos());
            BillingAlarmLocalHome home = BillingAlarmUtil.getLocalHome();
            BillingAlarmData data = new BillingAlarmData(billingAlarm.getTableData());
            data.setCloudId(this.getAWSCloudType().getCloudId());
            data.setCloudUserId(user.getCloudUserId());
            data.setApplication("Billing Alerts");
            BillingAlarmLocal local = home.create(data);
            return new BillingAlarm(local.getDetail(), billingAlarm.getNotifyRelationInfos());
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public BillingAlarm findBillingAlarm(String alarmId) throws CloudManagerFault {
        try {
            return this.oldFacade.findBillingAlarm(alarmId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeBillingAlarm(String alarmId) throws CloudManagerFault {
        try {
            this.oldFacade.removeBillingAlarm(alarmId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public BillingAlarm[] findAllBillingAlarm() throws CloudManagerFault {
        try {
            return this.oldFacade.findAllBillingAlarm();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void modifyBillingAlarm(BillingAlarm billingAlarm) throws CloudManagerFault {
        try {
            this.oldFacade.modifyBillingAlarm(billingAlarm);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudUser createCloudUser(CloudUser cu) throws CloudManagerFault {
        try {
            return this.oldFacade.createCloudUser(cu);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudUser findCloudUser(String cloudUserId) throws CloudManagerFault {
        try {
            return this.oldFacade.findCloudUser(cloudUserId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudUser[] findCloudUsers(Filter[] filters) throws CloudManagerFault {
        try {
            return this.oldFacade.findCloudUsers(filters);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeCloudUser(String cloudUserId) throws CloudManagerFault {
        try {
            this.oldFacade.removeCloudUser(cloudUserId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudUser[] findAllCloudUser() throws CloudManagerFault {
        try {
            return this.oldFacade.findAllCloudUser();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void modifyCloudUser(CloudUser cu) throws CloudManagerFault {
        try {
            this.oldFacade.modifyCloudUser(cu);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudType[] findAllCloudType() throws CloudManagerFault {
        try {
            return this.oldFacade.findAllCloudType();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public SecurityGroup addSecurityGroup(String regionName, SecurityGroup sg) throws CloudManagerFault {
        try {
            return this.oldFacade.addSecurityGroup(regionName, sg);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeSecurityGroup(String regionName, String securityGroupId) throws CloudManagerFault {
        try {
            this.oldFacade.removeSecurityGroup(regionName, securityGroupId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public SecurityGroup[] getSecurityGroups(String regionName, Filter[] filters) throws CloudManagerFault {
        try {
            return this.oldFacade.getSecurityGroups(regionName, filters);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public SecurityGroup[] getSecurityGroupsByRegion(String regionName) throws CloudManagerFault {
        try {
            return this.oldFacade.getSecurityGroupsByRegion(regionName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public IpPermission authorizeIpPermission(String regionName, String securityGroupId, IpPermission permission) throws CloudManagerFault {
        try {
            return this.oldFacade.authorizeIpPermission(regionName, securityGroupId, permission);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void revokeIpPermission(String regionName, String securityGroupId, IpPermission permission) throws CloudManagerFault {
        try {
            this.oldFacade.revokeIpPermission(regionName, securityGroupId, permission);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstance createInstance(CreateInstanceRequest request) throws CloudManagerFault {
        try {
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).createInstance(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstance createInstanceByTemplate(CreateInstanceByTemplateRequest request) throws CloudManagerFault {
        try {
            CloudInstance instance = InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).createInstanceByTemplate(request);
            CloudTemplateLocalHome home = CloudTemplateUtil.getLocalHome();
            CloudTemplateLocal local = home.findByPrimaryKey(new CloudTemplatePK(request.getTemplateId(), AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
            String jobId = local.getLaunchJobId();
            if (jobId != null && !jobId.equals("")) {
                final String tmpFacilityId = instance.getFacilityId();
                TemplateJobOperator.Starter operationStarter = new TemplateJobOperator.Starter(){

                    @Override
                    public Boolean start() throws CloudManagerFault {
                        return TemplateJobOperator.registAgentObserve(tmpFacilityId);
                    }
                };
                TemplateJobOperator.runJobAfterOperation(instance.getFacilityId(), jobId, request.getArguments(), operationStarter);
            }
            return instance;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudInstance restoreInstance(RestoreInstanceRequest request) throws CloudManagerFault {
        return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).restoreInstance(request);
    }

    @Override
    public CloudInstance findInstance(String regionName, String instanceId) throws CloudManagerFault {
        try {
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).update(regionName, instanceId).getCloudInstance();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstance[] findInstancesByRegion(String regionName) throws CloudManagerFault {
        try {
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).updateAll(regionName).getCloudInstances().toArray(new CloudInstance[0]);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeInstance(String regionName, String instanceId) throws CloudManagerFault {
        try {
            InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).removeInstance(regionName, instanceId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public InstanceStateChange startInstance(StartInstanceRequest request) throws CloudManagerFault {
        try {
            if (request.getRunJobFlg().booleanValue()) {
                InstanceStateChange instanceStateChange = InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).startInstance(request.getRegion(), request.getInstanceId());
                CloudUser user = null;
                String facilityId = null;
                try {
                    user = this.getCurrentCloudUserInfo();
                    CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
                    CloudInstanceLocal local = home.findByPrimaryKey(new CloudInstancePK(request.getInstanceId(), AmazonResourceNameUtil.getAccountIdFromIAM(user.getCloudResourceId()), request.getRegion()));
                    facilityId = local.getFacilityId();
                }
                catch (Exception e) {
                    throw new HinemosUnknown((Throwable)e);
                }
                if (facilityId != null) {
                    final String tmpFacilityId = facilityId;
                    TemplateJobOperator.Starter oprationStarter = new TemplateJobOperator.Starter(){

                        @Override
                        public Boolean start() throws CloudManagerFault {
                            return TemplateJobOperator.findAgentObserve(tmpFacilityId);
                        }
                    };
                    TemplateJobOperator.runJobAfterOperation(facilityId, request.getJobId(), request.getArguments(), oprationStarter);
                }
                return instanceStateChange;
            }
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).startInstance(request.getRegion(), request.getInstanceId());
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public InstanceStateChange stopInstance(StopInstanceRequest request) throws CloudManagerFault {
        try {
            if (request.getRunJobFlg().booleanValue()) {
                CloudUser user = null;
                String facilityId = null;
                InstanceStateChange change = null;
                try {
                    user = this.getCurrentCloudUserInfo();
                    AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), request.getRegion());
                    DescribeInstanceStatusRequest describeInstanceStatusRequest = new DescribeInstanceStatusRequest().withInstanceIds(new String[]{request.getInstanceId()});
                    DescribeInstanceStatusResult result = ec2.describeInstanceStatus(describeInstanceStatusRequest);
                    if (result.getInstanceStatuses().size() == 1) {
                        InstanceStatus status = (InstanceStatus)result.getInstanceStatuses().get(0);
                        change = new InstanceStateChange();
                        change.setRegion(request.getRegion());
                        change.setInstanceId(request.getInstanceId());
                        change.setCurrentState(InstanceStateKind.byLabel(status.getInstanceState().getName()));
                        change.setPreviousState(InstanceStateKind.byLabel(status.getInstanceState().getName()));
                    }
                    if (change == null || !InstanceStateKind.running.equals((Object)change.getCurrentState())) {
                        throw new CloudManagerFault("Target instance is not running.");
                    }
                    CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
                    CloudInstanceLocal local = home.findByPrimaryKey(new CloudInstancePK(request.getInstanceId(), AmazonResourceNameUtil.getAccountIdFromIAM(user.getCloudResourceId()), request.getRegion()));
                    facilityId = local.getFacilityId();
                }
                catch (Exception e) {
                    throw new HinemosUnknown((Throwable)e);
                }
                if (facilityId != null) {
                    final String region = request.getRegion();
                    final String instanceId = request.getInstanceId();
                    final InstanceOperator operator = InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo());
                    TemplateJobOperator.Starter oprationStarter = new TemplateJobOperator.Starter(){

                        @Override
                        public Boolean start() throws CloudManagerFault {
                            operator.stopInstance(region, instanceId);
                            return true;
                        }
                    };
                    TemplateJobOperator.runJobBeforeOperation(facilityId, request.getJobId(), request.getArguments(), oprationStarter);
                }
                return change;
            }
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).stopInstance(request.getRegion(), request.getInstanceId());
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public Region[] getAllRegion() throws CloudManagerFault {
        try {
            DescribeRegionsRequest request = new DescribeRegionsRequest();
            return request.execute(this.getCurrentCloudUserInfo()).getRegions().toArray(new Region[0]);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public AvailabilityZone[] getAvailabilityZones(String regionName) throws CloudManagerFault {
        try {
            return this.oldFacade.getAvailabilityZones(regionName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public Image[] getImages(String regionName, Filter[] filters) throws CloudManagerFault {
        try {
            return this.oldFacade.getImages(regionName, filters);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public GroupIdentifier[] getGroupIdentifiers(String regionName, Filter[] filters) throws CloudManagerFault {
        try {
            CloudUser user = null;
            try {
                user = this.getCurrentCloudUserInfo();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
            DescribeGroupIdentifierRequest request = new DescribeGroupIdentifierRequest();
            request.setRegion(regionName);
            request.setFilters(Arrays.asList(filters));
            return request.execute(user).getSecurityGroups().toArray(new GroupIdentifier[0]);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public String[] getAllInstanceType() throws CloudManagerFault {
        try {
            return this.oldFacade.getAllInstanceType();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public KeyPair[] getKeyNames(String regionName) throws CloudManagerFault {
        try {
            return this.oldFacade.getKeyNames(regionName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorage createStorage(CreateStorageRequest request) throws CloudManagerFault {
        try {
            return StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).createStorage(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorage restoreStorage(CreateStorageRequest request) throws CloudManagerFault {
        try {
            return StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).createStorage(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorage findStorage(String regionName, String storageId) throws CloudManagerFault {
        try {
            return StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).update(regionName, storageId).getCloudStorage();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorage[] findStoragesByRegion(String regionName) throws CloudManagerFault {
        try {
            return StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).updateAll(regionName).getCloudStorages().toArray(new CloudStorage[0]);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeStorage(String regionName, String storageId) throws CloudManagerFault {
        try {
            StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).removeStorage(regionName, storageId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstanceBackup createInstanceBackup(CreateInstanceBackupRequest request) throws CloudManagerFault {
        try {
            return this.oldFacade.createInstanceBackup(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstanceBackup findInstanceBackup(String regionName, String imageId) throws CloudManagerFault {
        try {
            return this.oldFacade.findInstanceBackup(regionName, imageId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstanceBackup[] findInstanceBackupsByRegion(String regionName) throws CloudManagerFault {
        try {
            return this.oldFacade.findInstanceBackupsByRegion(regionName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeInstanceBackup(String regionName, String imageId) throws CloudManagerFault {
        try {
            this.oldFacade.removeInstanceBackup(regionName, imageId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstanceBackup[] findAllInstanceBackup() throws CloudManagerFault {
        try {
            return this.oldFacade.findAllInstanceBackup();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorageBackup createStorageBackup(CreateStorageBackupRequest request) throws CloudManagerFault {
        try {
            return this.oldFacade.createStorageBackup(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorageBackup findStorageBackup(String regionName, String snapshotId) throws CloudManagerFault {
        try {
            return this.oldFacade.findStorageBackup(regionName, snapshotId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorageBackup[] findStorageBackupsByRegion(String regionName) throws CloudManagerFault {
        try {
            return this.oldFacade.findStorageBackupsByRegion(regionName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void removeStorageBackup(String regionName, String snapshotId) throws CloudManagerFault {
        try {
            this.oldFacade.removeStorageBackup(regionName, snapshotId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudStorageBackup[] findAllStorageBackup() throws CloudManagerFault {
        try {
            return this.oldFacade.findAllStorageBackup();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public Subnet[] getSubnets(String regionName, Filter[] filters) throws CloudManagerFault {
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeSubnetsRequest request = new DescribeSubnetsRequest();
        request.setRegion(regionName);
        request.setFilters(Arrays.asList(filters));
        return request.execute(user).getSubnets().toArray(new Subnet[0]);
    }

    @Override
    public String getWindowsPassword(String regionName, String instanceId) throws CloudManagerFault {
        try {
            return this.oldFacade.getWindowsPassword(regionName, instanceId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public Snapshot[] getSnapshots(String regionName, Filter[] filters) throws CloudManagerFault {
        try {
            return this.oldFacade.getSnapshots(regionName, filters);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public String[] getAllVolumeType() throws CloudManagerFault {
        try {
            return this.oldFacade.getAllVolumeType();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public String[] getAllServiceName() throws CloudManagerFault {
        try {
            return this.oldFacade.getAllServiceName();
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void attachStorage(String regionName, String instanceId, String storageId, String deviceName) throws CloudManagerFault {
        try {
            StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).attachStorage(regionName, instanceId, storageId, deviceName);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void detachStorage(String regionName, String instanceId, String storageId) throws CloudManagerFault {
        try {
            StorageOperator.createStorageOperator(this.getCurrentCloudUserInfo()).detachStorage(regionName, instanceId, storageId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudInstance registNode(RegistNodeRequest request) throws CloudManagerFault {
        try {
            return InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).registNode(request);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public void unregistNode(String regionName, String instanceId) throws CloudManagerFault {
        try {
            InstanceOperator.createInstanceOperator(this.getCurrentCloudUserInfo()).unregistNode(regionName, instanceId);
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    public static ICloudCommandFacade createCloudCommandFacade() {
        final NewCloudCommandFacade facade = new NewCloudCommandFacade();
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Logger logger = Logger.getLogger(NewCloudCommandFacade.class);
                    if (facade.context != null) {
                        logger.info((Object)("calling " + method.getName() + ", user=" + facade.context.getCallerPrincipal().getName()));
                    } else {
                        logger.info((Object)("calling " + method.getName() + ", user=none"));
                    }
                    logger.debug((Object)("enter " + method.getName()));
                    long before = System.currentTimeMillis();
                    Object result = method.invoke((Object)facade, args);
                    long after = System.currentTimeMillis();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Called ").append(method.getName()).append(" : ").append("elapsedTime=").append(after - before).append("ms");
                    if (args != null) {
                        for (Object arg : args) {
                            sb.append(", arg=").append(arg.toString());
                        }
                    }
                    logger.debug((Object)sb.toString());
                    logger.debug((Object)("exit " + method.getName()));
                    return result;
                }
                catch (InvocationTargetException e) {
                    try {
                        facade.context.setRollbackOnly();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (e.getTargetException() instanceof CloudManagerFault) {
                        throw e.getTargetException();
                    }
                    if (e.getTargetException() instanceof WrappedRuntimeException) {
                        if (e.getTargetException().getCause() instanceof CloudManagerFault) {
                            throw e.getTargetException().getCause();
                        }
                        throw new CloudManagerFault(e.getTargetException().getCause());
                    }
                    throw new CloudManagerFault(e.getCause());
                }
                catch (Exception e) {
                    try {
                        facade.context.setRollbackOnly();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new CloudManagerFault(e);
                }
            }
        };
        return (ICloudCommandFacade)Proxy.newProxyInstance(ICloudCommandFacade.class.getClassLoader(), new Class[]{ICloudCommandFacade.class}, h);
    }

    @Override
    public void update() throws CloudManagerFault {
        CloudUser[] userList;
        Logger logger = Logger.getLogger(this.getClass());
        final boolean autoDetection = ActionMode.isAutoDetection();
        Filter f1 = new Filter("parentCloudUserId", new String[]{null});
        for (final CloudUser cloudUser : userList = this.findCloudUsers(new Filter[]{f1})) {
            AmazonEC2Provider.CloudCredential credential = new AmazonEC2Provider.CloudCredential(cloudUser.getAccessKey(), cloudUser.getSecretKey());
            try {
                for (final Region r : AmazonEC2Provider.getAmazonEC2Provider().getAllRegion(credential)) {
                    try {
                        threadPool.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (autoDetection) {
                                    ActionMode.enterAutoDetection();
                                }
                                Logger logger = Logger.getLogger(this.getClass());
                                try {
                                    logger.debug((Object)("enter AutoDetection : region=" + r.getRegionName()));
                                    InstanceOperator.createInstanceOperator(cloudUser, CloudPropertyConstants.aws_node_ip.value(), CloudPropertyConstants.autoupdate_instance.match("on"), CloudPropertyConstants.autoregist_instance.match("on"), CloudPropertyConstants.autoregist_scope_relation.match("on")).updateAll(r.getRegionName());
                                    StorageOperator.createStorageOperator(cloudUser, CloudPropertyConstants.autoupdate_storage.match("on"), CloudPropertyConstants.autoregist_storage.match("on"), CloudPropertyConstants.autoupdate_mount.match("on")).updateAll(r.getRegionName());
                                    if (CloudPropertyConstants.autoupdate_backup.match("on")) {
                                        NewCloudCommandFacade.this.oldFacade.findInstanceBackupsByRegion(cloudUser, r.getRegionName());
                                        NewCloudCommandFacade.this.oldFacade.findStorageBackupsByRegion(cloudUser, r.getRegionName());
                                    }
                                    logger.debug((Object)("exit AutoDetection : region=" + r.getRegionName()));
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    if (autoDetection) {
                                        ActionMode.leaveAutoDetection();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public CloudTemplate createTemplate(CloudTemplate template) throws CloudManagerFault {
        try {
            CloudUser user = this.getCurrentCloudUserInfo();
            CloudTemplateLocalHome home = CloudTemplateUtil.getLocalHome();
            CloudTemplateData data = new CloudTemplateData(template.getTableData());
            data.setCloudId("AWS");
            data.setCloudUserId(user.getCloudUserId());
            data.setJobUnitId("AWS");
            data.setCloudAccountId(AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()));
            CloudTemplateLocal local = home.create(data);
            return new CloudTemplate(local.getDetail());
        }
        catch (Exception e) {
            throw NewCloudCommandFacade.wrappedRuntimeException(e);
        }
    }

    @Override
    public CloudTemplate findTemplate(String templateId) throws CloudManagerFault {
        CloudTemplateLocal local;
        CloudTemplateLocalHome home;
        try {
            home = CloudTemplateUtil.getLocalHome();
        }
        catch (NamingException e) {
            throw new CloudManagerFault(e);
        }
        try {
            local = home.findByPrimaryKey(new CloudTemplatePK(templateId, AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
        }
        catch (FinderException e) {
            throw new CloudManagerFault(e);
        }
        return new CloudTemplate(local.getDetail());
    }

    @Override
    public void modifyTemplate(CloudTemplate template) throws CloudManagerFault {
        CloudTemplateLocalHome home;
        try {
            home = CloudTemplateUtil.getLocalHome();
        }
        catch (NamingException e) {
            throw new CloudManagerFault(e);
        }
        try {
            CloudTemplateLocal local = home.findByPrimaryKey(new CloudTemplatePK(template.getTemplateId(), AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
            local.setTemplateName(template.getTemplateName());
            local.setRegion(template.getRegion());
            local.setImageId(template.getImageId());
            local.setLaunchJobId(template.getLaunchJobId());
            local.setStartJobId(template.getStartJobId());
            local.setStopJobId(template.getStopJobId());
        }
        catch (FinderException e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public CloudTemplate[] findAllTemplates() throws CloudManagerFault {
        try {
            Filter[] filters = new Filter[]{new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()))};
            return TemplateUtil.getTemplate(filters).toArray(new CloudTemplate[0]);
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)"Any template lacked.");
            throw new CloudManagerFault(e);
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    @Override
    public void removeTemplate(String templateId) throws CloudManagerFault {
        CloudTemplateLocalHome home;
        CloudTemplateLocal local = null;
        try {
            home = CloudTemplateUtil.getLocalHome();
        }
        catch (NamingException e1) {
            throw new CloudManagerFault(e1);
        }
        try {
            local = home.findByPrimaryKey(new CloudTemplatePK(templateId, AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist storage(" + templateId + ")."));
            throw new CloudManagerFault(e);
        }
        if (local != null) {
            try {
                home.remove(local.getPrimaryKey());
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
    }

    @Override
    public String[] findTemplateScripts() throws CloudManagerFault {
        File directory = new File("/opt/hinemos/var/cloud/");
        File[] files = directory.listFiles();
        ArrayList<String> scripts = new ArrayList<String>();
        for (File tmpFile : files) {
            scripts.add(tmpFile.getName());
        }
        return scripts.toArray(new String[0]);
    }

    private static class WrappedRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedRuntimeException(Exception exception) {
            super(exception);
        }
    }
}

