/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.InstanceDetail;
import com.clustercontrol.cloud.bean.InstanceRegistStateType;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.NodeDetail;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupPK;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupUtil;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceData;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudInstancePK;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceUtil;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateLocal;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudTemplatePK;
import com.clustercontrol.cloud.ejb.entity.CloudTemplateUtil;
import com.clustercontrol.cloud.ejb.entity.CloudTypeLocal;
import com.clustercontrol.cloud.ejb.entity.CloudTypeUtil;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.factory.InstanceMonitorService;
import com.clustercontrol.cloud.factory.StorageOperator;
import com.clustercontrol.cloud.factory.TemplateJobOperator;
import com.clustercontrol.cloud.util.Messages;
import com.clustercontrol.cloud.util.aws.AWSErrorCode;
import com.clustercontrol.cloud.util.aws.AWSUtil;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import com.clustercontrol.cloud.util.aws.HinemosUtil;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.fault.FacilityDuplicate;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocalHome;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import org.jboss.logging.Logger;

public class InstanceOperator {
    private Logger logger;
    private CloudUser user;
    private static CloudTypeLocal cloudType;
    private RepositoryControllerLocal repositoryLocal;
    private CloudInstanceLocalHome cloudInstanceLocalHome;
    private boolean update;
    private boolean regist;
    private boolean relation;
    private String ipType;
    private static Map<String, CriticalPoint> criticalPointMap;

    private static synchronized CriticalPoint getCriticalPoint(String regionName) {
        CriticalPoint cp = criticalPointMap.get(regionName);
        if (cp == null) {
            cp = new CriticalPoint();
            criticalPointMap.put(regionName, cp);
        }
        return cp;
    }

    private InstanceOperator(CloudUser user, String ipType, boolean upate, boolean regist, boolean relation) throws CloudManagerFault {
        assert (user != null);
        this.user = user;
        this.ipType = ipType;
        this.update = upate;
        this.regist = regist;
        this.relation = relation;
    }

    public CloudInstance createInstance(CreateInstanceRequest request) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter createInstance");
        InternalCreateInstanceRequest internalRequest = new InternalCreateInstanceRequest(request.getNodeDetail(), request.getInstanceDetail(), request.getRegion(), request.getAvailabilityZone(), request.getSubnetId(), request.getImageId(), null);
        CloudInstance instance = this.internalCreateInstance(internalRequest);
        if (instance.getFacilityId() != null) {
            TemplateJobOperator.registAgent(instance.getFacilityId());
        }
        return instance;
    }

    public CloudInstance createInstanceByTemplate(CreateInstanceByTemplateRequest request) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter createInstanceByTemplate");
        try {
            CloudTemplateLocalHome home = CloudTemplateUtil.getLocalHome();
            CloudTemplateLocal local = home.findByPrimaryKey(new CloudTemplatePK(request.getTemplateId(), this.getAccountId()));
            InternalCreateInstanceRequest internalRequest = new InternalCreateInstanceRequest();
            internalRequest.setNodeDetail(request.getNodeDetail());
            internalRequest.setInstanceDetail(request.getInstanceDetail());
            internalRequest.setRegion(local.getRegion());
            internalRequest.setAvailabilityZone(request.getAvailabilityZone());
            internalRequest.setSubnetId(request.getSubnetId());
            internalRequest.setImageId(local.getImageId());
            internalRequest.setTemplateId(request.getTemplateId());
            return this.internalCreateInstance(internalRequest);
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CloudInstance internalCreateInstance(InternalCreateInstanceRequest request) throws CloudManagerFault {
        CloudInstance cloudInstance;
        this.getLogger().debug((Object)"enter internalCreateInstance");
        AmazonEC2 ec2 = this.getAmazonEC2(request.getRegion());
        Instance instance = null;
        boolean success = false;
        try {
            RunInstancesRequest awsRequest = new RunInstancesRequest().withInstanceType(request.getInstanceDetail().getInstanceType() == null ? InstanceType.T1Micro.toString() : request.getInstanceDetail().getInstanceType()).withEbsOptimized(request.getInstanceDetail().getEbsOptimized()).withSecurityGroupIds(request.getInstanceDetail().getSecurityGroupIds()).withInstanceInitiatedShutdownBehavior(request.getInstanceDetail().getInstanceInitiatedShutdownBehavior()).withImageId(request.getImageId()).withMonitoring(request.getInstanceDetail().getMonitoring()).withKeyName(request.getInstanceDetail().getKeyName()).withPlacement(new Placement().withAvailabilityZone(request.getAvailabilityZone())).withDisableApiTermination(request.getInstanceDetail().getDisableApiTermination()).withSubnetId(request.getSubnetId()).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1));
            if (request.getInstanceDetail().getRootBlockDevice() != null) {
                awsRequest.withBlockDeviceMappings(new BlockDeviceMapping[]{new BlockDeviceMapping().withEbs(new EbsBlockDevice().withDeleteOnTermination(request.getInstanceDetail().getRootBlockDevice().getDeleteOnTermination()).withIops(request.getInstanceDetail().getRootBlockDevice().getIops()).withVolumeSize(request.getInstanceDetail().getRootBlockDevice().getVolumeSize()).withVolumeType(request.getInstanceDetail().getRootBlockDevice().getVolumeType())).withDeviceName("/dev/sda1")});
            } else {
                awsRequest.withBlockDeviceMappings(new BlockDeviceMapping[]{new BlockDeviceMapping().withEbs(new EbsBlockDevice().withDeleteOnTermination(Boolean.valueOf(true))).withDeviceName("/dev/sda1")});
            }
            RunInstancesResult result = ec2.runInstances(awsRequest);
            Reservation reservation = result.getReservation();
            assert (reservation.getInstances().size() == 1);
            instance = (Instance)reservation.getInstances().get(0);
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag("Name", request.getNodeDetail().getFacilityName()));
            for (int i = 0; i < Math.min(request.getInstanceDetail().getTags().size(), 9); ++i) {
                tags.add(new Tag(request.getInstanceDetail().getTags().get(i).getName(), request.getInstanceDetail().getTags().get(i).getValue()));
            }
            AWSUtil.addTags(ec2, instance.getInstanceId(), tags);
            CloudInstanceLocal local = this.createCloudInstanceLocal(instance, request.getRegion(), request.getNodeDetail().getFacilityName(), request.getTemplateId());
            CloudInstance cloudInstance2 = this.createCloudInstance(request.getNodeDetail(), local, instance);
            InstanceMonitorService.getSingleton().startMonitor(instance.getInstanceId(), cloudInstance2.getFacilityId(), request.getRegion(), this.getCloudUser(), true, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
            success = true;
            this.getLogger().debug((Object)"exit internalCreateInstance");
            cloudInstance = cloudInstance2;
            if (success) return cloudInstance;
            if (instance == null) return cloudInstance;
        }
        catch (CloudManagerFault e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CloudManagerFault(e2);
                }
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                if (instance == null) throw throwable;
                try {
                    Thread.sleep(1000L);
                    TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instance.getInstanceId()});
                    ec2.terminateInstances(terminateInstancesRequest);
                    throw throwable;
                }
                catch (InterruptedException e3) {
                    throw throwable;
                }
                catch (Exception e4) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.warn((Object)e4.getMessage(), (Throwable)e4);
                }
                throw throwable;
            }
        }
        try {
            Thread.sleep(1000L);
            TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instance.getInstanceId()});
            ec2.terminateInstances(terminateInstancesRequest);
            return cloudInstance;
        }
        catch (InterruptedException e) {
            return cloudInstance;
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return cloudInstance;
    }

    private CloudInstance createCloudInstance(NodeDetail nodeDetail, CloudInstanceLocal local, Instance instance) throws CloudManagerFault {
        NodeInfo nodeInfo = null;
        boolean success = false;
        try {
            if (Boolean.TRUE.equals(nodeDetail.getReplaceNode())) {
                try {
                    CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
                    Filter filter = new Filter("facilityId", nodeDetail.getFacilityId());
                    ArrayList cloudInstanceLocals = new ArrayList(home.findByFilter(new Filter[]{filter}));
                    for (CloudInstanceLocal cloudInstanceLocal : cloudInstanceLocals) {
                        this.unrelateNode(cloudInstanceLocal);
                    }
                    nodeInfo = this.getRepositoryControllerLocal().getNode(nodeDetail.getFacilityId());
                    HinemosUtil.resetNodeInfo(nodeInfo, nodeDetail.getFacilityName(), nodeDetail.getNodeName(), nodeDetail.getDescription(), this.getCloudType().getId(), local.getRegion(), instance.getInstanceId(), instance.getPlacement().getAvailabilityZone(), instance.getPlatform());
                    String ipAddress = "public".equals(this.ipType) ? instance.getPublicIpAddress() : instance.getPrivateIpAddress();
                    if (ipAddress != null) {
                        nodeInfo.setIpAddressV4(ipAddress);
                    } else {
                        nodeInfo.setIpAddressV4("123.123.123.123");
                    }
                    this.getRepositoryControllerLocal().modifyNode(nodeInfo);
                }
                catch (FacilityNotFound e) {
                    // empty catch block
                }
            }
            if (nodeInfo == null) {
                NodeInfo tempNodeInfo = HinemosUtil.createNodeInfo(nodeDetail.getFacilityId(), nodeDetail.getFacilityName(), nodeDetail.getNodeName(), nodeDetail.getDescription(), this.getCloudType().getId(), local.getRegion(), instance.getInstanceId(), instance.getPlacement().getAvailabilityZone(), instance.getPlatform());
                String ipAddress = "public".equals(this.ipType) ? instance.getPublicIpAddress() : instance.getPrivateIpAddress();
                if (ipAddress != null) {
                    tempNodeInfo.setIpAddressV4(ipAddress);
                } else {
                    tempNodeInfo.setIpAddressV4("123.123.123.123");
                }
                this.getRepositoryControllerLocal().addNode(tempNodeInfo);
                nodeInfo = tempNodeInfo;
            }
            local.setFacilityId(nodeDetail.getFacilityId());
            local.setRegistStatus(InstanceRegistStateType.registered.number());
            HinemosUtil.attachScope(this.getRepositoryControllerLocal(), local.getRegion(), instance.getPlacement().getAvailabilityZone(), nodeDetail.getFacilityId());
            StorageOperator operator = StorageOperator.createStorageOperator(this.getCloudUser(), true, true, true);
            for (InstanceBlockDeviceMapping ibd : instance.getBlockDeviceMappings()) {
                operator.update(local.getRegion(), ibd.getEbs().getVolumeId());
            }
            if (this.relation) {
                this.relateExistedScope(local.getFacilityId(), instance);
            }
            success = true;
            CloudInstance cloudInstance = new CloudInstance(local.getDetail(), instance, nodeInfo.getFacilityName());
            return cloudInstance;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        finally {
            if (!success && nodeInfo != null && !Boolean.TRUE.equals(nodeDetail.getReplaceNode())) {
                try {
                    this.getRepositoryControllerLocal().deleteNode(nodeInfo.getFacilityId());
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public CloudInstance restoreInstance(RestoreInstanceRequest request) throws CloudManagerFault {
        CloudInstanceBackupLocal backup = null;
        try {
            backup = CloudInstanceBackupUtil.getLocalHome().findByPrimaryKey(new CloudInstanceBackupPK(request.getImageId(), AWSUtil.getAccountIdFromIAM(this.getCloudUser().getCloudResourceId()), request.getRegion()));
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        InternalCreateInstanceRequest createRequest = new InternalCreateInstanceRequest();
        createRequest.getNodeDetail().setFacilityId(backup.getFacilityId());
        createRequest.getNodeDetail().setFacilityName(backup.getFacilityName());
        createRequest.getNodeDetail().setDescription(backup.getDescription());
        createRequest.getNodeDetail().setNodeName(backup.getNodeName());
        createRequest.getNodeDetail().setReplaceNode(Boolean.TRUE);
        if (request.getNodeDetail() != null) {
            if (request.getNodeDetail().getFacilityId() != null) {
                createRequest.getNodeDetail().setFacilityId(request.getNodeDetail().getFacilityId());
            }
            if (request.getNodeDetail().getFacilityName() != null) {
                createRequest.getNodeDetail().setFacilityName(request.getNodeDetail().getFacilityName());
            }
            if (request.getNodeDetail().getDescription() != null) {
                createRequest.getNodeDetail().setDescription(request.getNodeDetail().getDescription());
            }
            if (request.getNodeDetail().getNodeName() != null) {
                createRequest.getNodeDetail().setNodeName(request.getNodeDetail().getNodeName());
            }
            if (request.getNodeDetail().getReplaceNode() != null) {
                createRequest.getNodeDetail().setReplaceNode(request.getNodeDetail().getReplaceNode());
            }
        }
        createRequest.getInstanceDetail().setKeyName(backup.getKeyName());
        if (request.getInstanceDetail() != null) {
            if (request.getInstanceDetail().getSecurityGroupIds() != null) {
                createRequest.getInstanceDetail().setSecurityGroupIds(request.getInstanceDetail().getSecurityGroupIds());
            }
            if (request.getInstanceDetail().getInstanceType() != null) {
                createRequest.getInstanceDetail().setInstanceType(request.getInstanceDetail().getInstanceType());
            }
            if (request.getInstanceDetail().getTags() != null) {
                createRequest.getInstanceDetail().setTags(request.getInstanceDetail().getTags());
            }
            if (request.getInstanceDetail().getMonitoring() != null) {
                createRequest.getInstanceDetail().setMonitoring(request.getInstanceDetail().getMonitoring());
            }
            if (request.getInstanceDetail().getDisableApiTermination() != null) {
                createRequest.getInstanceDetail().setDisableApiTermination(request.getInstanceDetail().getDisableApiTermination());
            }
            if (request.getInstanceDetail().getDisableApiTermination() != null) {
                createRequest.getInstanceDetail().setDisableApiTermination(request.getInstanceDetail().getDisableApiTermination());
            }
            if (request.getInstanceDetail().getInstanceInitiatedShutdownBehavior() != null) {
                createRequest.getInstanceDetail().setInstanceInitiatedShutdownBehavior(request.getInstanceDetail().getInstanceInitiatedShutdownBehavior());
            }
            if (request.getInstanceDetail().getEbsOptimized() != null) {
                createRequest.getInstanceDetail().setEbsOptimized(request.getInstanceDetail().getEbsOptimized());
            }
            if (request.getInstanceDetail().getRootBlockDevice() != null) {
                createRequest.getInstanceDetail().setRootBlockDevice(request.getInstanceDetail().getRootBlockDevice());
            }
        }
        createRequest.setRegion(backup.getRegion());
        createRequest.setAvailabilityZone(backup.getAvailabilityZone());
        createRequest.setImageId(backup.getImageId());
        createRequest.setSubnetId(request.getSubnetId());
        CloudInstance instance = this.internalCreateInstance(createRequest);
        if (instance.getFacilityId() != null) {
            TemplateJobOperator.registAgent(instance.getFacilityId());
        }
        return instance;
    }

    public void removeInstance(String regionName, String instanceId) throws CloudManagerFault {
        this.getLogger().debug((Object)"removeInstance");
        try {
            CloudInstanceLocal cloudInstance = null;
            try {
                cloudInstance = this.getCloudInstanceLocalHome().findByPrimaryKey(new CloudInstancePK(instanceId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                this.getLogger().debug((Object)("Not exist instance(" + instanceId + ")."));
            }
            if (cloudInstance != null) {
                if (cloudInstance.getRegistStatus() == InstanceRegistStateType.deleted.number()) {
                    throw new CloudManagerFault("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u524a\u9664\u6e08\u307f\u306e\u305f\u3081\u3001\u30ce\u30fc\u30c9\u89e3\u9664\u3067\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                switch (InstanceRegistStateType.byNumber(cloudInstance.getRegistStatus())) {
                    case unregistered: 
                    case registered: {
                        try {
                            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                            TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
                            ec2.terminateInstances(terminateInstancesRequest);
                        }
                        catch (AmazonServiceException e) {
                            if (!"InvalidInstanceID.NotFound".equals(e.getErrorCode()) && !"OperationNotPermitted".equals(e.getErrorCode())) {
                                throw e;
                            }
                            this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
                        }
                        break;
                    }
                    case deleted: {
                        break;
                    }
                    default: {
                        this.getLogger().warn((Object)"DB is corrupted");
                    }
                }
                final String facilityId = cloudInstance.getFacilityId();
                this.getCloudInstanceLocalHome().remove(cloudInstance.getPrimaryKey());
                if (facilityId != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                InstanceOperator.this.getRepositoryControllerLocal().deleteNode(facilityId);
                            }
                            catch (UsedFacility e) {
                                InstanceOperator.this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (Exception e) {
                                InstanceOperator.this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                    t.start();
                }
            } else {
                AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
                ec2.terminateInstances(terminateInstancesRequest);
            }
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public com.clustercontrol.cloud.bean.InstanceStateChange startInstance(String regionName, String instanceId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            StartInstancesRequest request = new StartInstancesRequest().withInstanceIds(new String[]{instanceId});
            StartInstancesResult result = ec2.startInstances(request);
            InstanceStateChange awsChange = (InstanceStateChange)result.getStartingInstances().get(0);
            com.clustercontrol.cloud.bean.InstanceStateChange change = new com.clustercontrol.cloud.bean.InstanceStateChange();
            change.setRegion(regionName);
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.byLabel(awsChange.getCurrentState().getName()));
            change.setPreviousState(InstanceStateKind.byLabel(awsChange.getPreviousState().getName()));
            try {
                CloudInstanceLocal cloudInstance = this.getCloudInstanceLocalHome().findByPrimaryKey(new CloudInstancePK(instanceId, this.getAccountId(), regionName));
                if (cloudInstance.getFacilityId() != null) {
                    InstanceMonitorService.getSingleton().startMonitor(instanceId, cloudInstance.getFacilityId(), regionName, this.getCloudUser(), false, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
                }
            }
            catch (FinderException e) {
                this.getLogger().debug((Object)("Not exist instance(" + instanceId + ")."));
            }
            return change;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public com.clustercontrol.cloud.bean.InstanceStateChange stopInstance(String regionName, String instanceId) throws CloudManagerFault {
        try {
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            StopInstancesRequest request = new StopInstancesRequest().withInstanceIds(new String[]{instanceId});
            StopInstancesResult result = ec2.stopInstances(request);
            InstanceStateChange awsChange = (InstanceStateChange)result.getStoppingInstances().get(0);
            com.clustercontrol.cloud.bean.InstanceStateChange change = new com.clustercontrol.cloud.bean.InstanceStateChange();
            change.setRegion(regionName);
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.byLabel(awsChange.getCurrentState().getName()));
            change.setPreviousState(InstanceStateKind.byLabel(awsChange.getPreviousState().getName()));
            try {
                CloudInstanceLocal cloudInstance = this.getCloudInstanceLocalHome().findByPrimaryKey(new CloudInstancePK(instanceId, this.getAccountId(), regionName));
                if (cloudInstance.getFacilityId() != null) {
                    InstanceMonitorService.getSingleton().startMonitor(instanceId, cloudInstance.getFacilityId(), regionName, this.getCloudUser(), false, InstanceStateKind.running, InstanceStateKind.terminated, InstanceStateKind.stopped);
                }
            }
            catch (FinderException e) {
                this.getLogger().debug((Object)("Not exist instance(" + instanceId + ")."));
            }
            return change;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public UpdateResult update(String regionName, String instanceId) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter update()");
        AmazonEC2 ec2 = this.getAmazonEC2(regionName);
        try {
            CloudInstanceLocal cloudInstanceLocal = null;
            Instance instance = null;
            try {
                cloudInstanceLocal = this.getCloudInstanceLocalHome().findByPrimaryKey(new CloudInstancePK(instanceId, this.getAccountId(), regionName));
            }
            catch (FinderException e) {
                // empty catch block
            }
            if (cloudInstanceLocal == null || cloudInstanceLocal.getRegistStatus() != InstanceRegistStateType.deleted.number()) {
                block9: {
                    try {
                        DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId});
                        DescribeInstancesResult result = ec2.describeInstances(request);
                        instance = (Instance)((Reservation)result.getReservations().get(0)).getInstances().get(0);
                    }
                    catch (AmazonServiceException e1) {
                        if (AWSErrorCode.InvalidVolume_NotFound.match(e1.getErrorCode())) break block9;
                        throw new CloudManagerFault(e1);
                    }
                }
                if ("shutting-down".equals(instance.getState()) || "terminated".equals(instance.getState())) {
                    instance = null;
                }
            }
            UpdateResult result = this.internalUpdate(regionName, cloudInstanceLocal, instance, InstanceOperator.getCriticalPoint(regionName).isEntering());
            this.getLogger().debug((Object)"exit update()");
            return result;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    protected UpdateResult internalUpdate(String regionName, CloudInstanceLocal cloudInstanceLocal, Instance instance, boolean entering) throws CloudManagerFault {
        try {
            if (instance != null) {
                if (cloudInstanceLocal == null) {
                    if (this.update && !entering) {
                        try {
                            cloudInstanceLocal = this.createCloudInstanceLocal(instance, regionName, null, null);
                        }
                        catch (CloudManagerFault e) {
                            if (e.getCause() instanceof DuplicateKeyException) {
                                return new UpdateResult(instance, null);
                            }
                            throw e;
                        }
                        if (this.regist) {
                            this.addNodeRelation(regionName, cloudInstanceLocal, instance);
                            if (this.relation) {
                                this.relateExistedScope(cloudInstanceLocal.getFacilityId(), instance);
                            }
                            if (cloudInstanceLocal.getFacilityId() != null) {
                                TemplateJobOperator.registAgent(cloudInstanceLocal.getFacilityId());
                            }
                        }
                    }
                } else if (this.update) {
                    this.updateCloudInstanceLocal(cloudInstanceLocal, instance);
                    if (cloudInstanceLocal.getFacilityId() == null && this.regist) {
                        this.addNodeRelation(regionName, cloudInstanceLocal, instance);
                        if (this.relation) {
                            this.relateExistedScope(cloudInstanceLocal.getFacilityId(), instance);
                        }
                        if (cloudInstanceLocal.getFacilityId() != null) {
                            TemplateJobOperator.registAgent(cloudInstanceLocal.getFacilityId());
                        }
                    }
                }
            } else if (cloudInstanceLocal != null) {
                if (this.update) {
                    if (cloudInstanceLocal.getRegistStatus() != InstanceRegistStateType.deleted.number()) {
                        cloudInstanceLocal.setRegistStatus(InstanceRegistStateType.deleted.number());
                    }
                    if (this.regist) {
                        this.removeNodeRelation(cloudInstanceLocal);
                    }
                }
                if (cloudInstanceLocal.getFacilityId() == null) {
                    this.deleteInstance(cloudInstanceLocal);
                    cloudInstanceLocal = null;
                }
            }
            return new UpdateResult(instance, cloudInstanceLocal);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    protected void relateExistedScope(String facilityId, Instance instance) {
        String scopesString = null;
        for (Tag t : instance.getTags()) {
            if (!t.getKey().equals("hinemosAssignScopeId")) continue;
            scopesString = t.getValue();
            break;
        }
        if (scopesString != null) {
            String[] scopes = scopesString.split(",");
            try {
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                RepositoryControllerLocal repositoryController = repositoryHome.create();
                for (String scope : scopes) {
                    try {
                        if (ActionMode.isAutoDetection()) {
                            this.logger.info((Object)("Assign Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudId() + ", ParentFacilityID=" + scope + ", AssginFacilityID=" + facilityId));
                        }
                        repositoryController.assignNodeScope(scope, new String[]{facilityId});
                    }
                    catch (Exception e) {
                        Logger logger = Logger.getLogger(InstanceOperator.class);
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(InstanceOperator.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private CloudInstanceLocal createCloudInstanceLocal(Instance instance, String regionName, String instanceName, String templateId) throws CloudManagerFault {
        try {
            InstanceOperator.getCriticalPoint(regionName).enter();
            CloudInstanceData detail = new CloudInstanceData();
            detail.setInstanceId(instance.getInstanceId());
            detail.setRegion(regionName);
            detail.setAvailabilityZone(instance.getPlacement().getAvailabilityZone());
            detail.setCloudId(this.getCloudType().getId());
            detail.setCloudUserId(this.getCloudUser().getCloudUserId());
            detail.setRegistStatus(InstanceRegistStateType.unregistered.number());
            detail.setCloudAccountId(this.getAccountId());
            detail.setTemplateId(templateId);
            if (instanceName == null) {
                for (Tag t : instance.getTags()) {
                    if (!t.getKey().equals("Name")) continue;
                    detail.setInstanceName(t.getValue());
                    break;
                }
            } else {
                detail.setInstanceName(instanceName);
            }
            CloudInstanceLocal cloudInstanceLocal = this.getCloudInstanceLocalHome().create(detail);
            return cloudInstanceLocal;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        finally {
            InstanceOperator.getCriticalPoint(regionName).leave();
        }
    }

    private void updateCloudInstanceLocal(CloudInstanceLocal instanceLocal, Instance instance) throws CloudManagerFault {
        try {
            String instanceName = null;
            for (Tag t : instance.getTags()) {
                if (!t.getKey().equals("Name")) continue;
                instanceName = t.getValue();
                break;
            }
            if (instanceName != null) {
                if (!instanceName.equals(instanceLocal.getInstanceName())) {
                    instanceLocal.setInstanceName(instanceName);
                }
            } else if (instanceLocal.getInstanceName() != null) {
                instanceLocal.setInstanceName(null);
            }
            if (instanceLocal.getFacilityId() != null) {
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                RepositoryControllerLocal repositoryLocal = repositoryHome.create();
                NodeInfo node = repositoryLocal.getNode(instanceLocal.getFacilityId());
                String ipAddress = null;
                ipAddress = "public".equals(this.ipType) ? instance.getPublicIpAddress() : instance.getPrivateIpAddress();
                if (node.getIpAddressV4() == null || ipAddress == null && !"123.123.123.123".equals(node.getIpAddressV4()) || ipAddress != null && !node.getIpAddressV4().equals(ipAddress)) {
                    if (ipAddress != null) {
                        node.setIpAddressV4(ipAddress);
                    } else {
                        node.setIpAddressV4("123.123.123.123");
                    }
                    repositoryLocal.modifyNode(node);
                }
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void deleteInstance(CloudInstanceLocal cloudInstance) throws CloudManagerFault {
        try {
            this.getCloudInstanceLocalHome().remove(cloudInstance.getPrimaryKey());
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public UpdateAllResult updateAll(String regionName) throws CloudManagerFault {
        this.getLogger().debug((Object)"enter updateAll()");
        try {
            UpdateResult updateResult;
            AmazonEC2 ec2 = this.getAmazonEC2(regionName);
            DescribeInstancesResult result = ec2.describeInstances();
            ArrayList awsInstances = new ArrayList();
            for (Reservation r : result.getReservations()) {
                awsInstances.addAll(r.getInstances());
            }
            CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
            Filter filter = new Filter("region", regionName);
            Filter filter2 = new Filter("cloudAccountId", this.getAccountId());
            ArrayList cloudInstanceLocals = new ArrayList(home.findByFilter(new Filter[]{filter, filter2}));
            Iterator iIter = awsInstances.iterator();
            ArrayList<InstanceMapping> instanceMappings = new ArrayList<InstanceMapping>();
            block4: while (iIter.hasNext()) {
                Instance i = (Instance)iIter.next();
                if ("shutting-down".equals(i.getState().getName()) || "terminated".equals(i.getState().getName())) {
                    iIter.remove();
                    continue;
                }
                Iterator ciIter = cloudInstanceLocals.iterator();
                while (ciIter.hasNext()) {
                    CloudInstanceLocal ci = (CloudInstanceLocal)ciIter.next();
                    if (!i.getInstanceId().equals(ci.getInstanceId())) continue;
                    instanceMappings.add(new InstanceMapping(i, ci));
                    iIter.remove();
                    ciIter.remove();
                    continue block4;
                }
            }
            ArrayList<InstanceMapping> both = new ArrayList<InstanceMapping>();
            ArrayList<InstanceMapping> onlyAws = new ArrayList<InstanceMapping>();
            ArrayList<CloudInstanceLocal> onlyCloud = new ArrayList<CloudInstanceLocal>();
            boolean entering = InstanceOperator.getCriticalPoint(regionName).isEntering();
            for (InstanceMapping storageMapping : instanceMappings) {
                this.internalUpdate(regionName, storageMapping.cloudInstance, storageMapping.awsInstance, entering);
            }
            both.addAll(instanceMappings);
            for (Instance i : awsInstances) {
                updateResult = this.internalUpdate(regionName, null, i, entering);
                if (updateResult.cloudInstance == null) continue;
                onlyAws.add(new InstanceMapping(updateResult.awsInstance, updateResult.cloudInstance));
                this.getLogger().debug((Object)("AWS : instanceId=" + i.getInstanceId()));
            }
            for (CloudInstanceLocal cs : cloudInstanceLocals) {
                updateResult = this.internalUpdate(regionName, cs, null, entering);
                if (updateResult.cloudInstance == null) continue;
                onlyCloud.add(updateResult.cloudInstance);
            }
            this.getLogger().debug((Object)"exit updateAll()");
            return new UpdateAllResult(regionName, both, onlyAws, onlyCloud);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    private void addNodeRelation(String regionName, CloudInstanceLocal cloudInstanceLocal, Instance instance) throws CloudManagerFault {
        boolean success = false;
        NodeInfo nodeInfo = null;
        try {
            String instanceName = null;
            for (Tag t : instance.getTags()) {
                if (!t.getKey().equals("Name")) continue;
                instanceName = t.getValue();
                break;
            }
            if (instanceName == null || instanceName.length() == 0) {
                instanceName = instance.getInstanceId();
            }
            String nodeName = null;
            nodeName = "public".equals(this.ipType) ? instance.getPublicDnsName() : instance.getPrivateDnsName();
            if (nodeName == null || nodeName.length() == 0) {
                nodeName = instanceName;
            }
            String cloudId = this.getCloudType().getId();
            NodeInfo tempNodeInfo = HinemosUtil.createNodeInfo(instance.getInstanceId(), instanceName, nodeName, "Hinemos Auto Regist", cloudId, regionName, instance.getInstanceId(), instance.getPlacement().getAvailabilityZone(), instance.getPlatform());
            String ipAddress = null;
            ipAddress = "public".equals(this.ipType) ? instance.getPublicIpAddress() : instance.getPrivateIpAddress();
            if (ipAddress != null) {
                tempNodeInfo.setIpAddressV4(ipAddress);
            } else {
                tempNodeInfo.setIpAddressV4("123.123.123.123");
            }
            RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
            RepositoryControllerLocal repositoryLocal = repositoryHome.create();
            if (ActionMode.isAutoDetection()) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.info((Object)("Add Node, Method=autoRegist, CloudUser=" + this.getCloudUser().getCloudUserId() + ", FacilityID=" + tempNodeInfo.getFacilityId() + ", InstanceId=" + instance.getInstanceId()));
            }
            try {
                repositoryLocal.addNode(tempNodeInfo);
            }
            catch (FacilityDuplicate e) {
                this.logger.warn((Object)e.getMessage());
                return;
            }
            nodeInfo = tempNodeInfo;
            HinemosUtil.attachScope(this.getRepositoryControllerLocal(), regionName, instance.getPlacement().getAvailabilityZone(), instance.getInstanceId());
            cloudInstanceLocal.setFacilityId(instance.getInstanceId());
            cloudInstanceLocal.setRegistStatus(InstanceRegistStateType.registered.number());
            StorageOperator operator = StorageOperator.createStorageOperator(this.getCloudUser(), true, true, true);
            for (InstanceBlockDeviceMapping ibd : instance.getBlockDeviceMappings()) {
                operator.update(regionName, ibd.getEbs().getVolumeId());
            }
            success = true;
        }
        catch (Exception e) {
            if (!success && nodeInfo != null) {
                try {
                    this.getRepositoryControllerLocal().deleteNode(nodeInfo.getFacilityId());
                }
                catch (Exception e1) {
                    Logger logger = Logger.getLogger(this.getClass());
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new CloudManagerFault(e);
        }
    }

    private void removeNodeRelation(CloudInstanceLocal cloudInstanceLocal) throws CloudManagerFault {
        if (cloudInstanceLocal.getFacilityId() == null) {
            return;
        }
        final String facilityId = cloudInstanceLocal.getFacilityId();
        final String instanceId = cloudInstanceLocal.getInstanceId();
        final boolean autoRegist = ActionMode.isAutoDetection();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (autoRegist) {
                        Logger.getLogger(this.getClass());
                        InstanceOperator.this.logger.info((Object)("Delete Node, Method=autoRegist, CloudUser=" + InstanceOperator.this.getCloudUser().getCloudUserId() + ", FacilityID=" + facilityId + ", InstanceId=" + instanceId));
                    }
                    InstanceOperator.this.getRepositoryControllerLocal().deleteNode(facilityId);
                }
                catch (UsedFacility e) {
                    InstanceOperator.this.getLogger().warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    InstanceOperator.this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
        t.start();
        this.unrelateNode(cloudInstanceLocal);
    }

    private void unrelateNode(CloudInstanceLocal cloudInstanceLocal) throws CloudManagerFault {
        cloudInstanceLocal.setFacilityId(null);
        cloudInstanceLocal.setRegistStatus(InstanceRegistStateType.unregistered.number());
    }

    public CloudInstance registNode(RegistNodeRequest request) throws CloudManagerFault, HinemosUnknown {
        try {
            AmazonEC2 ec2 = this.getAmazonEC2(request.getRegion());
            DescribeInstancesRequest awsRequest = new DescribeInstancesRequest().withInstanceIds(new String[]{request.getInstanceId()});
            Instance instance = (Instance)((Reservation)ec2.describeInstances(awsRequest).getReservations().get(0)).getInstances().get(0);
            CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
            CloudInstanceLocal local = home.findByPrimaryKey(new CloudInstancePK(request.getInstanceId(), this.getAccountId(), request.getRegion()));
            return this.createCloudInstance(request.getNodeDetail(), local, instance);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public void unregistNode(String regionName, String instanceId) throws ValidationFault, HinemosUnknown, CloudManagerFault {
        try {
            CloudInstanceLocalHome home = CloudInstanceUtil.getLocalHome();
            CloudInstanceLocal instanceLocal = null;
            instanceLocal = home.findByPrimaryKey(new CloudInstancePK(instanceId, this.getAccountId(), regionName));
            if (instanceLocal.getRegistStatus() != InstanceRegistStateType.deleted.number()) {
                try {
                    AmazonEC2 ec2 = this.getAmazonEC2(regionName);
                    DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(new String[]{instanceId});
                    ec2.describeInstances(request);
                    throw new CloudManagerFault(Messages.getString("cloud.instance.message1"));
                }
                catch (AmazonServiceException e) {
                    if (AWSErrorCode.InvalidInstanceID_NotFound.match(e.getErrorCode())) {
                        instanceLocal.setRegistStatus(InstanceRegistStateType.deleted.number());
                    }
                    throw new CloudManagerFault(e);
                }
            }
            String facilityId = instanceLocal.getFacilityId();
            home.remove(instanceLocal.getPrimaryKey());
            if (facilityId != null) {
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                RepositoryControllerLocal repositoryLocal = repositoryHome.create();
                NodeInfo nodeInfo = repositoryLocal.getNode(facilityId);
                HinemosUtil.clearNodeInfo(nodeInfo);
            }
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new HinemosUnknown((Throwable)e);
        }
    }

    private RepositoryControllerLocal getRepositoryControllerLocal() throws CloudManagerFault {
        if (this.repositoryLocal == null) {
            try {
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                this.repositoryLocal = repositoryHome.create();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.repositoryLocal;
    }

    private CloudInstanceLocalHome getCloudInstanceLocalHome() throws CloudManagerFault {
        if (this.cloudInstanceLocalHome == null) {
            try {
                this.cloudInstanceLocalHome = CloudInstanceUtil.getLocalHome();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.cloudInstanceLocalHome;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(InstanceOperator.class);
        }
        return this.logger;
    }

    private CloudUser getCloudUser() {
        return this.user;
    }

    private String getAccountId() {
        return AWSUtil.getAccountIdFromIAM(this.user.getCloudResourceId());
    }

    private CloudTypeLocal getCloudType() throws CloudManagerFault {
        if (cloudType == null) {
            try {
                cloudType = (CloudTypeLocal)CloudTypeUtil.getLocalHome().findAll().iterator().next();
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return cloudType;
    }

    private AmazonEC2 getAmazonEC2(String regionName) throws CloudManagerFault {
        return AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(this.getCloudUser().getAccessKey(), this.getCloudUser().getSecretKey()), regionName);
    }

    public static InstanceOperator createInstanceOperator(CloudUser user) throws CloudManagerFault {
        return new InstanceOperator(user, CloudPropertyConstants.aws_node_ip.value(), true, CloudPropertyConstants.autoregist_instance.match("on"), CloudPropertyConstants.autoregist_scope_relation.match("on"));
    }

    public static InstanceOperator createInstanceOperator(CloudUser user, String ipType, boolean update, boolean regist, boolean relation) throws CloudManagerFault {
        return new InstanceOperator(user, ipType, update, regist, relation);
    }

    static {
        criticalPointMap = new HashMap<String, CriticalPoint>();
    }

    private static class InstanceMapping {
        public Instance awsInstance;
        public CloudInstanceLocal cloudInstance;

        InstanceMapping(Instance awsInstance, CloudInstanceLocal cloudInstance) {
            this.awsInstance = awsInstance;
            this.cloudInstance = cloudInstance;
        }
    }

    private static class InternalCreateInstanceRequest {
        private NodeDetail nodeDetail;
        private InstanceDetail instanceDetail;
        private String region;
        private String availabilityZone;
        private String subnetId;
        private String imageId;
        private String templateId;

        public InternalCreateInstanceRequest(NodeDetail nodeDetail, InstanceDetail instanceDetail, String region, String availabilityZone, String subnetId, String imageId, String templateId) {
            this.nodeDetail = nodeDetail;
            this.instanceDetail = instanceDetail;
            this.region = region;
            this.availabilityZone = availabilityZone;
            this.subnetId = subnetId;
            this.imageId = imageId;
            this.templateId = templateId;
        }

        public InternalCreateInstanceRequest() {
            this.nodeDetail = new NodeDetail();
            this.instanceDetail = new InstanceDetail();
        }

        public NodeDetail getNodeDetail() {
            return this.nodeDetail;
        }

        public void setNodeDetail(NodeDetail nodeDetail) {
            this.nodeDetail = nodeDetail;
        }

        public InstanceDetail getInstanceDetail() {
            return this.instanceDetail;
        }

        public void setInstanceDetail(InstanceDetail instanceDetail) {
            this.instanceDetail = instanceDetail;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public String getImageId() {
            return this.imageId;
        }

        public void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }
    }

    public class UpdateResult {
        public final Instance awsInstance;
        public final CloudInstanceLocal cloudInstance;

        public UpdateResult(Instance awsInstance, CloudInstanceLocal cloudInstance) {
            this.awsInstance = awsInstance;
            this.cloudInstance = cloudInstance;
        }

        public CloudInstance getCloudInstance() {
            if (this.cloudInstance != null) {
                if (this.awsInstance != null) {
                    return new CloudInstance(this.cloudInstance.getDetail(), this.awsInstance, HinemosUtil.getFacilityName(this.cloudInstance.getFacilityId()));
                }
                return new CloudInstance(this.cloudInstance.getDetail(), HinemosUtil.getFacilityName(this.cloudInstance.getFacilityId()));
            }
            return null;
        }
    }

    public class UpdateAllResult {
        public final String regionName;
        public final List<InstanceMapping> both;
        public final List<InstanceMapping> onlyAws;
        public final List<CloudInstanceLocal> onlyCloud;

        public UpdateAllResult(String regionName, List<InstanceMapping> both, List<InstanceMapping> onlyAws, List<CloudInstanceLocal> onlyCloud) {
            this.regionName = regionName;
            this.both = Collections.unmodifiableList(both);
            this.onlyAws = Collections.unmodifiableList(onlyAws);
            this.onlyCloud = Collections.unmodifiableList(onlyCloud);
        }

        public List<CloudInstance> getCloudInstances() {
            ArrayList<CloudInstance> cloudInstaces = new ArrayList<CloudInstance>();
            for (InstanceMapping mapping : this.both) {
                cloudInstaces.add(new CloudInstance(mapping.cloudInstance.getDetail(), mapping.awsInstance, HinemosUtil.getFacilityName(mapping.cloudInstance.getFacilityId())));
                InstanceOperator.this.getLogger().debug((Object)("Both : facilityId=" + mapping.cloudInstance.getFacilityId() + ", instanceId=" + mapping.cloudInstance.getInstanceId()));
            }
            for (InstanceMapping mapping : this.onlyAws) {
                cloudInstaces.add(new CloudInstance(mapping.cloudInstance.getDetail(), mapping.awsInstance, HinemosUtil.getFacilityName(mapping.cloudInstance.getFacilityId())));
                InstanceOperator.this.getLogger().debug((Object)("AWS : instanceId=" + mapping.cloudInstance.getInstanceId()));
            }
            for (CloudInstanceLocal ci : this.onlyCloud) {
                cloudInstaces.add(new CloudInstance(ci.getDetail(), HinemosUtil.getFacilityName(ci.getFacilityId())));
                InstanceOperator.this.getLogger().debug((Object)("Cloud : facilityId=" + ci.getFacilityId() + ", instanceId=" + ci.getInstanceId()));
            }
            return cloudInstaces;
        }
    }

    private static class CriticalPoint {
        private AtomicInteger syncCount = new AtomicInteger();

        private CriticalPoint() {
        }

        public void enter() {
            this.syncCount.incrementAndGet();
        }

        public void leave() {
            this.syncCount.decrementAndGet();
        }

        public boolean isEntering() {
            return this.syncCount.get() != 0;
        }
    }
}

