/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.Reservation;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.StorageOperator;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocalHome;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class InstanceMonitorService {
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                Logger logger = Logger.getLogger(InstanceMonitorService.class);
                logger.debug((Object)t.getMessage(), t);
            }
        }
    };
    private Map<String, InstanceInfo> instanceInfoMap = new HashMap<String, InstanceInfo>();
    private final String ipType;
    private final int interval;
    private final int maxPingCount;
    private ScheduledFuture<?> sf;
    private static InstanceMonitorService singleton;

    private InstanceMonitorService(String ipType, int interval, int maxPingCount) {
        this.ipType = ipType;
        this.interval = interval;
        this.maxPingCount = maxPingCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor(String indtanecId, String facilityId, String regionName, CloudUser user, boolean updateStorage, InstanceStateKind ... stoppedStatus) {
        if (CloudPropertyConstants.autoupdate_node.match("off")) {
            return;
        }
        Map<String, InstanceInfo> map = this.instanceInfoMap;
        synchronized (map) {
            InstanceInfo info = new InstanceInfo();
            info.facilityId = facilityId;
            info.regionName = regionName;
            info.user = user;
            info.stoppedStatus = stoppedStatus;
            info.pingCount = 0;
            info.updateStorage = updateStorage;
            this.instanceInfoMap.put(indtanecId, info);
            if (this.sf == null) {
                this.sf = this.scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = InstanceMonitorService.this.instanceInfoMap;
                        synchronized (map) {
                            Logger logger = Logger.getLogger(InstanceMonitorService.class);
                            for (Map.Entry entry : InstanceMonitorService.this.instanceInfoMap.entrySet()) {
                                logger.debug((Object)("instanceid : " + (String)entry.getKey() + ", condition : " + ((InstanceInfo)entry.getValue()).stoppedStatus.toString()));
                                ++((InstanceInfo)entry.getValue()).pingCount;
                                try {
                                    AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(((InstanceInfo)entry.getValue()).user.getAccessKey(), ((InstanceInfo)entry.getValue()).user.getSecretKey()), ((InstanceInfo)entry.getValue()).regionName);
                                    DescribeInstancesRequest request = new DescribeInstancesRequest().withFilters(new Filter[]{new Filter().withName("instance-id").withValues(new String[]{(String)entry.getKey()})});
                                    DescribeInstancesResult result = ec2.describeInstances(request);
                                    Instance instance = (Instance)((Reservation)result.getReservations().get(0)).getInstances().get(0);
                                    RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                                    RepositoryControllerLocal repositoryLocal = repositoryHome.create();
                                    NodeInfo node = repositoryLocal.getNode(((InstanceInfo)entry.getValue()).facilityId);
                                    String ipAddress = null;
                                    ipAddress = "public".equals(InstanceMonitorService.this.ipType) ? instance.getPublicIpAddress() : instance.getPrivateIpAddress();
                                    if (node.getIpAddressV4() == null || !node.getIpAddressV4().equals(ipAddress)) {
                                        String oldIpAddress = node.getIpAddressV4();
                                        if (ipAddress != null) {
                                            node.setIpAddressV4(ipAddress);
                                        } else {
                                            node.setIpAddressV4("123.123.123.123");
                                        }
                                        logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + ((InstanceInfo)entry.getValue()).user.getCloudUserId() + ", FacilityID=" + node.getFacilityId() + ", InstanceId=" + instance.getInstanceId() + ", OldIpAddress=" + oldIpAddress + ", NewIpAddress=" + node.getIpAddressV4()));
                                        repositoryLocal.modifyNode(node);
                                    }
                                    if (((InstanceInfo)entry.getValue()).updateStorage) {
                                        StorageOperator operator = StorageOperator.createStorageOperator(((InstanceInfo)entry.getValue()).user);
                                        for (InstanceBlockDeviceMapping ibd : instance.getBlockDeviceMappings()) {
                                            operator.update(((InstanceInfo)entry.getValue()).regionName, ibd.getEbs().getVolumeId());
                                        }
                                    }
                                    for (InstanceStateKind state : ((InstanceInfo)entry.getValue()).stoppedStatus) {
                                        if (!state.label().equals(instance.getState().getName())) continue;
                                        InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                        break;
                                    }
                                    if (InstanceMonitorService.this.maxPingCount != ((InstanceInfo)entry.getValue()).pingCount) continue;
                                    InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                    InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                }
                            }
                            InstanceMonitorService.this.mustStop();
                        }
                    }
                }, this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor(String indtanecId) {
        Map<String, InstanceInfo> map = this.instanceInfoMap;
        synchronized (map) {
            this.instanceInfoMap.remove(indtanecId);
            this.mustStop();
        }
    }

    private void mustStop() {
        if (this.sf != null && this.instanceInfoMap.isEmpty()) {
            this.sf.cancel(true);
            this.sf = null;
        }
    }

    private ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public void shutdown() {
        this.executor.shutdown();
        this.instanceInfoMap.clear();
    }

    public static synchronized InstanceMonitorService getSingleton() {
        if (singleton == null) {
            singleton = new InstanceMonitorService(CloudPropertyConstants.aws_node_ip.value(), Integer.valueOf(CloudPropertyConstants.registcheck_interval.value()), Integer.valueOf(CloudPropertyConstants.registcheck_count.value()));
        }
        return singleton;
    }

    private static class InstanceInfo {
        public String facilityId;
        public String regionName;
        public CloudUser user;
        public InstanceStateKind[] stoppedStatus;
        public int pingCount;
        public boolean updateStorage;

        private InstanceInfo() {
        }
    }
}

