/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.Subnet;
import com.clustercontrol.cloud.factory.CloudRequest;
import com.clustercontrol.cloud.factory.DescribeSubnetsResult;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import java.util.ArrayList;
import java.util.List;

public class DescribeSubnetsRequest
extends CloudRequest {
    private String region;
    private List<Filter> filters = new ArrayList<Filter>();

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public DescribeSubnetsResult execute(CloudUser user) throws CloudManagerFault {
        com.amazonaws.services.ec2.model.DescribeSubnetsResult awsResult = null;
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), this.region);
        if (!this.filters.isEmpty()) {
            com.amazonaws.services.ec2.model.DescribeSubnetsRequest awsRequest = new com.amazonaws.services.ec2.model.DescribeSubnetsRequest();
            for (Filter f : this.getFilters()) {
                com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
                awsRequest.getFilters().add(awsFilter);
            }
            awsResult = ec2.describeSubnets(awsRequest);
        } else {
            awsResult = ec2.describeSubnets();
        }
        DescribeSubnetsResult subnetsResult = new DescribeSubnetsResult();
        for (com.amazonaws.services.ec2.model.Subnet awsSubnet : awsResult.getSubnets()) {
            Subnet subnet = new Subnet();
            subnet.setSubnetId(awsSubnet.getSubnetId());
            subnet.setVpcId(awsSubnet.getVpcId());
            subnet.setAvailabilityZone(awsSubnet.getAvailabilityZone());
            subnet.setCidrBlock(awsSubnet.getCidrBlock());
            subnetsResult.getSubnets().add(subnet);
        }
        return subnetsResult;
    }
}

