/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.GroupIdentifier;
import com.clustercontrol.cloud.factory.CloudRequest;
import com.clustercontrol.cloud.factory.DescribeGroupIdentifierResult;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import java.util.ArrayList;
import java.util.List;

public class DescribeGroupIdentifierRequest
extends CloudRequest {
    private String region;
    private List<Filter> filters = new ArrayList<Filter>();

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public DescribeGroupIdentifierResult execute(CloudUser user) throws CloudManagerFault {
        DescribeSecurityGroupsResult awsResult = null;
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), this.region);
        if (!this.filters.isEmpty()) {
            DescribeSecurityGroupsRequest awsRequest = new DescribeSecurityGroupsRequest();
            for (Filter f : this.getFilters()) {
                com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
                awsRequest.getFilters().add(awsFilter);
            }
            awsResult = ec2.describeSecurityGroups(awsRequest);
        } else {
            awsResult = ec2.describeSecurityGroups();
        }
        DescribeGroupIdentifierResult result = new DescribeGroupIdentifierResult();
        for (SecurityGroup awsSG : awsResult.getSecurityGroups()) {
            GroupIdentifier sg = new GroupIdentifier();
            sg.setGroupId(awsSG.getGroupId());
            sg.setGroupName(awsSG.getGroupName());
            result.getSecurityGroups().add(sg);
        }
        return result;
    }
}

