/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.ejb.session.CloudControllerUtil;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.cloud.util.Messages;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.logging.Logger;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

public class AutoDetectionServiceManager {
    private static final String quartzJndiName = "DBMSScheduler";
    private static final String quartzJobName = "AotoDetection";
    private static final String quartzJobGroupName = "CLOUD_MANAGEMENT";
    private static AutoDetectionService ad = new AutoDetectionServiceImpl();

    public static AutoDetectionService getService() {
        if (ad == null) {
            ad = new AutoDetectionServiceImpl();
        }
        return ad;
    }

    public static class AutoDetectionJob
    implements Job {
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            try {
                ActionMode.enterAutoDetection();
                Logger logger = Logger.getLogger(AutoDetectionServiceImpl.class);
                logger.debug((Object)"enter AsyncCallAutoDetection.");
                CloudControllerUtil.getLocalHome().create().update();
                logger.debug((Object)"leave AsyncCallAutoDetection.");
            }
            catch (Exception e) {
                throw new JobExecutionException(e);
            }
            finally {
                ActionMode.leaveAutoDetection();
            }
        }
    }

    private static class AutoDetectionServiceImpl
    implements AutoDetectionService {
        private AutoDetectionServiceImpl() {
        }

        @Override
        public void start() {
            Logger logger = Logger.getLogger(AutoDetectionServiceImpl.class);
            Scheduler scheduler = null;
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup(AutoDetectionServiceManager.quartzJndiName);
                scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
            JobDetail job = new JobDetail(AutoDetectionServiceManager.quartzJobName, AutoDetectionServiceManager.quartzJobGroupName, AutoDetectionJob.class);
            job.setDurability(true);
            CronTrigger cronTrigger = new CronTrigger(AutoDetectionServiceManager.quartzJobName, AutoDetectionServiceManager.quartzJobGroupName);
            cronTrigger.setMisfireInstruction(2);
            String cronString = CloudPropertyConstants.autoupdate_interval.value();
            try {
                cronTrigger.setCronExpression(cronString);
            }
            catch (ParseException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                try {
                    SendQueue messageQueue = new SendQueue("queue/clustercontrolNotifyEvent");
                    OutputBasicInfo output = new OutputBasicInfo();
                    output.setPluginId("CLOUD");
                    output.setMonitorId("AUTO_UPDATE");
                    output.setFacilityId("AWS");
                    output.setScopeText("AWS>");
                    output.setApplication("AutoUpdate");
                    output.setMessageId("001");
                    String message = Messages.getString("cloud.autoupdate.message.invalid_interval_string", new Object[]{cronString});
                    output.setMessage(message);
                    output.setMessageOrg(message + " : " + e.toString());
                    output.setPriority(2);
                    output.setGenerationDate(Long.valueOf(new Date().getTime()));
                    messageQueue.put((Serializable)output);
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    cronTrigger.setCronExpression(CloudPropertyConstants.autoupdate_interval.defaultValue());
                }
                catch (ParseException e1) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                scheduler.deleteJob(AutoDetectionServiceManager.quartzJobName, AutoDetectionServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                logger.warn((Object)("scheduleEjbInvokerJob() deleteJob : " + ((Object)((Object)e)).getClass().getSimpleName() + ", " + e.getMessage()));
            }
            try {
                scheduler.scheduleJob(job, (Trigger)cronTrigger);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
            try {
                scheduler.triggerJob(AutoDetectionServiceManager.quartzJobName, AutoDetectionServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void stop() {
            Logger logger = Logger.getLogger(AutoDetectionServiceImpl.class);
            Scheduler scheduler = null;
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup(AutoDetectionServiceManager.quartzJndiName);
                scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            }
            catch (NamingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                scheduler.deleteJob(AutoDetectionServiceManager.quartzJobName, AutoDetectionServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface AutoDetectionService {
        public void start();

        public void stop();
    }
}

