/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.util.Messages;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.logging.Logger;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

public class AlarmServiceManager {
    private static final String quartzJndiName = "DBMSScheduler";
    private static final String quartzJobName = "billingAlarm";
    private static final String quartzJobGroupName = "CLOUD_MANAGEMENT";
    private static final String pluginId = "MON_BLL";
    private static final String facilityID = "AWS";
    private static final String scopeText = "AWS>";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
    private static AlarmService as = new AlarmServiceImpl();

    public static AlarmService getService() {
        if (as == null) {
            as = new AlarmServiceImpl();
        }
        return as;
    }

    static /* synthetic */ SimpleDateFormat access$000() {
        return format;
    }

    public static class BillingAlarmJob
    implements Job {
        /*
         * Exception decompiling
         */
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class AlarmServiceImpl
    implements AlarmService {
        private AlarmServiceImpl() {
        }

        @Override
        public void start() {
            Logger logger = Logger.getLogger(AlarmServiceImpl.class);
            Scheduler scheduler = null;
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup(AlarmServiceManager.quartzJndiName);
                scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
            JobDetail job = new JobDetail(AlarmServiceManager.quartzJobName, AlarmServiceManager.quartzJobGroupName, BillingAlarmJob.class);
            job.setDurability(true);
            CronTrigger cronTrigger = new CronTrigger(AlarmServiceManager.quartzJobName, AlarmServiceManager.quartzJobGroupName);
            cronTrigger.setMisfireInstruction(2);
            String cronString = CloudPropertyConstants.billingalarm_notify_interval.value();
            try {
                cronTrigger.setCronExpression(cronString);
            }
            catch (ParseException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                try {
                    SendQueue messageQueue = new SendQueue("queue/clustercontrolNotifyEvent");
                    OutputBasicInfo output = new OutputBasicInfo();
                    output.setPluginId(AlarmServiceManager.pluginId);
                    output.setMonitorId("MON_BILLING");
                    output.setFacilityId(AlarmServiceManager.facilityID);
                    output.setScopeText(AlarmServiceManager.scopeText);
                    output.setApplication("Billing Alerts");
                    output.setMessageId("001");
                    output.setMessage(Messages.getString("cloud.billingalarm.message.invalid_interval_string"));
                    output.setMessageOrg(Messages.getString("cloud.billingalarm.message.invalid_interval_string.org", new Object[]{AlarmServiceManager.facilityID, cronString}));
                    output.setPriority(2);
                    output.setGenerationDate(Long.valueOf(new Date().getTime()));
                    messageQueue.put((Serializable)output);
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    cronTrigger.setCronExpression(CloudPropertyConstants.billingalarm_notify_interval.defaultValue());
                }
                catch (ParseException e1) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                scheduler.deleteJob(AlarmServiceManager.quartzJobName, AlarmServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                logger.warn((Object)("scheduleEjbInvokerJob() deleteJob : " + ((Object)((Object)e)).getClass().getSimpleName() + ", " + e.getMessage()));
            }
            try {
                scheduler.scheduleJob(job, (Trigger)cronTrigger);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
            try {
                scheduler.triggerJob(AlarmServiceManager.quartzJobName, AlarmServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void stop() {
            Logger logger = Logger.getLogger(AlarmServiceImpl.class);
            Scheduler scheduler = null;
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup(AlarmServiceManager.quartzJndiName);
                scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            }
            catch (NamingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                scheduler.deleteJob(AlarmServiceManager.quartzJobName, AlarmServiceManager.quartzJobGroupName);
            }
            catch (SchedulerException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void execute() {
            try {
                new BillingAlarmJob().execute(null);
            }
            catch (JobExecutionException e) {
                Logger logger = Logger.getLogger(BillingAlarmJob.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface AlarmService {
        public void start();

        public void stop();

        public void execute();
    }
}

