/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.common.util;

import com.clustercontrol.cloud.common.util.PropertyStringConstants;
import com.clustercontrol.cloud.common.util.Validator;
import com.clustercontrol.commons.util.HinemosProperties;
import org.jboss.logging.Logger;

public enum CloudPropertyConstants implements PropertyStringConstants
{
    billingalarm_servicename("hinemos.cloud.billingalarm.servicename", "Total,AmazonEC2,AmazonS3,AmazonSimpleDB,AmazonSNS,AWSDataTransfer"),
    billingalarm_notify_interval("hinemos.cloud.billing.notiry.interval", "0 15 * * * ?"),
    autoupdate_node("hinemos.cloud.autoupdate.node", "on", Validator.switchValidator),
    autoupdate_mount("hinemos.cloud.autoupdate.mount", "on", Validator.switchValidator),
    autoupdate_instance("hinemos.cloud.autoupdate.instance", "on", Validator.switchValidator),
    autoupdate_storage("hinemos.cloud.autoupdate.storage", "on", Validator.switchValidator),
    autoupdate_backup("hinemos.cloud.autoupdate.backup", "on", Validator.switchValidator),
    autoupdate_interval("hinemos.cloud.autoupdate.interval", "0 */5 * * * ?"),
    autoregist_scope_relation("hinemos.cloud.autoregist.scope.relation", "on", Validator.switchValidator),
    autoregist_instance("hinemos.cloud.autoregist.instance", "on", Validator.switchValidator),
    autoregist_storage("hinemos.cloud.autouregist.storage", "on", Validator.switchValidator),
    aws_password_crypt_key("hinemos.cloud.aws.password.crypt.key", "hinemos"),
    aws_client_config_connectionTimeout("hinemos.cloud.aws.client.config.connectionTimeout", String.valueOf(50000), Validator.intValidator),
    aws_client_config_maxConnections("hinemos.cloud.aws.client.config.maxConnections", String.valueOf(50), Validator.intValidator),
    aws_client_config_maxErrorRetry("hinemos.cloud.aws.client.config.maxErrorRetry", String.valueOf(3), Validator.intValidator),
    aws_client_config_protocol("hinemos.cloud.aws.client.config.protocol", "https"),
    aws_client_config_proxyDomain("hinemos.cloud.aws.client.config.proxyDomain", null),
    aws_client_config_proxyHost("hinemos.cloud.aws.client.config.proxyHost", null),
    aws_client_config_proxyPassword("hinemos.cloud.aws.client.config.proxyPassword", null),
    aws_client_config_proxyPort("hinemos.cloud.aws.client.config.proxyPort", String.valueOf(-1), Validator.intValidator),
    aws_client_config_proxyUsername("hinemos.cloud.aws.client.config.proxyUsername", null),
    aws_client_config_proxyWorkstation("hinemos.cloud.aws.client.config.proxyWorkstation", null),
    aws_client_config_socketTimeout("hinemos.cloud.aws.client.config.socketTimeout", String.valueOf(50000), Validator.intValidator),
    aws_node_ip("hinemos.cloud.aws.node.ip", "private", new Validator.StringValidator("public", "private")),
    registcheck_interval("hinemos.cloud.registcheck.interval", String.valueOf(10000), Validator.intValidator),
    registcheck_count("hinemos.cloud.registcheck.count", String.valueOf(30), Validator.intValidator),
    agent_connection_interval("agent.connection.interval", String.valueOf(10000), Validator.intValidator),
    agent_connection_count("agent.connection.count", String.valueOf(30), Validator.intValidator),
    templatejob_endcheck_interval("hinemos.cloud.templatejob.endcheck.interval", String.valueOf(10000), Validator.intValidator),
    templatejob_endcheck_count("hinemos.cloud.templatejob.endcheck.count", String.valueOf(30), Validator.intValidator);

    public final String id;
    public final String value;
    public final Validator validator;

    private CloudPropertyConstants(String id, String value) {
        this.id = id;
        this.value = value;
        this.validator = null;
    }

    private CloudPropertyConstants(String id, String value, Validator validator) {
        this.id = id;
        this.value = value;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.value);
        if (this.validator != null) {
            try {
                this.validator.validate(prop);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(CloudPropertyConstants.class);
                logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.value + ")."));
                prop = this.value;
            }
        }
        return prop;
    }

    public boolean match(String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.value;
    }
}

