/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.clustercontrol.cloud.bean.BlockDeviceMapping;
import com.clustercontrol.cloud.bean.GroupIdentifier;
import com.clustercontrol.cloud.bean.InstanceRegistStateType;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceData;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class CloudInstance
implements Serializable {
    private static final long serialVersionUID = 2744959762926787150L;
    private CloudInstanceData tableData;
    private String facilityName;
    private String platform;
    private List<GroupIdentifier> securityGroups = new ArrayList<GroupIdentifier>();
    private String publicDnsName;
    private String imageId;
    private String rootDeviceType;
    private InstanceStateKind state;
    private String instanceType;
    private String keyName;
    private long launchTime;
    private List<Tag> tags = new ArrayList<Tag>();
    private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();

    public CloudInstance() {
        this.tableData = new CloudInstanceData();
        this.tableData.setRegistStatus((short)-1);
    }

    public CloudInstance(CloudInstanceData tableData, String facilityName) {
        this.tableData = new CloudInstanceData(tableData);
        this.facilityName = facilityName;
    }

    public CloudInstance(CloudInstanceData tableData, Instance instance, String facilityName) {
        this(tableData, facilityName);
        this.platform = instance.getPlatform();
        for (com.amazonaws.services.ec2.model.GroupIdentifier awsGI : instance.getSecurityGroups()) {
            GroupIdentifier gi = new GroupIdentifier();
            gi.setGroupId(awsGI.getGroupId());
            gi.setGroupName(awsGI.getGroupName());
            this.securityGroups.add(gi);
        }
        this.publicDnsName = instance.getPublicDnsName();
        this.imageId = instance.getImageId();
        this.rootDeviceType = instance.getRootDeviceType();
        this.state = InstanceStateKind.byLabel(instance.getState().getName());
        this.instanceType = instance.getInstanceType();
        this.keyName = instance.getKeyName();
        this.launchTime = instance.getLaunchTime().getTime();
        for (com.amazonaws.services.ec2.model.Tag t : instance.getTags()) {
            Tag tag = new Tag(t.getKey(), t.getValue());
            this.tags.add(tag);
        }
        for (InstanceBlockDeviceMapping d : instance.getBlockDeviceMappings()) {
            BlockDeviceMapping device = new BlockDeviceMapping(d.getEbs().getVolumeId(), d.getDeviceName(), d.getEbs().getStatus());
            this.blockDeviceMappings.add(device);
        }
    }

    public String getFacilityId() {
        return this.tableData.getFacilityId();
    }

    public void setFacilityId(String facilityId) {
        this.tableData.setFacilityId(facilityId);
    }

    @ReadOnly
    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    @ReadOnly
    public String getInstanceId() {
        return this.tableData.getInstanceId();
    }

    public void setInstanceId(String instanceId) {
        this.tableData.setInstanceId(instanceId);
    }

    @ReadOnly
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Identity(elementId="cloudInstance.cloudId")
    public String getCloudId() {
        return this.tableData.getCloudId();
    }

    public void setCloudId(String cloudId) {
        this.tableData.setCloudId(cloudId);
    }

    @NotNull(elementId="cloudInstance.region")
    public String getRegion() {
        return this.tableData.getRegion();
    }

    public void setRegion(String region) {
        this.tableData.setRegion(region);
    }

    @ReadOnly
    public String getAvailabilityZone() {
        return this.tableData.getAvailabilityZone();
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.tableData.setAvailabilityZone(availabilityZone);
    }

    @Size(elementId="cloudInstance.templateId", max=64)
    public String getTemplateId() {
        return this.tableData.getTemplateId();
    }

    public void setTemplateId(String templateId) {
        this.tableData.setTemplateId(templateId);
    }

    @ReadOnly
    public List<GroupIdentifier> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<GroupIdentifier> securityGroups) {
        this.securityGroups = securityGroups;
    }

    @ReadOnly
    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    @ReadOnly
    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    @ReadOnly
    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    @ReadOnly
    public InstanceStateKind getState() {
        return this.state;
    }

    public void setState(InstanceStateKind state) {
        this.state = state;
    }

    @ReadOnly
    public InstanceRegistStateType getRegistState() {
        return InstanceRegistStateType.byNumber(this.tableData.getRegistStatus());
    }

    public void setRegistState(InstanceRegistStateType registState) {
        this.tableData.setRegistStatus(registState.number());
    }

    @ReadOnly
    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String type) {
        this.instanceType = type;
    }

    @ReadOnly
    public String getKeyPair() {
        return this.keyName;
    }

    public void setKeyPair(String keyName) {
        this.keyName = keyName;
    }

    @ReadOnly
    public Long getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Long launchTime) {
        this.launchTime = launchTime;
    }

    @ReadOnly
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getInstanceName() {
        return this.tableData.getInstanceName();
    }

    public void setInstanceName(String instanceName) {
        this.tableData.setInstanceName(instanceName);
    }

    @ReadOnly
    public String getCloudUserId() {
        return this.tableData.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this.tableData.setCloudUserId(cloudUserId);
    }

    @ReadOnly
    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    @ReadOnly
    public Long getRegDate() {
        return this.tableData.getRegDate() != null ? Long.valueOf(this.tableData.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        if (regDate == null) {
            this.tableData.setRegDate(null);
        } else {
            this.tableData.setRegDate(new Date(regDate));
        }
    }

    @ReadOnly
    public Long getUpdateDate() {
        return this.tableData.getUpdateDate() != null ? Long.valueOf(this.tableData.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        if (updateDate == null) {
            this.tableData.setUpdateDate(null);
        } else {
            this.tableData.setUpdateDate(new Date(updateDate));
        }
    }

    @ReadOnly
    public String getRegUser() {
        return this.tableData.getRegUser();
    }

    public void setRegUser(String regUser) {
        this.tableData.setRegUser(regUser);
    }

    @ReadOnly
    public String getUpdateUser() {
        return this.tableData.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        this.tableData.setUpdateUser(updateUser);
    }

    public String toString() {
        return this.tableData.toString();
    }

    @XmlTransient
    public CloudInstanceData getTableData() {
        return this.tableData;
    }
}

