/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.transform.CacheNodeTypeSpecificParameterStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineDefaultsStaxUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static EngineDefaultsStaxUnmarshaller instance;

    @Override
    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        EngineDefaults engineDefaults = new EngineDefaults();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return engineDefaults;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheParameterGroupFamily", targetDepth)) {
                    engineDefaults.setCacheParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Marker", targetDepth)) {
                    engineDefaults.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters/Parameter", targetDepth)) {
                    engineDefaults.getParameters().add(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CacheNodeTypeSpecificParameters/CacheNodeTypeSpecificParameter", targetDepth)) continue;
                engineDefaults.getCacheNodeTypeSpecificParameters().add(CacheNodeTypeSpecificParameterStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return engineDefaults;
    }

    public static EngineDefaultsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EngineDefaultsStaxUnmarshaller();
        }
        return instance;
    }
}

