/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.bean;

/**
 * HinemosのRole(権限)種類を定数として格納するクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.0.0
 */
public final class RoleConstant {

	/** Hinemosユーザ(内部用) */
	public static final String HINEMOS_USER = "HinemosUser";
	/** Hinemosエージェントアクセス(内部用) */
	public static final String HINEMOS_AGENT_ACCESS = "HinemosAgentAccess";


	/** リポジトリ - 参照権限 */
	public static final String REPOSITORY_READ = "RepositoryRead";
	/** リポジトリ - 設定権限 */
	public static final String REPOSITORY_WRITE = "RepositoryWrite";
	/** リポジトリ - 実行権限 */
	public static final String REPOSITORY_EXECUTE = "RepositoryExecute";
	/** ユーザ管理 - 参照権限 */
	public static final String ACCESSCONTROL_READ = "AccessControlRead";
	/** ユーザ管理 - 設定権限 */
	public static final String ACCESSCONTROL_WRITE = "AccessControlWrite";
	/** ジョブ管理 - 参照権限 */
	public static final String JOBMANAGEMENT_READ = "JobManagementRead";
	/** ジョブ管理 - 設定権限 */
	public static final String JOBMANAGEMENT_WRITE = "JobManagementWrite";
	/** ジョブ管理 - 実行権限 */
	public static final String JOBMANAGEMENT_EXECUTE = "JobManagementExecute";
	/** 一括制御 - 参照権限 */
	public static final String COLLECTIVERUN_READ = "CollectiveRunRead";
	/** 一括制御 - 設定権限 */
	public static final String COLLECTIVERUN_WRITE = "CollectiveRunWrite";
	/** 一括制御 - 実行権限 */
	public static final String COLLECTIVERUN_EXECUTE = "CollectiveRunExecute";
	/** 性能管理 - 参照権限 */
	public static final String PERFORMANCE_READ = "PerformanceRead";
	/** 性能管理 - 実行権限 */
	public static final String PERFORMANCE_EXECUTE = "PerformanceExecute";
	/** 監視結果 - 参照権限 */
	public static final String MONITOR_RESULT_READ = "MonitorResultRead";
	/** 監視結果 - 設定権限 */
	public static final String MONITOR_RESULT_WRITE = "MonitorResultWrite";
	/** 監視設定 - 参照権限 */
	public static final String MONITOR_SETTING_READ = "MonitorSettingRead";
	/** 監視設定 - 設定権限 */
	public static final String MONITOR_SETTING_WRITE = "MonitorSettingWrite";
	/** カレンダ - 参照権限 */
	public static final String CALENDAR_READ = "CalendarRead";
	/** カレンダ - 設定権限 */
	public static final String CALENDAR_WRITE = "CalendarWrite";
	/** 通知 - 参照権限 */
	public static final String NOTIFY_READ = "NotifyRead";
	/** 通知 - 設定権限 */
	public static final String NOTIFY_WRITE = "NotifyWrite";
	/** 履歴情報削除 - 参照権限 */
	public static final String MAINTENANCE_READ = "MaintenanceRead";
	/** 履歴情報削除 - 設定権限 */
	public static final String MAINTENANCE_WRITE = "MaintenanceWrite";
	/** 仮想化管理 - 参照権限 */
	public static final String VMMANAGEMENT_READ = "VmManagementRead";
	/** 仮想化管理 - 設定権限 */
	public static final String VMMANAGEMENT_WRITE = "VmManagementWrite";
	/** 仮想化管理 - 実行権限 */
	public static final String VMMANAGEMENT_EXECUTE = "VmManagementExecute";
}
