#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################

VERSION=`cat ${HINEMOS_HOME}/_version`

PGPORT=24001
DBNAME=hinemos
USER=hinemos
DBPASSWORD=hinemos

PSQLCMD="${PG_HOME}/bin/psql -p ${PGPORT} -U ${USER} -d ${DBNAME} "

########################################
#  Local Message
########################################

# INFO
MSG_I001="clearing temporary data (messages in queue and transaction files)"
#MSG_I002="   - ${PROG} start at "
MSG_I003="   - hinemos version (installed) : "
MSG_I004="removed jbm_msg records."
MSG_I005="removed jbm_msg_ref records."
MSG_I006="removed jbm_tx records."
MSG_I007="removed transaction files."
MSG_I009="skipping removing transaction files. (transaction file is not found)"
MSG_I101="successful in clearing temporary data."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to truncate jbm_msg table."
MSG_E002="failed to truncate jbm_msg_ref table."
MSG_E003="failed to truncate jbm_tx table."
MSG_E004="failed to remove transaction files."
MSG_E005="failed to clear temporary data."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG}"
	echo "  -w passwd  set password (for Hinemos RDBM Server)"
}

#
# truncate jboss messaging(jbm_xxx) tables in PostgreSQL
#
function clean_jbm_table {
	ReadPostgreSQLPasswd
	
	MSG=`${PSQLCMD} -c "TRUNCATE jbm_msg" > /dev/null 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	Logging "${MSG_I004}"
	
	MSG=`${PSQLCMD} -c "TRUNCATE jbm_msg_ref" > /dev/null 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG}"
		Logging "${MSG_E002}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	Logging "${MSG_I005}"
	
	MSG=`${PSQLCMD} -c "TRUNCATE jbm_tx" > /dev/null 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E003}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	Logging "${MSG_I006}"
	
	return 0
}

#
# remove jta transaction files
#
function clean_tx_files {
	if [ ! -e ${JBOSS_HOME}/server/hinemos/data/tx-object-store ]
	then
		Logging "${MSG_I009}"
		return 0
	fi
	
	MSG=`rm -rf ${JBOSS_HOME}/server/hinemos/data/tx-object-store`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG}"
		Logging "${MSG_E004}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	
	Logging "${MSG_I007}"

	return 0
}

########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
while getopts w: OPT
do
	case $OPT in
		w)
			PASSWD=$OPTARG
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

# chekc user
CheckUser root


# check process
CheckJBossProcessStopped
CheckPostgreSQLProcessRunning

# main
Logging "${MSG_I001}"
Logging "${MSG_I003}${VERSION}"

clean_jbm_table && clean_tx_files
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG_E005}"

	exit ${RET}
fi

########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit ${RET}
