#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

export JAVA_OPTS="-Xms16m -Xmx32m"

# for twiddle.log
cd ${HINEMOS_HOME}/var/log

########################################
#  Local Variable
########################################

SERVICE="user:service=HinemosService,name=HinemosService"

########################################
#  Local Message
########################################

# INFO
MSG_I001="resetting notification counter..."
MSG_I101="successful in reset notification counter."

# WARN
#MSG_W001=""

# ERROR
MSG_E001="failed to access MBean (${SERVICE})."
MSG_E002="failed to reset notification counter."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG}"
}

#
# show status
#
function reset_notification_counter {
	Logging "${MSG_I001}"
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} resetNotificationLogger > /dev/null
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	
	return 0
}


########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi


# check process
CheckJBossProcessRunning


# main
if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

reset_notification_counter
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG_E002}"

	exit ${RET}
fi

########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit 0
