--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

--
-- Data for Name: cc_cal_add_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_add_info (calendar_id, time_from, time_to, execute_flg, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_cal_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_info (calendar_id, calendar_name, description, start_time, valid_time_from, valid_time_to, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_cal_weekday_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cal_weekday_info (calendar_id, weekday, time_from, time_to, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_calculated_data; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_calculated_data (collectorid, item_code, display_name, date_time, facilityid, value) FROM stdin;
\.


--
-- Data for Name: cc_cfg_facility; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_facility (facility_id, facility_name, facility_type, description, display_sort_order, valid, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
INTERNAL	Hinemos内部スコープ	0	Hinemosの内部イベントを出力するスコープ	10000	1		2012-04-01 00:00:00		2012-04-01 00:00:00
REGISTERED	登録ノードすべて	0	リポジトリに登録されているすべてのノードを含むスコープ	11000	1		2012-04-01 00:00:00		2012-04-01 00:00:00
UNREGISTERED	未登録ノード	0	未登録のノードから受信した通知情報を格納するスコープ	12000	1		2012-04-01 00:00:00		2012-04-01 00:00:00
\.


--
-- Data for Name: cc_cfg_facility_relation; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_facility_relation (parent_facility_id, child_facility_id) FROM stdin;
\.


--
-- Data for Name: cc_cfg_node_hostname; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_node_hostname (facility_id, hostname) FROM stdin;
\.


--
-- Data for Name: cc_cfg_node_note; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_node_note (facility_id, note_id, note) FROM stdin;
\.


--
-- Data for Name: cc_cfg_user; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_user (user_id, user_name, password, user_type, description, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
HINEMOS_AGENT	Hinemos Agent User	aUsvyaFgjwrB+HX2n+07RA==	system_user	Hinemos System User for Hinemos Agent		2012-04-01 00:00:00		2012-04-01 00:00:00
hinemos	Hinemos Administrator	A+s8VNabt46y5IlsF/bhpA==	login_user			2012-04-01 00:00:00		2012-04-01 00:00:00
\.


--
-- Data for Name: cc_cfg_user_role; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_user_role (user_id, user_role) FROM stdin;
HINEMOS_AGENT	HinemosAgentAccess
hinemos	AccessControlRead
hinemos	AccessControlWrite
hinemos	CalendarRead
hinemos	CalendarWrite
hinemos	CollectiveRunExecute
hinemos	CollectiveRunRead
hinemos	CollectiveRunWrite
hinemos	HinemosUser
hinemos	JobManagementExecute
hinemos	JobManagementRead
hinemos	JobManagementWrite
hinemos	MaintenanceRead
hinemos	MaintenanceWrite
hinemos	MonitorResultRead
hinemos	MonitorResultWrite
hinemos	MonitorSettingRead
hinemos	MonitorSettingWrite
hinemos	NotifyRead
hinemos	NotifyWrite
hinemos	PerformanceExecute
hinemos	PerformanceRead
hinemos	RepositoryExecute
hinemos	RepositoryRead
hinemos	RepositoryWrite
hinemos	VmManagementExecute
hinemos	VmManagementRead
hinemos	VmManagementWrite
\.


--
-- Data for Name: cc_collector_calc_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_calc_method_mst (calc_method, class_name, expression) FROM stdin;
DividedBy100	com.clustercontrol.performance.operator.DividedBy100	
DividedBy1000	com.clustercontrol.performance.operator.DividedBy1000	
InvPercentage	com.clustercontrol.performance.operator.InvPercentage	
InvPercentage12	com.clustercontrol.performance.operator.InvPercentage12	
InvPercentage22	com.clustercontrol.performance.operator.InvPercentage22	
InvPercentage31	com.clustercontrol.performance.operator.InvPercentage31	
InvPercentageOfTotal	com.clustercontrol.performance.operator.InvPercentageOfTotal	
InvTimeMeanPercentage	com.clustercontrol.performance.operator.InvTimeMeanPercentage	
MultipliedBy1000	com.clustercontrol.performance.operator.MultipliedBy1000	
Non	com.clustercontrol.performance.operator.Non	
Percentage	com.clustercontrol.performance.operator.Percentage	
PercentageDiff	com.clustercontrol.performance.operator.PercentageDiff	
PercentageDiffAdd	com.clustercontrol.performance.operator.PercentageDiffAdd	
PercentageOfTotal	com.clustercontrol.performance.operator.PercentageOfTotal	
Sum	com.clustercontrol.performance.operator.Sum	
SumPerTotal	com.clustercontrol.performance.operator.SumPerTotal	
TimeMean	com.clustercontrol.performance.operator.TimeMean	
TimeMeanDiff	com.clustercontrol.performance.operator.TimeMeanDiff	
TimeMeanDivDiff	com.clustercontrol.performance.operator.TimeMeanDivDiff	
TimeMeanDivDiffLimit	com.clustercontrol.performance.operator.TimeMeanDivDiffLimit	
TimeMeanKbyte	com.clustercontrol.performance.operator.TimeMeanKbyte	
TimeMeanKbyteDiff	com.clustercontrol.performance.operator.TimeMeanKbyteDiff	
TimeMeanPerSec	com.clustercontrol.performance.operator.TimeMeanPerSec	
TimeMeanPerTotal	com.clustercontrol.performance.operator.TimeMeanPerTotal	
TimeMeanProdDiff	com.clustercontrol.performance.operator.TimeMeanProdDiff	
TimeMeanProdDiffLimit	com.clustercontrol.performance.operator.TimeMeanProdDiffLimit	
TimeMeanSum	com.clustercontrol.performance.operator.TimeMeanSum	
TimeMeanSumDiff	com.clustercontrol.performance.operator.TimeMeanSumDiff	
\.


--
-- Data for Name: cc_collector_category_collect_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_category_collect_mst (platform_id, sub_platform_id, category_code, collect_method) FROM stdin;
LINUX		C000_CPU	SNMP
LINUX		C001_MEM	SNMP
LINUX		C002_DSK	SNMP
LINUX		C003_NET	SNMP
LINUX		C004_FS	SNMP
NW_EQUIPMENT		C003_NET	SNMP
WINDOWS		C000_CPU	SNMP
WINDOWS		C001_MEM	SNMP
WINDOWS		C002_DSK	SNMP
WINDOWS		C003_NET	SNMP
WINDOWS		C004_FS	SNMP
\.


--
-- Data for Name: cc_collector_category_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_category_mst (category_code, category_name) FROM stdin;
C000_CPU	CPU
C001_MEM	メモリ
C002_DSK	ディスク
C003_NET	ネットワーク
C004_FS	ファイルシステム
C010_MON	監視
\.


--
-- Data for Name: cc_collector_item_calc_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_item_calc_method_mst (collect_method, platform_id, sub_platform_id, item_code, calc_method) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	InvPercentageOfTotal
SNMP	LINUX		CPU0101_CPU_UTIL_USR	PercentageOfTotal
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
SNMP	LINUX		CPU0200_INTERRUPT_RATE	TimeMean
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	TimeMean
SNMP	LINUX		CPU0400_LOAD_AVE_1M	DividedBy100
SNMP	LINUX		CPU0500_LOAD_AVE_5M	DividedBy100
SNMP	LINUX		CPU0600_LOAD_AVE_15M	DividedBy100
SNMP	LINUX		DSK0100_DVC_IO_CNT	TimeMeanSum
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	TimeMean
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	TimeMean
SNMP	LINUX		DSK0200_DVC_IO_BYTE	TimeMeanSum
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	TimeMean
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	TimeMean
SNMP	LINUX		FS_0100_DVC_UTIL	Percentage
SNMP	LINUX		MEM0100_MEM_UTIL	InvPercentage12
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
SNMP	LINUX		MEM0200_SWAP_SPACE	InvPercentage
SNMP	LINUX		MEM0300_PHYS_UTIL	InvPercentage
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	InvPercentage31
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	Percentage
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	Percentage
SNMP	LINUX		MEM0400_SWAP_IO	Sum
SNMP	LINUX		MEM0401_SWAP_IO_IN	Non
SNMP	LINUX		MEM0402_SWAP_IO_OUT	Non
SNMP	LINUX		MEM0600_SWAP_BLK	TimeMeanSum
SNMP	LINUX		MEM0601_SWAP_BLK_IN	TimeMean
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	TimeMean
SNMP	LINUX		NET0100_PACKET	TimeMeanPerTotal
SNMP	LINUX		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0200_DVC_PCK	TimeMeanSum
SNMP	LINUX		NET0201_DVC_PCK_RCV	TimeMean
SNMP	LINUX		NET0202_DVC_PCK_SNT	TimeMean
SNMP	LINUX		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	LINUX		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	LINUX		NET0500_BYTE	TimeMeanPerTotal
SNMP	LINUX		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0600_DVC_BYTE	TimeMeanSum
SNMP	LINUX		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	LINUX		NET0602_DVC_BYTE_SNT	TimeMean
SNMP	NW_EQUIPMENT		NET0100_PACKET	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	TimeMean
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	NW_EQUIPMENT		NET0500_BYTE	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	TimeMean
SNMP	WINDOWS		CPU0100_CPU_UTIL	InvPercentageOfTotal
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	PercentageOfTotal
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	TimeMean
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	TimeMean
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	TimeMeanSum
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	TimeMean
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	TimeMean
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	TimeMeanSum
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	TimeMean
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	TimeMean
SNMP	WINDOWS		FS_0100_DVC_UTIL	Percentage
SNMP	WINDOWS		MEM0100_MEM_UTIL	InvPercentage12
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
SNMP	WINDOWS		MEM0200_SWAP_SPACE	InvPercentage
SNMP	WINDOWS		MEM0300_PHYS_UTIL	InvPercentage
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	InvPercentage31
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	Percentage
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	Percentage
SNMP	WINDOWS		MEM0400_SWAP_IO	Sum
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	Non
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	Non
SNMP	WINDOWS		NET0100_PACKET	TimeMeanPerTotal
SNMP	WINDOWS		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0200_DVC_PCK	TimeMeanSum
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	TimeMean
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	TimeMean
SNMP	WINDOWS		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	WINDOWS		NET0500_BYTE	TimeMeanPerTotal
SNMP	WINDOWS		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0600_DVC_BYTE	TimeMeanSum
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	TimeMean
WBEM	LINUX		CPU0100_CPU_UTIL	InvPercentageOfTotal
WBEM	LINUX		CPU0101_CPU_UTIL_USR	PercentageOfTotal
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
WBEM	LINUX		DSK0100_DVC_IO_CNT	TimeMeanPerSec
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	TimeMeanPerSec
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	TimeMeanPerSec
WBEM	LINUX		DSK0200_DVC_IO_BYTE	TimeMeanKbyte
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	TimeMeanKbyte
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	TimeMeanKbyteDiff
WBEM	LINUX		FS_0101_DVC_UTIL	InvPercentage
WBEM	LINUX		FS_0102_DVC_UTIL	InvPercentage
WBEM	LINUX		MEM0100_MEM_UTIL	InvPercentage22
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
WBEM	LINUX		MEM0200_SWAP_SPACE	InvPercentage
WBEM	LINUX		MEM0300_PHYS_UTIL	InvPercentage
WBEM	LINUX		MEM0400_SWAP_IO	Non
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	Non
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	Non
\.


--
-- Data for Name: cc_collector_item_code_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_item_code_mst (item_code, category_code, parent_item_code, item_name, measure, device_support, device_type, graph_range) FROM stdin;
CPU0100_CPU_UTIL	C000_CPU	\N	CPU使用率	%	0		1
CPU0101_CPU_UTIL_USR	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(ユーザ)	%	0		1
CPU0102_CPU_UTIL_SYS	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(システム)	%	0		1
CPU0103_CPU_UTIL_NCE	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(Niceプロセス)	%	0		1
CPU0104_CPU_UTIL_IOW	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(入出力待機)	%	0		1
CPU0200_INTERRUPT_RATE	C000_CPU	\N	インタラプトレート	回/s	0		0
CPU0300_CONTEXT_SWITCH	C000_CPU	\N	コンテキストスイッチ	回/s	0		0
CPU0400_LOAD_AVE_1M	C000_CPU	\N	ロードアベレージ1分平均	個/s	0		0
CPU0500_LOAD_AVE_5M	C000_CPU	\N	ロードアベレージ5分平均	個/s	0		0
CPU0600_LOAD_AVE_15M	C000_CPU	\N	ロードアベレージ15分平均	個/s	0		0
CPU0700_CPU_MHZ	C000_CPU	\N	CPU使用量	Mhz	0		0
CPU0800_CPU_READY	C000_CPU	\N	CPU不足量	msec	0		0
DSK0100_DVC_IO_CNT	C002_DSK	\N	デバイス別ディスクI/O回数	回/s	1	disk	0
DSK0101_DVC_IO_CNT_IN	C002_DSK	DSK0100_DVC_IO_CNT	デバイス別ディスクI/O回数(読み取り)	回/s	1	disk	0
DSK0102_DVC_IO_CNT_OUT	C002_DSK	DSK0100_DVC_IO_CNT	デバイス別ディスクI/O回数(書き込み)	回/s	1	disk	0
DSK0200_DVC_IO_BYTE	C002_DSK	\N	デバイス別ディスクI/O量	byte/s	1	disk	0
DSK0201_DVC_IO_BYTE_IN	C002_DSK	DSK0200_DVC_IO_BYTE	デバイス別ディスクI/O量(読み取り)	byte/s	1	disk	0
DSK0202_DVC_IO_BYTE_OUT	C002_DSK	DSK0200_DVC_IO_BYTE	デバイス別ディスクI/O量(書き込み)	byte/s	1	disk	0
FS_0100_DVC_UTIL	C004_FS	\N	ファイルシステム使用率	%	1	filesystem	1
FS_0101_DVC_UTIL	C004_FS	\N	ファイルシステム使用率(ext3)	%	1	filesystem	1
FS_0102_DVC_UTIL	C004_FS	\N	ファイルシステム使用率(ext4)	%	1	filesystem	1
MEM0100_MEM_UTIL	C001_MEM	\N	メモリ使用率	%	0		1
MEM0101_MEM_UTIL_SWAP	C001_MEM	MEM0100_MEM_UTIL	メモリ使用率(スワップ)	%	0		1
MEM0102_MEM_UTIL_PHYS	C001_MEM	MEM0100_MEM_UTIL	メモリ使用率(実メモリ)	%	0		1
MEM0200_SWAP_SPACE	C001_MEM	\N	スワップ領域中のメモリ使用率	%	0		1
MEM0300_PHYS_UTIL	C001_MEM	\N	実メモリ中のメモリ使用率	%	0		1
MEM0301_PHYS_UTIL_USR	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(ユーザ)	%	0		1
MEM0302_PHYS_UTIL_BUF	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(バッファ)	%	0		1
MEM0303_PHYS_UTIL_CAC	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(キャッシュ)	%	0		1
MEM0400_SWAP_IO	C001_MEM	\N	スワップI/O	kB/s	0		0
MEM0401_SWAP_IO_IN	C001_MEM	MEM0400_SWAP_IO	スワップI/O(イン)	kB/s	0		0
MEM0402_SWAP_IO_OUT	C001_MEM	MEM0400_SWAP_IO	スワップI/O(アウト)	kB/s	0		0
MEM0500_MEM_MB	C001_MEM	\N	メモリ使用量	MB	0		0
MEM0600_SWAP_BLK	C001_MEM	\N	スワップブロック数	ブロック/s	0		0
MEM0601_SWAP_BLK_IN	C001_MEM	MEM0600_SWAP_BLK	スワップブロック数(イン)	ブロック/s	0		0
MEM0602_SWAP_BLK_OUT	C001_MEM	MEM0600_SWAP_BLK	スワップブロック数(アウト)	ブロック/s	0		0
MEM0700_SWAP_MB	C001_MEM	\N	スワップ使用量	MB	0		0
NET0100_PACKET	C003_NET	\N	パケット数合計	個/s	0		0
NET0101_PACKET_RCV	C003_NET	NET0100_PACKET	パケット数合計（受信）	個/s	0		0
NET0102_PACKET_SNT	C003_NET	NET0100_PACKET	パケット数合計（送信）	個/s	0		0
NET0200_DVC_PCK	C003_NET	\N	デバイス別パケット数	個/s	1	nic	0
NET0201_DVC_PCK_RCV	C003_NET	NET0200_DVC_PCK	デバイス別パケット数（受信）	個/s	1	nic	0
NET0202_DVC_PCK_SNT	C003_NET	NET0200_DVC_PCK	デバイス別パケット数（送信）	個/s	1	nic	0
NET0300_ERR_PCK	C003_NET	\N	エラーパケット数合計	個/s	0		0
NET0301_ERR_PCK_RCV	C003_NET	NET0300_ERR_PCK	エラーパケット数合計（受信）	個/s	0		0
NET0302_ERR_PCK_SNT	C003_NET	NET0300_ERR_PCK	エラーパケット数合計（送信）	個/s	0		0
NET0400_DVC_ERR_PCK	C003_NET	\N	デバイス別エラーパケット数	個/s	1	nic	0
NET0401_DVC_ERR_PCK_RCV	C003_NET	NET0400_DVC_ERR_PCK	デバイス別エラーパケット数（受信）	個/s	1	nic	0
NET0402_DVC_ERR_PCK_SNT	C003_NET	NET0400_DVC_ERR_PCK	デバイス別エラーパケット数（送信）	個/s	1	nic	0
NET0500_BYTE	C003_NET	\N	ネットワーク情報量	byte/s	0		0
NET0501_BYTE_RCV	C003_NET	NET0500_BYTE	ネットワーク情報量（受信）	byte/s	0		0
NET0502_BYTE_SNT	C003_NET	NET0500_BYTE	ネットワーク情報量（送信）	byte/s	0		0
NET0600_DVC_BYTE	C003_NET	\N	デバイス別ネットワーク情報量	byte/s	1	nic	0
NET0601_DVC_BYTE_RCV	C003_NET	NET0600_DVC_BYTE	デバイス別ネットワーク情報量（受信）	byte/s	1	nic	0
NET0602_DVC_BYTE_SNT	C003_NET	NET0600_DVC_BYTE	デバイス別ネットワーク情報量（送信）	byte/s	1	nic	0
CPU0110_DVC_CPU_UTIL	C000_CPU	\N	CPUコア別使用率	%	1	cpu	1
\.


--
-- Data for Name: cc_collector_platform_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_platform_mst (platform_id, platform_name, order_no) FROM stdin;
LINUX	Linux	0
NW_EQUIPMENT	Network Equipment	100
OTHER	Other	1000
WINDOWS	Windows	20
\.


--
-- Data for Name: cc_collector_polling_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_polling_mst (collect_method, platform_id, sub_platform_id, item_code, variable_id, entry_key, value_type, polling_target, failure_value) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	Counter32	.1.3.6.1.4.1.2021.11.59	\N
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	Counter32	.1.3.6.1.4.1.2021.11.60	\N
SNMP	LINUX		CPU0400_LOAD_AVE_1M	var0	.1.3.6.1.4.1.2021.10.1.5.1	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		CPU0500_LOAD_AVE_5M	var0	.1.3.6.1.4.1.2021.10.1.5.2	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		CPU0600_LOAD_AVE_15M	var0	.1.3.6.1.4.1.2021.10.1.5.3	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	LINUX		FS_0100_DVC_UTIL	key	.1.3.6.1.2.1.25.2.3.1.3.?	String	.1.3.6.1.2.1.25.2.3.1.3	\N
SNMP	LINUX		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	Integer32	.1.3.6.1.2.1.25.2.3.1.6	\N
SNMP	LINUX		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	Integer32	.1.3.6.1.2.1.25.2.3.1.5	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	Integer32	.1.3.6.1.4.1.2021.4.11	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	LINUX		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	LINUX		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	LINUX		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	LINUX		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var1	.1.3.6.1.4.1.2021.11.62.0	Counter32	.1.3.6.1.4.1.2021.11.62	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var2	.1.3.6.1.4.1.2021.11.63.0	Counter32	.1.3.6.1.4.1.2021.11.63	\N
SNMP	LINUX		MEM0601_SWAP_BLK_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0601_SWAP_BLK_IN	var1	.1.3.6.1.4.1.2021.11.62.0	Counter32	.1.3.6.1.4.1.2021.11.62	\N
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	var1	.1.3.6.1.4.1.2021.11.63.0	Counter32	.1.3.6.1.4.1.2021.11.63	\N
SNMP	LINUX		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	Counter32	.1.3.6.1.4.1.2021.11.59	\N
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	Counter32	.1.3.6.1.4.1.2021.11.60	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	key	.1.3.6.1.2.1.25.2.3.1.3.?	String	.1.3.6.1.2.1.25.2.3.1.3	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	Integer32	.1.3.6.1.2.1.25.2.3.1.6	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	Integer32	.1.3.6.1.2.1.25.2.3.1.5	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	Integer32	.1.3.6.1.4.1.2021.4.11	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	WINDOWS		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	WINDOWS		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var0	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var3	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var4		Uint64		0
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var0	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var1	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var4		Uint64		0
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var0	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var4		Uint64		0
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var0		Uint64		0
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var1	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var2	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var3	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var4	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var0	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var4		Uint64		0
WBEM	LINUX		DSK0100_DVC_IO_CNT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0100_DVC_IO_CNT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0100_DVC_IO_CNT	var1	Linux_BlockStorageStatisticalData.TotalIOs.?	Uint64	Linux_BlockStorageStatisticalData.TotalIOs	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var1	Linux_BlockStorageStatisticalData.ReadIOs.?	Uint64	Linux_BlockStorageStatisticalData.ReadIOs	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	Linux_BlockStorageStatisticalData.WriteIOs.?	Uint64	Linux_BlockStorageStatisticalData.WriteIOs	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Uint64	Linux_BlockStorageStatisticalData.KBytesTransfered	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	Linux_BlockStorageStatisticalData.KBytesRead.?	Uint64	Linux_BlockStorageStatisticalData.KBytesRead	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Uint64	Linux_BlockStorageStatisticalData.KBytesTransfered	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var2	Linux_BlockStorageStatisticalData.KBytesRead.?	Uint64	Linux_BlockStorageStatisticalData.KBytesRead	\N
WBEM	LINUX		FS_0101_DVC_UTIL	key	Linux_Ext3FileSystem.Root.?	String	Linux_Ext3FileSystem.Root	\N
WBEM	LINUX		FS_0101_DVC_UTIL	var0	Linux_Ext3FileSystem.AvailableSpace.?	Uint64	Linux_Ext3FileSystem.AvailableSpace	\N
WBEM	LINUX		FS_0101_DVC_UTIL	var1	Linux_Ext3FileSystem.FileSystemSize.?	Uint64	Linux_Ext3FileSystem.FileSystemSize	\N
WBEM	LINUX		FS_0102_DVC_UTIL	key	Linux_Ext4FileSystem.Root.?	String	Linux_Ext4FileSystem.Root	\N
WBEM	LINUX		FS_0102_DVC_UTIL	var0	Linux_Ext4FileSystem.AvailableSpace.?	Uint64	Linux_Ext4FileSystem.AvailableSpace	\N
WBEM	LINUX		FS_0102_DVC_UTIL	var1	Linux_Ext4FileSystem.FileSystemSize.?	Uint64	Linux_Ext4FileSystem.FileSystemSize	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var1	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var2	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var3	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var0	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var2	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var0	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var2	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0200_SWAP_SPACE	var0	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0200_SWAP_SPACE	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0300_PHYS_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0300_PHYS_UTIL	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0400_SWAP_IO	var0	Linux_OperatingSystem.TotalSwapSpaceSize.0	Uint64	Linux_OperatingSystem.TotalSwapSpaceSize	\N
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	key	.1.3.6.1.2.1.25.3.2.1.1.?	String	.1.3.6.1.2.1.25.3.2.1.1	\N
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	var0	.1.3.6.1.2.1.25.3.3.1.2.?	Integer32	.1.3.6.1.2.1.25.3.3.1.2	\N
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	key	.1.3.6.1.2.1.25.3.2.1.1.?	String	.1.3.6.1.2.1.25.3.2.1.1	\N
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	var0	.1.3.6.1.2.1.25.3.3.1.2.?	Integer32	.1.3.6.1.2.1.25.3.3.1.2	\N
\.


--
-- Data for Name: cc_crun_cmd_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) FROM stdin;
ADD_USER	USER	0	add.user	1	/opt/hinemos/lib/cr/useradd.sh
AGENT_INSTALL	AGENT	0	agent.installation	1	/opt/hinemos/lib/cr/agent_install.sh
COPY_FILE	FILE	0	copy.file	1	/opt/hinemos/lib/cr/cp.sh
DELETE_USER	USER	2	delete.user	0	/usr/sbin/userdel -r
FILEJOB_SETTING	AGENT	1	setting.file.transfer	1	/opt/hinemos/lib/cr/file_transfer_setting.sh
MAKE_DIRECTORY	FILE	1	make.directory	1	/opt/hinemos/lib/cr/mkdir.sh
MODIFY_USER	USER	1	modify.user	1	/opt/hinemos/lib/cr/usermod.sh
REBOOT_LINUX	START_STOP	0	reboot.linux	0	/sbin/reboot
REMOVE_FILE	FILE	2	remove.file.directory	1	/opt/hinemos/lib/cr/rm.sh
RPM_INSTALL	INSTALL	0	rpm.installation	1	/opt/hinemos/lib/cr/rpminstall.sh
SHUTDOWN_LINUX	START_STOP	1	shutdown.linux	0	/sbin/poweroff
START_APACHE	START_STOP	2	start.apache	0	/etc/init.d/httpd start
STOP_APACHE	START_STOP	3	stop.apache	0	/etc/init.d/httpd stop
\.


--
-- Data for Name: cc_crun_cmd_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) FROM stdin;
ADD_USER	GROUP_NAME	3	-g
ADD_USER	HOME_DIRECTORY	6	-d
ADD_USER	LOGIN_SHELL	5	-s
ADD_USER	PASSWORD	2	-p
ADD_USER	SECONDARY_GROUP_NAME	4	-G
ADD_USER	UID	0	-u
ADD_USER	USER_NAME	1	\N
AGENT_INSTALL	AGENT_PATH	4	-a
AGENT_INSTALL	AGENT_PLACE	5	-w
AGENT_INSTALL	JRE_LICENSE	6	-j
AGENT_INSTALL	MANAGER_ADDRESS	1	-m
AGENT_INSTALL	MANAGER_IP	2	-i
AGENT_INSTALL	MANAGER_ROOT_PASSWORD	3	-p
COPY_FILE	DESTINATION	1	-d
COPY_FILE	FILE_PERMISSION	4	-m
COPY_FILE	GROUP_NAME	3	-g
COPY_FILE	SOURCE_FILE	0	\N
COPY_FILE	USER_NAME	2	-u
DELETE_USER	USER_NAME	0	\N
FILEJOB_SETTING	FILE_TRANSFER_USER	2	-u
FILEJOB_SETTING	ROOT_PASSWORD	1	-r
FILEJOB_SETTING	TRANSFER_IP	0	-i
FILEJOB_SETTING	TRANSFER_PASSWORD	3	-p
MAKE_DIRECTORY	DIRECTORY_NAME	0	\N
MAKE_DIRECTORY	DIRECTORY_PERMISSION	3	-m
MAKE_DIRECTORY	GROUP_NAME	2	-g
MAKE_DIRECTORY	USER_NAME	1	-u
MODIFY_USER	GROUP_NAME	2	-g
MODIFY_USER	LOGIN_SHELL	4	-s
MODIFY_USER	PASSWORD	1	-p
MODIFY_USER	SECONDARY_GROUP_NAME	3	-G
MODIFY_USER	USER_NAME	0	\N
REMOVE_FILE	FILE_DIRECTORY	0	\N
REMOVE_FILE	USER_NAME	1	-u
RPM_INSTALL	FILE	0	\N
\.


--
-- Data for Name: cc_crun_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) FROM stdin;
ADD_USER	0	0	0
ADD_USER	1	1	2
AGENT_INSTALL	0	0	0
AGENT_INSTALL	1	1	9
COPY_FILE	0	0	0
COPY_FILE	1	1	9
DELETE_USER	0	0	0
FILEJOB_SETTING	0	0	0
FILEJOB_SETTING	1	1	9
MAKE_DIRECTORY	0	0	0
MAKE_DIRECTORY	1	1	9
MODIFY_USER	0	0	0
MODIFY_USER	1	1	2
REBOOT_LINUX	0	0	0
REMOVE_FILE	0	0	0
RPM_INSTALL	0	0	0
RPM_INSTALL	1	1	9
SHUTDOWN_LINUX	0	0	0
START_APACHE	0	0	0
STOP_APACHE	0	0	0
\.


--
-- Data for Name: cc_crun_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_mst (param_id, name_id, param_type) FROM stdin;
AGENT_PATH	agent.path	0
AGENT_PLACE	agent.place	0
DESTINATION	destination	0
DIRECTORY_NAME	directory.name	0
DIRECTORY_PERMISSION	file.access.permission	2
FILE	file	0
FILE_DIRECTORY	file.directory	0
FILE_PERMISSION	file.access.permission	2
FILE_TRANSFER_USER	file.transfer.user	0
GROUP_NAME	group.name	0
HOME_DIRECTORY	home.directory	0
JRE_LICENSE	jre.license	2
LOGIN_SHELL	login.shell	2
MANAGER_ADDRESS	manager.hinemos.address	0
MANAGER_IP	manager.ip.address	0
MANAGER_ROOT_PASSWORD	manager.root.password	1
PASSWORD	password	1
ROOT_PASSWORD	transfer.root.password	1
SECONDARY_GROUP_NAME	secondary.group.name	0
SOURCE_FILE	source.file	0
TRANSFER_IP	transfer.ip.address	0
TRANSFER_PASSWORD	file.transfer.password	1
UID	uid	0
USER_NAME	user.name	0
\.


--
-- Data for Name: cc_crun_param_select_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_select_mst (param_id, order_no, name_id, param_value) FROM stdin;
DIRECTORY_PERMISSION	0	rwx------	700
DIRECTORY_PERMISSION	1	rwxrwx---	770
DIRECTORY_PERMISSION	2	rwxr-x---	750
DIRECTORY_PERMISSION	3	rwxr-xr-x	755
DIRECTORY_PERMISSION	4	r-x------	500
DIRECTORY_PERMISSION	5	r-xr-x---	550
DIRECTORY_PERMISSION	6	r-xr-xr-x	555
FILE_PERMISSION	0	rwx------	700
FILE_PERMISSION	1	rwxrwx---	770
FILE_PERMISSION	2	rwxr-x---	750
FILE_PERMISSION	3	rwxr-xr-x	755
FILE_PERMISSION	4	rw-------	600
FILE_PERMISSION	5	rw-rw----	660
FILE_PERMISSION	6	rw-r-----	640
FILE_PERMISSION	7	rw-r--r--	644
FILE_PERMISSION	8	r--------	400
FILE_PERMISSION	9	r--r-----	440
FILE_PERMISSION	10	r--r--r--	444
JRE_LICENSE	0	YES	yes
JRE_LICENSE	1	NO	no
LOGIN_SHELL	0	/bin/sh	/bin/sh
LOGIN_SHELL	1	/bin/bash	/bin/bash
LOGIN_SHELL	2	/bin/ksh	/bin/ksh
LOGIN_SHELL	3	/bin/tcsh	/bin/tcsh
LOGIN_SHELL	4	/bin/csh	/bin/csh
\.


--
-- Data for Name: cc_crun_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session (session_id, start_date, end_date, type_id, command_id, facility_id, scope_text, node_cnt, wait_cnt, running_cnt, end_nomal_cnt, end_warning_cnt, end_abnomal_cnt, status) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_detail; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_detail (session_id, facility_id, start_date, end_date, facility_name, message, error_message, status, end_status, end_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_param; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_param (session_id, param_id, param_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_type_mst (type_id, name_id, order_no) FROM stdin;
AGENT	agent.management	4
FILE	filesystem.management	0
INSTALL	installation.management	1
START_STOP	start.stop.management	2
USER	user.management	3
\.


--
-- Data for Name: cc_event_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_event_log (monitor_id, monitor_detail_id, plugin_id, generation_date, facility_id, scope_text, application, message_id, message, message_org, priority, confirm_flg, confirm_date, confirm_user, duplication_count, output_date, inhibited_flg) FROM stdin;
\.


--
-- Data for Name: cc_event_multi_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_event_multi_info (monitor_id, monitor_detail_id, plugin_id, facility_id, output_date, multi_id, duplication_count) FROM stdin;
\.


--
-- Data for Name: cc_job_command_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_command_info (session_id, jobunit_id, job_id, facility_id, process_mode, start_command, stop_command, effective_user, error_end_flg, error_end_value, argument_job_id, argument) FROM stdin;
\.


--
-- Data for Name: cc_job_command_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_command_mst (jobunit_id, job_id, facility_id, process_mode, start_command, stop_command, effective_user, error_end_flg, error_end_value, argument_job_id, argument) FROM stdin;
\.


--
-- Data for Name: cc_job_end_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_info (session_id, jobunit_id, job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_mst (jobunit_id, job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_file_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_file_info (session_id, jobunit_id, job_id, process_mode, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, effective_user) FROM stdin;
\.


--
-- Data for Name: cc_job_file_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_file_mst (jobunit_id, job_id, process_mode, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, effective_user) FROM stdin;
\.


--
-- Data for Name: cc_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_info (session_id, jobunit_id, job_id, job_name, description, job_type, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_mst (jobunit_id, job_id, job_name, description, job_type, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_job_notice_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_info (session_id, jobunit_id, job_id, notice_type, priority, notify_group_id) FROM stdin;
\.


--
-- Data for Name: cc_job_notice_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_mst (jobunit_id, job_id, notice_type, priority, notify_group_id) FROM stdin;
\.


--
-- Data for Name: cc_job_param_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_info (session_id, jobunit_id, job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_mst (jobunit_id, job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_relation_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_relation_info (session_id, jobunit_id, job_id, parent_jobunit_id, parent_job_id) FROM stdin;
\.


--
-- Data for Name: cc_job_relation_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_relation_mst (jobunit_id, job_id, parent_jobunit_id, parent_job_id) FROM stdin;
\.


--
-- Data for Name: cc_job_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session (session_id, jobunit_id, job_id, schedule_date, operation_flg, trigger_type, trigger_info) FROM stdin;
\.


--
-- Data for Name: cc_job_session_job; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_job (session_id, jobunit_id, job_id, scope_text, status, start_date, end_date, end_value, end_status, result, end_staus_check_flg, delay_notify_flg) FROM stdin;
\.


--
-- Data for Name: cc_job_session_node; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_node (session_id, jobunit_id, job_id, facility_id, node_name, status, start_date, end_date, end_value, message, agent_check, check_date, retry_count, result, status_buffer) FROM stdin;
\.


--
-- Data for Name: cc_job_start_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_info (session_id, jobunit_id, job_id, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_info (session_id, jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_mst (jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_mst (jobunit_id, job_id, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_time_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_time_info (session_id, jobunit_id, job_id, start_time) FROM stdin;
\.


--
-- Data for Name: cc_job_start_time_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_time_mst (jobunit_id, job_id, start_time) FROM stdin;
\.


--
-- Data for Name: cc_job_user_relation_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_user_relation_mst (jobunit_id, job_id, user_id) FROM stdin;
\.


--
-- Data for Name: cc_mail_template_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_mail_template_info (mail_template_id, description, subject, body, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_map_association; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_association (map_id, source, target) FROM stdin;
\.


--
-- Data for Name: cc_map_bg_image; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_bg_image (filename, filedata) FROM stdin;
\.


--
-- Data for Name: cc_map_icon_image; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_icon_image (filename, filedata) FROM stdin;
\.


--
-- Data for Name: cc_map_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_info (map_id, background_image) FROM stdin;
\.


--
-- Data for Name: cc_map_position; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_position (map_id, element_id, x, y) FROM stdin;
\.


--
-- Data for Name: cc_monitor_http_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_http_info (monitor_id, request_url, url_replace, proxy_set, proxy_host, proxy_port, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_info (monitor_id, monitor_type_id, monitor_type, description, facility_id, run_interval, calendar_id, failure_priority, notify_group_id, application, monitor_flg, collector_flg, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_monitor_numeric_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_numeric_value_info (monitor_id, priority, threshold_upper_limit, threshold_lower_limit, message_id, message) FROM stdin;
\.


--
-- Data for Name: cc_monitor_perf_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_perf_info (monitor_id, item_code, device_display_name, breakdown_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_ping_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_ping_info (monitor_id, run_count, run_interval, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_port_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_port_info (monitor_id, port_number, run_count, run_interval, timeout, service_id) FROM stdin;
\.


--
-- Data for Name: cc_monitor_process_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_info (monitor_id, command, param) FROM stdin;
\.


--
-- Data for Name: cc_monitor_process_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_method_mst (platform_id, sub_platform_id, collect_method) FROM stdin;
LINUX		SNMP
NW_EQUIPMENT		SNMP
OTHER		SNMP
WINDOWS		SNMP
\.


--
-- Data for Name: cc_monitor_process_polling_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_polling_mst (collect_method, platform_id, sub_platform_id, variable_id, entry_key, polling_target) FROM stdin;
SNMP	LINUX		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	LINUX		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	LINUX		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	NW_EQUIPMENT		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	NW_EQUIPMENT		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	NW_EQUIPMENT		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	OTHER		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	OTHER		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	OTHER		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	WINDOWS		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	WINDOWS		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	WINDOWS		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
WBEM	LINUX		param	Linux_UnixProcess.Parameters.*	Linux_UnixProcess.Parameters
\.


--
-- Data for Name: cc_monitor_protocol_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_protocol_mst (service_id, service_name, description, default_port_number, class_name) FROM stdin;
001	TCP	TCP connection establishment(3-way handshake)	\N	com.clustercontrol.port.protocol.ReachAddressTCP
002	FTP	File Transfer Protocol	21	com.clustercontrol.port.protocol.ReachAddressFTP
003	SMTP	Simple Mail Transfer Protocol	25	com.clustercontrol.port.protocol.ReachAddressSMTP
004	SMTPS	Simple Mail Transfer Protocol over SSL	465	com.clustercontrol.port.protocol.ReachAddressSMTPS
005	POP3	Post Office Protocol Version 3	110	com.clustercontrol.port.protocol.ReachAddressPOP3
006	POP3S	Post Office Protocol Version 3 over SSL	995	com.clustercontrol.port.protocol.ReachAddressPOP3S
007	IMAP	Internet Message Access Protocol	143	com.clustercontrol.port.protocol.ReachAddressIMAP
008	IMAPS	Internet Message Access Protocol over SSL	993	com.clustercontrol.port.protocol.ReachAddressIMAPS
009	NTP	Network Time Protocol	123	com.clustercontrol.port.protocol.ReachAddressNTP
010	DNS	Domain Name System	53	com.clustercontrol.port.protocol.ReachAddressDNS
\.


--
-- Data for Name: cc_monitor_snmp_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_info (monitor_id, snmp_oid, convert_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_snmp_value; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_value (monitor_id, facility_id, value, get_date) FROM stdin;
\.


--
-- Data for Name: cc_monitor_sql_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_sql_info (monitor_id, connection_url, connection_user, connection_password, query, jdbc_driver) FROM stdin;
\.


--
-- Data for Name: cc_monitor_status; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_status (facility_id, plugin_id, monitor_id, priority, last_update, counter) FROM stdin;
\.


--
-- Data for Name: cc_monitor_string_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_string_value_info (monitor_id, order_no, description, process_type, pattern, priority, message, case_sensitivity_flg, valid_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_truth_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_truth_value_info (monitor_id, priority, truth_value, message_id, message) FROM stdin;
\.


--
-- Data for Name: cc_notify_command_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_command_info (notify_id, priority, valid_flg, command, effective_user, set_environment, command_timeout) FROM stdin;
COMMAND_FOR_POLLING	0	1	logger ERROR	hinemos	1	15000
COMMAND_FOR_POLLING	1	1	logger UNKNOWN	hinemos	1	15000
COMMAND_FOR_POLLING	2	1	logger WARN	hinemos	1	15000
COMMAND_FOR_POLLING	3	1	logger INFO	hinemos	1	15000
COMMAND_FOR_TRAP	0	1	logger ERROR	hinemos	1	15000
COMMAND_FOR_TRAP	1	1	logger UNKNOWN	hinemos	1	15000
COMMAND_FOR_TRAP	2	1	logger WARN	hinemos	1	15000
COMMAND_FOR_TRAP	3	1	logger INFO	hinemos	1	15000
\.


--
-- Data for Name: cc_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state) FROM stdin;
EVENT_FOR_POLLING	0	1	0
EVENT_FOR_POLLING	1	1	0
EVENT_FOR_POLLING	2	1	0
EVENT_FOR_POLLING	3	1	0
EVENT_FOR_TRAP	0	1	0
EVENT_FOR_TRAP	1	1	0
EVENT_FOR_TRAP	2	1	0
EVENT_FOR_TRAP	3	1	0
\.


--
-- Data for Name: cc_notify_history; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_history (facility_id, plugin_id, monitor_id, notify_id, last_notify) FROM stdin;
\.


--
-- Data for Name: cc_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_info (notify_id, description, notify_type, initial_count, renotify_type, renotify_period, reg_date, update_date, reg_user, update_user, valid_flg) FROM stdin;
COMMAND_FOR_POLLING	ポーリング系監視用	5	2	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0
COMMAND_FOR_TRAP	ログ監視、SNMPTRAP監視用	5	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0
EVENT_FOR_POLLING	ポーリング系監視用	1	2	2	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1
EVENT_FOR_TRAP	ログ監視、SNMPTRAP監視用	1	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1
MAIL_FOR_POLLING	ポーリング系監視用	2	2	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0
MAIL_FOR_TRAP	ログ監視、SNMPTRAP監視用	2	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0
STATUS_FOR_POLLING	ポーリング系監視用	0	2	0	\N	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1
STATUS_FOR_TRAP	ログ監視、SNMPTRAP監視用	0	1	0	\N	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1
\.


--
-- Data for Name: cc_notify_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_job_info (notify_id, priority, job_run, jobunit_id, job_id, job_failure_priority, job_exec_facility_flg, job_exec_facility) FROM stdin;
\.


--
-- Data for Name: cc_notify_log_escalate_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_log_escalate_info (notify_id, priority, escalate_flg, escalate_message, syslog_priority, syslog_facility, escalate_facility_flg, escalate_facility, escalate_port) FROM stdin;
\.


--
-- Data for Name: cc_notify_mail_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_mail_info (notify_id, priority, mail_template_id, mail_flg, mail_address) FROM stdin;
MAIL_FOR_POLLING	0	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	1	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	2	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	3	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	0	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	1	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	2	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	3	\N	1	hinemos@hinemos.info
\.


--
-- Data for Name: cc_notify_relation_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_relation_info (notify_group_id, notify_id, notify_type, notify_flg) FROM stdin;
MON_SYSLOG_RESISTERED_ALL-0	EVENT_FOR_TRAP	1	0
MON_SYSLOG_RESISTERED_ALL-0	STATUS_FOR_TRAP	0	0
MON_SYSLOG_UNRESISTERED_ALL-0	EVENT_FOR_TRAP	1	0
MON_SYSLOG_UNRESISTERED_ALL-0	STATUS_FOR_TRAP	0	0
\.


--
-- Data for Name: cc_notify_status_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_status_info (notify_id, priority, status_flg, status_valid_period, status_invalid_flg, status_update_priority) FROM stdin;
STATUS_FOR_POLLING	3	0	30	11	1
STATUS_FOR_POLLING	2	1	30	11	1
STATUS_FOR_POLLING	0	1	30	11	1
STATUS_FOR_POLLING	1	1	30	11	1
STATUS_FOR_TRAP	3	0	30	11	1
STATUS_FOR_TRAP	2	1	30	11	1
STATUS_FOR_TRAP	0	1	30	11	1
STATUS_FOR_TRAP	1	1	30	11	1
\.


--
-- Data for Name: cc_priority_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_priority_info (judgment_id, description, pattern_01, pattern_02, pattern_03, pattern_04, pattern_05, pattern_06, pattern_07, pattern_08, pattern_09, pattern_10, pattern_11, pattern_12, pattern_13, pattern_14, pattern_15, reg_date, update_date, reg_user, update_user) FROM stdin;
DEFAULT	\N	3	1	2	1	2	1	0	0	0	0	0	0	0	0	1	\N	2006-06-07 14:58:31.156	\N	hinemos
\.


--
-- Data for Name: cc_snmp_trap_mib_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mib_mst (mib, order_no, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_snmp_trap_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mst (mib, trap_oid, generic_id, specific_id, uei, logmsg, descr, priority) FROM stdin;
\.


--
-- Data for Name: cc_snmp_value_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_value_type_mst (value_type) FROM stdin;
Counter32
Counter64
DateTime
Gauge32
Integer32
String
TimeTicks
Uint16
Uint64
Uint8
\.


--
-- Data for Name: cc_status_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_status_info (facility_id, monitor_id, monitor_detail_id, plugin_id, application, message_id, message, priority, generation_date, output_date, expiration_flg, expiration_date) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state, event_inhibition_flg, event_inhibition_state, mail_flg, mail_address) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_info (notify_id, description, status_flg, status_valid_period, status_invalid_flg, status_update_priority, event_flg, inhibition_flg, inhibition_frequency, inhibition_period, reg_date, update_date, mail_template_id) FROM stdin;
\.


--
-- Data for Name: cc_vm_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_vm_method_mst (vm_solution_id, proc_type, class_name) FROM stdin;
\.


--
-- Data for Name: cc_vm_operation_detail; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_vm_operation_detail (session_id, facility_id, management_id, scope_text, node_type, command_id, status, start_date, end_status, end_date, end_value, message) FROM stdin;
\.


--
-- Data for Name: cc_vm_protocol_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_vm_protocol_mst (vm_solution_id, protocol, order_no) FROM stdin;
\.


--
-- Data for Name: cc_vm_solution_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_vm_solution_mst (vm_solution_id, order_no, platform_id, vm_solution_name) FROM stdin;
\.


--
-- Data for Name: hilosequences; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY hilosequences (sequencename, highvalues) FROM stdin;
general	0
\.


--
-- Data for Name: jbm_counter; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_counter (name, next_id) FROM stdin;
CHANNEL_ID	30
MESSAGE_ID	4096
\.


--
-- Data for Name: jbm_dual; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_dual (dummy) FROM stdin;
1
\.


--
-- Data for Name: jbm_id_cache; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_id_cache (node_id, cntr, jbm_id) FROM stdin;
240	0	ID:JBM-9ce5e20d-7933-4482-bf49-8459f118304c
\.


--
-- Data for Name: jbm_msg; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_msg (message_id, reliable, expiration, "timestamp", priority, type, headers, payload) FROM stdin;
\.


--
-- Data for Name: jbm_msg_ref; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_msg_ref (message_id, channel_id, transaction_id, state, ord, page_ord, delivery_count, sched_delivery) FROM stdin;
\.


--
-- Data for Name: jbm_postoffice; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_postoffice (postoffice_name, node_id, queue_name, cond, selector, channel_id, clustered, all_nodes) FROM stdin;
JMS post office	240	DLQ	queue.DLQ	\N	0	N	N
JMS post office	240	ExpiryQueue	queue.ExpiryQueue	\N	1	N	N
JMS post office	240	PrivateDLQ	queue.PrivateDLQ	\N	2	N	N
JMS post office	240	PrivateExpiryQueue	queue.PrivateExpiryQueue	\N	3	N	N
JMS post office	240	QueueWithOwnDLQAndExpiryQueue	queue.QueueWithOwnDLQAndExpiryQueue	\N	4	N	N
JMS post office	240	QueueWithOwnRedeliveryDelay	queue.QueueWithOwnRedeliveryDelay	\N	5	N	N
JMS post office	240	clustercontrolCollectiveRunExecute	queue.clustercontrolCollectiveRunExecute	\N	7	N	N
JMS post office	240	clustercontrolCollectiveRunStatus	queue.clustercontrolCollectiveRunStatus	\N	8	N	N
JMS post office	240	clustercontrolJobManagementStatus	queue.clustercontrolJobManagementStatus	\N	6	N	N
JMS post office	240	clustercontrolNotifyControl	queue.clustercontrolNotifyControl	\N	11	N	N
JMS post office	240	clustercontrolNotifyEvent	queue.clustercontrolNotifyEvent	\N	13	N	N
JMS post office	240	clustercontrolNotifyJob	queue.clustercontrolNotifyJob	\N	15	N	N
JMS post office	240	clustercontrolNotifyLogEscalation	queue.clustercontrolNotifyLogEscalation	\N	16	N	N
JMS post office	240	clustercontrolNotifyMail	queue.clustercontrolNotifyMail	\N	14	N	N
JMS post office	240	clustercontrolNotifyStatus	queue.clustercontrolNotifyStatus	\N	12	N	N
JMS post office	240	clustercontrolSnmpTrapSnmpTrapNotify	queue.clustercontrolSnmpTrapSnmpTrapNotify	\N	9	N	N
JMS post office	240	clustercontrolSyslogngDup	queue.clustercontrolSyslogngDup	\N	17	N	N
JMS post office	240	clustercontrolVmControlExecute	queue.clustercontrolVmControlExecute	\N	18	N	N
JMS post office	240	clustercontrolVmControlStatus	queue.clustercontrolVmControlStatus	\N	19	N	N
\.


--
-- Data for Name: jbm_role; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_role (role_id, user_id) FROM stdin;
durpublisher	dynsub
publisher	dynsub
guest	guest
j2ee	guest
john	guest
durpublisher	john
publisher	john
subscriber	john
noacc	nobody
\.


--
-- Data for Name: jbm_tx; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_tx (node_id, transaction_id, branch_qual, format_id, global_txid) FROM stdin;
\.


--
-- Data for Name: jbm_user; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jbm_user (user_id, passwd, clientid) FROM stdin;
dynsub	dynsub	\N
guest	guest	\N
j2ee	j2ee	\N
john	needle	DurableSubscriberExample
nobody	nobody	\N
\.


--
-- Data for Name: jms_message_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_message_log (messageid, destination, txid, txop, lateclone, messageblob) FROM stdin;
\.


--
-- Data for Name: jms_reference_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_reference_log (messageid, destination, txid, txop, redelivered, redelivers) FROM stdin;
\.


--
-- Data for Name: jms_transaction_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY jms_transaction_log (txid) FROM stdin;
\.


--
-- Data for Name: cc_maintenance_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_maintenance_info (maintenance_id, description, type_id, data_retention_period, calendar_id, month, day, week, hour, minute, notify_group_id, application, valid_flg, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_maintenance_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_maintenance_type_mst (type_id, name_id, order_no) FROM stdin;
DELETE_CRUN_HISTORY	maintenance.delete_crun_history	21
DELETE_CRUN_HISTORY_ALL	maintenance.delete_crun_history_all	20
DELETE_EVENT_LOG	maintenance.delete_event_log	1
DELETE_EVENT_LOG_ALL	maintenance.delete_event_log_all	0
DELETE_JOB_HISTORY	maintenance.delete_job_history	11
DELETE_JOB_HISTORY_ALL	maintenance.delete_job_history_all	10
DELETE_RERF_DATA	maintenance.delete_perf_data	31
DELETE_RERF_DATA_ALL	maintenance.delete_perf_data_all	30
\.


--
-- Data for Name: qrtz_blob_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_blob_triggers (trigger_name, trigger_group, blob_data) FROM stdin;
\.


--
-- Data for Name: qrtz_calendars; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_calendars (calendar_name, calendar) FROM stdin;
\.


--
-- Data for Name: qrtz_cron_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_cron_triggers (trigger_name, trigger_group, cron_expression, time_zone_id) FROM stdin;
\.


--
-- Data for Name: qrtz_fired_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_fired_triggers (entry_id, trigger_name, trigger_group, is_volatile, instance_name, fired_time, state, job_name, job_group, is_stateful, requests_recovery) FROM stdin;
\.


--
-- Data for Name: qrtz_job_details; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_job_details (job_name, job_group, description, job_class_name, is_durable, is_volatile, is_stateful, requests_recovery, job_data) FROM stdin;
\.


--
-- Data for Name: qrtz_job_listeners; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_job_listeners (job_name, job_group, job_listener) FROM stdin;
\.


--
-- Data for Name: qrtz_locks; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_locks (lock_name) FROM stdin;
CALENDAR_ACCESS
JOB_ACCESS
MISFIRE_ACCESS
STATE_ACCESS
TRIGGER_ACCESS
\.


--
-- Data for Name: qrtz_paused_trigger_grps; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_paused_trigger_grps (trigger_group) FROM stdin;
\.


--
-- Data for Name: qrtz_scheduler_state; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_scheduler_state (instance_name, last_checkin_time, checkin_interval, recoverer) FROM stdin;
NON_CLUSTERED	1141382690372	20000	\N
\.


--
-- Data for Name: qrtz_simple_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_simple_triggers (trigger_name, trigger_group, repeat_count, repeat_interval, times_triggered) FROM stdin;
\.


--
-- Data for Name: qrtz_trigger_listeners; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_trigger_listeners (trigger_name, trigger_group, trigger_listener) FROM stdin;
\.


--
-- Data for Name: qrtz_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_triggers (trigger_name, trigger_group, job_name, job_group, is_volatile, description, next_fire_time, prev_fire_time, trigger_state, trigger_type, start_time, end_time, calendar_name, misfire_instr, job_data) FROM stdin;
\.


--
-- Data for Name: timers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY timers (timerid, targetid, initialdate, timerinterval, instancepk, info) FROM stdin;
\.

--
-- Default Settings : Maintenance
--
COPY cc_maintenance_info (maintenance_id, description, type_id, data_retention_period, calendar_id, schedule_type, month, day, week, hour, minute, notify_group_id, application, valid_flg, reg_date, update_date, reg_user, update_user) FROM stdin;
MT-PRF-DEFAULT	性能実績収集データ削除	DELETE_RERF_DATA	31	\N	1	\N	\N	\N	5	20	SYS_MTN-MT-PRF-DEFAULT-0	MT-PRF-DEFAULT	1	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos
MT-JOB-DEFAULT	ジョブ履歴削除	DELETE_JOB_HISTORY_ALL	31	\N	1	\N	\N	\N	5	30	SYS_MTN-MT-JOB-DEFAULT-0	MT-JOB-DEFAULT	1	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos
MT-EVE-DEFAULT	イベント履歴削除	DELETE_EVENT_LOG_ALL	31	\N	1	\N	\N	\N	5	40	SYS_MTN-MT-EVE-DEFAULT-0	MT-EVE-DEFAULT	1	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos
MT-CRN-DEFAULT	一括制御履歴削除	DELETE_CRUN_HISTORY_ALL	31	\N	1	\N	\N	\N	5	50	SYS_MTN-MT-CRN-DEFAULT-0	MT-CRN-DEFAULT	1	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos
\.

COPY qrtz_cron_triggers (trigger_name, trigger_group, cron_expression, time_zone_id) FROM stdin;
MT-PRF-DEFAULT	MAINTENANCE	0 20 5 * * ? *	Asia/Tokyo
MT-JOB-DEFAULT	MAINTENANCE	0 30 5 * * ? *	Asia/Tokyo
MT-EVE-DEFAULT	MAINTENANCE	0 40 5 * * ? *	Asia/Tokyo
MT-CRN-DEFAULT	MAINTENANCE	0 50 5 * * ? *	Asia/Tokyo
\.

COPY qrtz_job_details (job_name, job_group, description, job_class_name, is_durable, is_volatile, is_stateful, requests_recovery, job_data) FROM stdin;
MT-PRF-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.EJBLocalInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c770800000010000000047400086172675479706573757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000a74000461726773757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d5052462d44454641554c54707400116c6f63616c486f6d65496e7374616e6365737d000000010049636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e656a622e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c486f6d65787200176a6176612e6c616e672e7265666c6563742e50726f7879e127da20cc1043cb0200014c0001687400254c6a6176612f6c616e672f7265666c6563742f496e766f636174696f6e48616e646c65723b78707372002a6f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c486f6d6550726f78791875043f7dbe1a39020000787200266f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c50726f7879746746df959171670300014c00086a6e64694e616d657400124c6a6176612f6c616e672f537472696e673b787074001a4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c787400066d6574686f647400167363686564756c6552756e4d61696e74656e616e63657800
MT-JOB-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.EJBLocalInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c770800000010000000047400086172675479706573757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000a74000461726773757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d4a4f422d44454641554c54707400116c6f63616c486f6d65496e7374616e6365737d000000010049636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e656a622e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c486f6d65787200176a6176612e6c616e672e7265666c6563742e50726f7879e127da20cc1043cb0200014c0001687400254c6a6176612f6c616e672f7265666c6563742f496e766f636174696f6e48616e646c65723b78707372002a6f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c486f6d6550726f78791875043f7dbe1a39020000787200266f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c50726f7879746746df959171670300014c00086a6e64694e616d657400124c6a6176612f6c616e672f537472696e673b787074001a4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c787400066d6574686f647400167363686564756c6552756e4d61696e74656e616e63657800
MT-EVE-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.EJBLocalInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c770800000010000000047400086172675479706573757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000a74000461726773757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d4556452d44454641554c54707400116c6f63616c486f6d65496e7374616e6365737d000000010049636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e656a622e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c486f6d65787200176a6176612e6c616e672e7265666c6563742e50726f7879e127da20cc1043cb0200014c0001687400254c6a6176612f6c616e672f7265666c6563742f496e766f636174696f6e48616e646c65723b78707372002a6f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c486f6d6550726f78791875043f7dbe1a39020000787200266f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c50726f7879746746df959171670300014c00086a6e64694e616d657400124c6a6176612f6c616e672f537472696e673b787074001a4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c787400066d6574686f647400167363686564756c6552756e4d61696e74656e616e63657800
MT-CRN-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.EJBLocalInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c770800000010000000047400086172675479706573757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000a74000461726773757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d43524e2d44454641554c54707400116c6f63616c486f6d65496e7374616e6365737d000000010049636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e656a622e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c486f6d65787200176a6176612e6c616e672e7265666c6563742e50726f7879e127da20cc1043cb0200014c0001687400254c6a6176612f6c616e672f7265666c6563742f496e766f636174696f6e48616e646c65723b78707372002a6f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c486f6d6550726f78791875043f7dbe1a39020000787200266f72672e6a626f73732e656a622e706c7567696e732e6c6f63616c2e4c6f63616c50726f7879746746df959171670300014c00086a6e64694e616d657400124c6a6176612f6c616e672f537472696e673b787074001a4d61696e74656e616e6365436f6e74726f6c6c65724c6f63616c787400066d6574686f647400167363686564756c6552756e4d61696e74656e616e63657800
\.

COPY qrtz_triggers (trigger_name, trigger_group, job_name, job_group, is_volatile, description, next_fire_time, prev_fire_time, trigger_state, trigger_type, start_time, end_time, calendar_name, misfire_instr, job_data) FROM stdin;
MT-PRF-DEFAULT	MAINTENANCE	MT-PRF-DEFAULT	MAINTENANCE	f	\N	1330201200000	1330114800000	WAITING	CRON	1330114545000	0	\N	2	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174001272657365744f6e52657374617274466c6167737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c75657870017800
MT-JOB-DEFAULT	MAINTENANCE	MT-JOB-DEFAULT	MAINTENANCE	f	\N	1330115400000	-1	WAITING	CRON	1330114545000	0	\N	2	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174001272657365744f6e52657374617274466c6167737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c75657870017800
MT-EVE-DEFAULT	MAINTENANCE	MT-EVE-DEFAULT	MAINTENANCE	f	\N	1330116000000	-1	WAITING	CRON	1330114545000	0	\N	2	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174001272657365744f6e52657374617274466c6167737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c75657870017800
MT-CRN-DEFAULT	MAINTENANCE	MT-CRN-DEFAULT	MAINTENANCE	f	\N	1330116600000	-1	WAITING	CRON	1330114545000	0	\N	2	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb0200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174001272657365744f6e52657374617274466c6167737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c75657870017800
\.

--
-- PostgreSQL database dump complete
--

