#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

cd ${HINEMOS_HOME}/var/log

########################################
#  Local Variable
########################################

# thread dump count
JBOSS_THREAD_DUMP_CNT=3

# process check interval [sec]
#   this variable is valid with -W option
JBOSS_CHECK_INTERVAL=2

# process check timeout [sec]
#   this variable is valid with -W option
JBOSS_CHECK_TIMEOUT=300

########################################
#  Local Message
########################################

# INFO
MSG_I001="waiting for JBoss to stop..."
MSG_I002="JBoss stopped"

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="usage : ${PROG} [-W]"
MSG_E002="PID file (${HINEMOS_JBOSS_PID}) not found. is JBoss running ?"
MSG_E003="failed to shutdown JBoss"
MSG_E004="shutdown timeout. please check status of JBoss."
MSG_E005="incorrect user (${USER})";
MSG_E006="please check variable HINEMOS_JBOSS_USER (${HINEMOS_HOME}/hinemos.cfg).";

########################################
# Function
########################################


########################################
# SHELL
########################################

#
# check argument
#
JBOSS_SHUTDOWN_WAIT="true"
for ARGS in "$@"
do
	case ${ARGS} in
		-W)
			JBOSS_SHUTDOWN_WAIT="false"
			;;
		*)
			Logging "${MSG_E001}"
			exit -1
			;;
	esac
done

#
# check user executed
#
if [ "x"${USER} != "x"${HINEMOS_JBOSS_USER} ]
then
	Logging "${MSG_E005}"
	Logging "${MSG_E006}"
	exit -2
fi

#
# check PID file
#
if [ ! -f ${HINEMOS_JBOSS_PID} ]
then
	Logging "${MSG_E002}"
	exit -5
fi

#
# shutdown JBoss
#
Logging "${MSG_I001}"

# store thread dump
if [ -e ${HINEMOS_HOME}/var/run/jboss.pid ]
then
	for CNT in `seq 1 ${JBOSS_THREAD_DUMP_CNT}`
	do
		kill -3 `cat ${HINEMOS_HOME}/var/run/jboss.pid`
		echo Thread Dump ${CNT}
		sleep 1
	done
	cp ${HINEMOS_HOME}/var/log/jboss_stdout.log ${HINEMOS_HOME}/var/log/jboss_stdout.log.`date +%Y-%m-%d_%H%M`
fi

${JBOSS_HOME}/bin/shutdown_hinemos.sh -S -s ${IP_ADDRESS}
REVAL=$?

if [ $REVAL -ne 0 ] ; then
	Logging "${MSG_E003}"
	exit -6
fi

TIME_COUNT=0
read JBOSS_PID < ${HINEMOS_JBOSS_PID}
while [ 1 ]
do
	if [ "x"${JBOSS_SHUTDOWN_WAIT} = "xfalse" ]
	then
		Logging "${MSG_I002} (with -W option)"
		break
	fi
	
	if [ `ps --no-headers --pid ${JBOSS_PID} e | grep "${JAVA_HOME}/bin/java.*org.jboss.Main" | wc -l` -eq 0 ]
	then
		echo "done"
		Logging "${MSG_I002}"
		break
	fi

	if [ "${TIME_COUNT}" -ge ${JBOSS_CHECK_TIMEOUT} ]
	then
		Logging "${MSG_E004}"
		exit -7
	fi

	echo -n "."
	sleep ${JBOSS_CHECK_INTERVAL}
	TIME_COUNT=$((${TIME_COUNT} + ${JBOSS_CHECK_INTERVAL}))
done

# remove PID file
rm -f ${HINEMOS_JBOSS_PID}

exit 0
