/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.sql.factory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.repository.util.RepositoryUtil;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;
import com.clustercontrol.sql.util.AccessDB;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.StringBinder;

/**
 * SQL監視 数値監視設定を実行するファクトリークラス<BR>
 *
 * @version 4.0.0
 * @since 2.0.0
 */
public class RunMonitorSql extends RunMonitorNumericValueType {

	private static Log m_log = LogFactory.getLog( RunMonitorSql.class );

	private static final String MESSAGE_ID_UNKNOWN = "100";

	/** SQL監視情報 */
	private MonitorSqlInfoLocal m_sql = null;

	/** 接続文字列 */
	private String m_url = null;

	/** ユーザ */
	private String m_user = null;

	/** パスワード */
	private String m_password = null;

	/** クエリ */
	private String m_query = null;

	/** JDBCドライバ */
	private String m_jdbcDriver = null;

	/** 不明メッセージ */
	private String m_unKnownMessage = null;

	/** メッセージ **/
	private String m_message = null;

	/** オリジナルメッセージ */
	private String m_messageOrg = null;

	/**
	 * コンストラクタ
	 * 
	 */
	public RunMonitorSql() throws NamingException, CreateException{
		super();
	}

	/**
	 * マルチスレッドを実現するCallableTaskに渡すためのインスタンスを作成するメソッド
	 * 
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#runMonitorInfo()
	 * @see com.clustercontrol.monitor.run.util.CallableTask
	 */
	@Override
	protected RunMonitor createMonitorInstance() throws NamingException, CreateException{
		return new RunMonitorSql();
	}

	/**
	 * SQL数を取得
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	@Override
	public boolean collect(String facilityId) {
		// set Generation Date
		if (m_now != null) {
			m_nodeDate = m_now.getTime();
		}

		boolean result = false;

		AccessDB access = null;
		ResultSet rSet = null;

		String url = m_url;

		try {
			// 変数を置換したURLの生成
			if (nodeInfo != null && nodeInfo.containsKey(facilityId)) {
				Map<String, String> nodeParameter = RepositoryUtil.createNodeParameter(nodeInfo.get(facilityId));
				StringBinder strbinder = new StringBinder(nodeParameter);
				url = strbinder.bindParam(m_url);
				if (m_log.isTraceEnabled()) m_log.trace("jdbc request. (nodeInfo = " + nodeInfo + ", facilityId = " + facilityId + ", url = " + url + ")");
			}

			// DB接続初期処理
			access = new AccessDB(
					m_jdbcDriver,
					url,
					m_user,
					m_password);

			// SQL文を実行し、結果を取り出す。
			if(m_query.length() >= 6){
				String work = m_query.substring(0, 6);
				if( work.equalsIgnoreCase("SELECT")){
					rSet = access.read(m_query);

					//1レコード目の1カラム目のデータを取得
					rSet.first();
					double count = rSet.getDouble(1);
					m_value = count;

					//レコード件数を取得
					rSet.last();
					int number = rSet.getRow();

					NumberFormat numberFormat = NumberFormat.getNumberInstance();
					m_message = Messages.getString("select.value") + " : " + m_value;
					m_messageOrg = Messages.getString("record.value") + " : " + numberFormat.format(m_value) + ", " +
					Messages.getString("records.number") + " : " + numberFormat.format(number);
					m_messageOrg += "\n" + Messages.getString("connection.url") + " : " + url;

					result = true;
				}
				else{
					//SELECT文以外はエラー
					m_log.debug("collect(): " + Messages.getString("message.sql.5"));
					m_unKnownMessage = Messages.getString("message.sql.5");
					m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
					m_messageOrg += "\n" + Messages.getString("connection.url") + " : " + url;
				}
			}
			else{
				//SELECT文以外はエラー
				m_log.debug("collect(): " + Messages.getString("message.sql.5"));
				m_unKnownMessage = Messages.getString("message.sql.5");
				m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
				m_messageOrg += "\n" + Messages.getString("connection.url") + " : " + url;
			}
		} catch (ClassNotFoundException e) {
			m_unKnownMessage = Messages.getString("message.sql.6");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
			m_messageOrg += "\n" + Messages.getString("connection.url") + " : " + url;
		} catch (SQLException e) {
			// SQL実行エラー
			m_unKnownMessage = Messages.getString("message.sql.7");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
			m_messageOrg += "\n" + Messages.getString("connection.url") + " : " + url;
		} finally {
			try {
				if(rSet != null){
					rSet.close();
				}
				if(access != null){
					// DB接続終了処理
					access.terminate();
				}
			} catch (SQLException e) {
				m_log.error("collect(): ", e);
			}
		}
		return result;
	}

	/* (non-Javadoc)
	 * SQL監視情報を設定
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	protected void setCheckInfo() throws FinderException, NamingException{

		// SQL監視情報を取得
		m_sql = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// SQL監視情報を設定
		m_url = m_sql.getConnection_url().trim();
		m_user = m_sql.getConnection_user().trim();
		m_password = m_sql.getConnection_password().trim();
		m_query = m_sql.getQuery().trim();
		m_jdbcDriver = m_sql.getJdbc_driver().trim();
	}

	/* (非 Javadoc)
	 * ノード用メッセージIDを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		String messageId = super.getMessageId(id);
		if(messageId == null || "".equals(messageId)){
			return MESSAGE_ID_UNKNOWN;
		}
		return messageId;
	}

	/* (非 Javadoc)
	 * ノード用メッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {

		if(m_message == null || "".equals(m_message)){
			return m_unKnownMessage;
		}
		return m_message;
	}

	/* (非 Javadoc)
	 * ノード用オリジナルメッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
}
