/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.sql.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.sql.util.ControlSqlInfo;

/**
 * SQL監視 数値監視設定を削除するファクトリークラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class DeleteMonitorSql extends DeleteMonitor{

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {

		// SQL監視情報を削除
		ControlSqlInfo sql = new ControlSqlInfo(m_monitorId, m_monitorTypeId);
		return sql.delete();
	}
}
