/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * MIBマスター情報を削除するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class DeleteMibMaster {

	protected static Log m_log = LogFactory.getLog( DeleteMibMaster.class );


	protected String m_Mib;

	/**
	 * MIB情報を削除します。
	 * 
	 * @param MibData　削除するMIBマスター
	 * @param user　　　削除実行ユーザ
	 * @return
	 * @throws CreateException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 * @throws MonitorNotFound
	 */
	public boolean delete(String  mib) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, MonitorNotFound {

		m_Mib = mib;

		boolean result = false;
		// 監視情報を登録
		result = deleteMibMaster();

		return result;
	}

	/**
	 * MIBマスターの削除を行う。
	 * @param user　削除実行ユーザ
	 * @return
	 * @throws NamingException
	 * @throws MonitorNotFound
	 * @throws FinderException
	 */
	public boolean deleteMibMaster() throws NamingException, MonitorNotFound {
		boolean result = false;

		try
		{
			// 監視情報を検索

			SnmpTrapMibMasterLocal mibMaster =  SnmpTrapMibMasterUtil.getLocalHome()
			.findByPrimaryKey(new SnmpTrapMibMasterPK(m_Mib));

			mibMaster.remove();

			result = true;

		} catch (NamingException e) {
			outputLog(e, "deleteMibMaster()");
			throw e;
		} catch (EJBException e) {
			outputLog(e, "deleteMibMaster()");
			throw e;
		} catch (RemoveException e) {
			outputLog(e, "deleteMibMaster()");
			try {
				throw e;
			} catch (RemoveException e1) {
				outputLog(e1, "deleteMibMaster()");
			}
		} catch (FinderException e) {
			outputLog(e, "deleteMibMaster()");
			throw new MonitorNotFound(e.getMessage(), e);
		}
		return result;
	}

	/**
	 * アプリケーションログにログを出力
	 * 
	 * @param e 例外
	 */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_Mib};
		apllog.put("SYS", "001", args);
		m_log.debug(method + ":" + e.getMessage());
	}
}
