package com.clustercontrol.snmptrap.ejb.entity;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorTrapInfo"
 *           jndi-name="MonitorTrapInfo"
 *           type="CMP"
 *           schema="MonitorTrapInfo"
 *           cmp-version="2.x"
 *           data-source="java:/DefaultDS"
 *           view-type="local"
 *           primkey-field="monitorId"
 * 
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 *  @jboss.container-configuration
 *     name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_trap_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 *  @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence
 *   table-name="cc_monitor_trap_info"
 * 
 *  @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorTrapInfo as a"
 *    signature="java.util.Collection findAll()"
 *
 * @ejb.pk
 *    class="java.lang.String"
 * 
 */
public abstract class MonitorTrapInfoBean implements EntityBean {

	/**
	 * Default Constructor
	 */
	public MonitorTrapInfoBean() {
		super();
	}

	/**
	 *
	 * SNMPTRAP監視条件を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param monitorId 監視項目ID
	 * @param communityName 監視コミュニティ名
	 * @param checkMode チェックモード
	 * @param communityCheck コミュニティチェック有無
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 */
	public java.lang.String ejbCreate(
			String monitorId,
			String communityName,
			Integer checkMode,
			Integer communityCheck,
			Integer charsetConvert,
			String charsetName
	) throws javax.ejb.CreateException {

		this.setMonitorId(monitorId);
		this.setCommunityName(communityName);
		this.setCheckMode(checkMode);
		this.setCommunityCheck(communityCheck);
		this.setCharsetConvert(charsetConvert);
		this.setCharsetName(charsetName);
		return null;
	}


	/**
	 * 
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);


	/**
	 * 
	 * 監視コミュニティ名を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="community_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視コミュニティ名
	 */
	public abstract String getCommunityName();

	/**
	 * 
	 * 監視コミュニティ名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param communityName 監視コミュニティ名
	 */
	public abstract void setCommunityName(String communityName);


	/**
	 * 
	 * チェックモードを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="check_mode"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return チェックモード
	 */
	public abstract Integer getCheckMode();

	/**
	 * 
	 * チェックモードを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param checkMode チェックモード
	 */
	public abstract void setCheckMode(Integer checkMode);


	/**
	 * 
	 * コミュニティチェック有無を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="community_check"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return コミュニティチェック有無
	 */
	public abstract Integer getCommunityCheck();

	/**
	 * 
	 * コミュニティチェック有無を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param communityCheck コミュニティチェック有無
	 */
	public abstract void setCommunityCheck(Integer communityCheck);


	/**
	 * 
	 * 文字セット変換有無を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="charset_convert"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return コミュニティチェック有無
	 */
	public abstract Integer getCharsetConvert();

	/**
	 * 
	 * 文字セット変換有無を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param charsetConvert 文字セット変換
	 */
	public abstract void setCharsetConvert(Integer charsetConvert);


	/**
	 * 
	 * 文字セット名を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="charset_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 文字セット名
	 */
	public abstract String getCharsetName();

	/**
	 * 
	 * 文字セット名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param CharsetName 文字セット名
	 */
	public abstract void setCharsetName(String CharsetName);

}
