/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;

/**
 * リポジトリに関するUtilityクラス<br/>
 * 
 * @author takahatat
 *
 */
public class RepositoryUtil {

	static private Log log = LogFactory.getLog(RepositoryUtil.class);

	private static final String _KEY_FACILITY_ID = "FACILITY_ID";
	private static final String _KEY_FACILITY_NAME = "FACILITY_NAME";

	private static final String _KEY_IP_ADDRESS_VERSION = "IP_ADDRESS_VERSION";
	private static final String _KEY_IP_ADDRESS = "IP_ADDRESS";
	private static final String _KEY_IP_ADDRESS_V4 = "IP_ADDRESS_V4";
	private static final String _KEY_IP_ADDRESS_V6 = "IP_ADDRESS_V6";

	private static final String _KEY_NODE_NAME = "NODE_NAME";
	private static final String _KEY_OS_NAME = "OS_NAME";
	private static final String _KEY_OS_RELEASE = "OS_RELEASE";
	private static final String _KEY_OS_VERSION = "OS_VERSION";
	private static final String _KEY_CHARSET = "CHARSET";

	private static final String _KEY_SNMP_PORT = "SNMP_PORT";
	private static final String _KEY_SNMP_COMMUNITY = "SNMP_COMMUNITY";
	private static final String _KEY_SNMP_VERSION = "SNMP_VERSION";
	private static final String _KEY_SNMP_TIMEOUT = "SNMP_TIMEOUT";
	private static final String _KEY_SNMP_TRIES = "SNMP_TRIES";

	private static final String _KEY_WBEM_PORT = "WBEM_PORT";
	private static final String _KEY_WBEM_PROTOCOL = "WBEM_PROTOCOL";
	private static final String _KEY_WBEM_TIMEOUT = "WBEM_TIMEOUT";
	private static final String _KEY_WBEM_TRIES = "WBEM_TRIES";
	private static final String _KEY_WBEM_USER = "WBEM_USER";
	private static final String _KEY_WBEM_PASSWORD = "WBEM_PASSWORD";

	private static final String _KEY_WINRM_USER = "WINRM_USER";
	private static final String _KEY_WINRM_PASSWORD = "WINRM_PASSWORD";
	private static final String _KEY_WINRM_VERSION = "WINRM_VERSION";
	private static final String _KEY_WINRM_PORT = "WINRM_PORT";
	private static final String _KEY_WINRM_PROTOCOL = "WINRM_PROTOCOL";
	private static final String _KEY_WINRM_TIMEOUT = "WINRM_TIMEOUT";
	private static final String _KEY_WINRM_TRIES = "WINRM_TRIES";

	private static final String _KEY_IPMI_IP_ADDRESS = "IPMI_IP_ADDRESS";
	private static final String _KEY_IPMI_PORT = "IPMI_PORT";
	private static final String _KEY_IPMI_TIMEOUT = "IPMI_TIMEOUT";
	private static final String _KEY_IPMI_TRIES = "IPMI_TRIES";
	private static final String _KEY_IPMI_PROTOCOL = "IPMI_PROTOCOL";
	private static final String _KEY_IPMI_LEVEL = "IPMI_LEVEL";
	private static final String _KEY_IPMI_USER = "IPMI_USER";
	private static final String _KEY_IPMI_PASSWORD = "IPMI_PASSWORD";

	private static final String _KEY_VM_NODE_TYPE = "VM_NODE_TYPE";
	private static final String _KEY_VM_NAME = "VM_NAME";
	private static final String _KEY_VM_ID = "VM_ID";
	private static final String _KEY_VM_USER = "VM_USER";
	private static final String _KEY_VM_PASSWORD = "VM_PASSWORD";
	private static final String _KEY_VM_PROTOCOL = "VM_PROTOCOL";

	private static final String _KEY_VSWITCH_TYPE = "VSWITCH_TYPE";
	private static final String _KEY_OPENFLOW_DATA_PATHID = "OF_DATAPATHID";
	private static final String _KEY_OPENFLOW_CTRL_IP_ADDRESS = "OF_CTRL_IP_ADDRESS";

	/**
	 * ノードの基本情報をハッシュとして返す
	 * @param nodeInfo
	 * @return
	 */
	public static Map<String, String> createNodeParameter(NodeInfo nodeInfo) {
		Map<String, String> param = null;

		if (nodeInfo != null) {
			param = new HashMap<String, String>();

			param.put(_KEY_FACILITY_ID, nodeInfo.getFacilityId());
			param.put(_KEY_FACILITY_NAME, nodeInfo.getFacilityName());

			param.put(_KEY_IP_ADDRESS_VERSION, nodeInfo.getIpAddressVersion() == null ? null : nodeInfo.getIpAddressVersion().toString());
			param.put(_KEY_IP_ADDRESS, nodeInfo.getIpAddressVersion() == 4 ? nodeInfo.getIpAddressV4() : nodeInfo.getIpAddressV6());
			param.put(_KEY_IP_ADDRESS_V4, nodeInfo.getIpAddressV4());
			param.put(_KEY_IP_ADDRESS_V6, nodeInfo.getIpAddressV6());

			param.put(_KEY_NODE_NAME, nodeInfo.getNodeName());
			param.put(_KEY_OS_NAME, nodeInfo.getOsName());
			param.put(_KEY_OS_RELEASE, nodeInfo.getOsRelease());
			param.put(_KEY_OS_VERSION, nodeInfo.getOsVersion());
			param.put(_KEY_CHARSET, nodeInfo.getCharacterSet());

			param.put(_KEY_SNMP_PORT, nodeInfo.getSnmpPort() == null ? null : nodeInfo.getSnmpPort().toString());
			param.put(_KEY_SNMP_COMMUNITY, nodeInfo.getSnmpCommunity());
			param.put(_KEY_SNMP_VERSION, nodeInfo.getSnmpVersion());
			param.put(_KEY_SNMP_TIMEOUT, nodeInfo.getSnmpTimeout() == null ? null : nodeInfo.getSnmpTimeout().toString());
			param.put(_KEY_SNMP_TRIES, nodeInfo.getSnmpRetryCount() == null ? null : nodeInfo.getSnmpRetryCount().toString());

			param.put(_KEY_WBEM_PORT, nodeInfo.getWbemPort() == null ? null : nodeInfo.getWbemPort().toString());
			param.put(_KEY_WBEM_PROTOCOL, nodeInfo.getWbemProtocol());
			param.put(_KEY_WBEM_TIMEOUT, nodeInfo.getWbemTimeout() == null ? null : nodeInfo.getWbemTimeout().toString());
			param.put(_KEY_WBEM_TRIES, nodeInfo.getWbemRetryCount() == null ? null : nodeInfo.getWbemRetryCount().toString());
			param.put(_KEY_WBEM_USER, nodeInfo.getWbemUser());
			param.put(_KEY_WBEM_PASSWORD, nodeInfo.getWbemUserPassword());

			param.put(_KEY_WINRM_USER, nodeInfo.getWinrmUser());
			param.put(_KEY_WINRM_PASSWORD, nodeInfo.getWinrmUserPassword());
			param.put(_KEY_WINRM_VERSION, nodeInfo.getWinrmVersion());
			param.put(_KEY_WINRM_PORT, nodeInfo.getWinrmPort() == null ? null : nodeInfo.getWinrmPort().toString());
			param.put(_KEY_WINRM_PROTOCOL, nodeInfo.getWinrmProtocol());
			param.put(_KEY_WINRM_TIMEOUT, nodeInfo.getWinrmTimeout() == null ? null : nodeInfo.getWinrmTimeout().toString());
			param.put(_KEY_WINRM_TRIES, nodeInfo.getWinrmRetries() == null ? null : nodeInfo.getWinrmRetries().toString());

			param.put(_KEY_IPMI_IP_ADDRESS, nodeInfo.getIpmiIpAddress());
			param.put(_KEY_IPMI_PORT, nodeInfo.getIpmiPort() == null ? null : nodeInfo.getIpmiPort().toString());
			param.put(_KEY_IPMI_TIMEOUT, nodeInfo.getIpmiTimeout() == null ? null : nodeInfo.getIpmiTimeout().toString());
			param.put(_KEY_IPMI_TRIES, nodeInfo.getIpmiRetries() == null ? null : nodeInfo.getIpmiRetries().toString());
			param.put(_KEY_IPMI_PROTOCOL, nodeInfo.getIpmiProtocol());
			param.put(_KEY_IPMI_LEVEL, nodeInfo.getIpmiLevel());
			param.put(_KEY_IPMI_USER, nodeInfo.getIpmiUser());
			param.put(_KEY_IPMI_PASSWORD, nodeInfo.getIpmiUserPassword());

			param.put(_KEY_VM_NODE_TYPE, nodeInfo.getVirtualizationNodeType());
			param.put(_KEY_VM_NAME, nodeInfo.getVmName());
			param.put(_KEY_VM_ID, nodeInfo.getVmId());
			param.put(_KEY_VM_USER, nodeInfo.getVmUser());
			param.put(_KEY_VM_PASSWORD, nodeInfo.getVmUserPassword());
			param.put(_KEY_VM_PROTOCOL, nodeInfo.getVmProtocol());

			param.put(_KEY_VSWITCH_TYPE, nodeInfo.getvNetSwitchType());
			param.put(_KEY_OPENFLOW_DATA_PATHID, nodeInfo.getOpenFlowDataPathId());
			param.put(_KEY_OPENFLOW_CTRL_IP_ADDRESS, nodeInfo.getOpenFlowCtrlIpAddress());

			if (nodeInfo.getNodeVariableInfo() != null) {
				for (NodeVariableInfo info : nodeInfo.getNodeVariableInfo()) {
					if (info.getNodeVariableName() == null || "".equals(info.getNodeVariableName())) {
						if (log.isDebugEnabled()) log.debug("key is not valid. (key = " + info.getNodeVariableName() + ")");
						continue;
					}
					if (param.containsKey(info.getNodeVariableName())) {
						log.info("duplicated key (key = " + info.getNodeVariableName() + "). this parameter will be used. (value = " + param.get(info.getNodeVariableName()) + ")");
						continue;
					}
					if (log.isTraceEnabled()) log.trace("adding user parameter. (key = " + info.getNodeVariableName() + ", value = " + info.getNodeVariableValue() + ")");
					param.put(info.getNodeVariableName(), info.getNodeVariableValue());
				}
			}
		}

		return param;
	}

}
