/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.poller;

/**
 * 指定の収集が既に存在する場合の例外クラス
 * 
 * @version 3.0.0
 * @since 3.0.0
 */
public class CollectorAlreadyExistException extends Exception {
	private static final long serialVersionUID = 883967471670295485L;

	private String m_collectorName;

	public CollectorAlreadyExistException(String collectorName){
		m_collectorName = collectorName;
	}

	@Override
	public String getMessage() {
		return m_collectorName + " is already exist.";
	}
}
