/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.ping.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;

/**
 * ping監視情報を削除するクラス<BR>
 *
 * @version 4.0.0
 * @since 2.0.0
 */
public class DeleteMonitorPing extends DeleteMonitor{

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {

		// ping監視情報を取得
		MonitorPingInfoLocal pingLocal = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// ping監視情報を削除
		pingLocal.remove();

		return true;
	}
}
