/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.operator;

/**
 * 100-(var1+var2+var3)/var0*100 を求めます。
 */
public class InvPercentage31 extends Operator {
@Override
public double calc() throws CollectedDataNotFoundException, InvalidValueException{
double total;
double perfData;

if(getCurrentMibValue("var0") == 0){
// エラー処理　おそらく値がとれていない
return Double.NaN;
}

total = getCurrentMibValue("var1")
+ getCurrentMibValue("var2")
+ getCurrentMibValue("var3");

perfData = 100 - total / getCurrentMibValue("var0") * 100.0D;

return perfData;
}
}
