/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.bean;

import javax.xml.bind.annotation.XmlType;

/**
 * 収集対象であるOIDの情報を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
@XmlType(namespace = "http://collector.ws.clustercontrol.com")
public class OIDInfo {
private String fullOID = null; // 収集対象のOIDを保持
private String baseOid;        // 収集対象の最後の"."以前のOIDを保持
private Integer oidIndex = new Integer(0);;          // 収集対象の最後の"."以下の数値を保持
private Long defaultValue = null;  // 値取得失敗時の適用値
private boolean allIndex = false;       // true の場合は、baseOid 以下の全てのインデックスが対象（その場合はoidIndexは意味を持たない）

/**
 * コンストラクタ
 */
public OIDInfo(){
setFullOID();
}

/**
 * 保持しているOIDの情報を文字列として返します。
 * 収集対象が全てのインデックスのもの（isAllIndexメソッドの結果がtrueのもの）は、
 * 最後のインデックを"*"で表した形で返します。
 */
public String getOID(){
	return fullOID;
}

private void setFullOID(){
	if(!allIndex){
		fullOID = baseOid + "." + oidIndex;
	} else {
		fullOID = baseOid + ".*";
	}
}

/**
 * @return 収集対象OIDの最後の"."の後ろに続く全てのインデックスを収集対象とするか否か を戻します。
 */
public boolean isAllIndex() {
	return allIndex;
}
/**
 * @param allIndex 収集対象OIDの最後の"."の後ろに続く全てのインデックスを収集対象とするか否かのフラグ を設定。
 */
public void setAllIndex(boolean allIndex) {
	this.allIndex = allIndex;
	setFullOID();
}
/**
 * @return 収集対象のOID最後の"."の前までを文字列で戻します。
 */
public String getBaseOid() {
	return baseOid;
}
/**
 * @param oidBase 収集対象OIDの最後の"."の前までを設定。
 */
public void setBaseOid(String oidBase) {
	this.baseOid = oidBase;
	setFullOID();
}
/**
 * @return 収集対象OIDの最後の"."の後ろに続く数値 を戻します。
 */
public Integer getOidIndex() {
	return oidIndex;
}
/**
 * @param oidTableIndex 収集対象OIDの最後の"."の後ろに続く数値 を設定。
 */
public void setOidIndex(Integer oidTableIndex) {
	this.oidIndex = oidTableIndex;
	setFullOID();
}

/**
 * @return 値取得失敗時の適用値 を戻します。
 */
public Long getDefaultValue() {
	return defaultValue;
}
/**
 * @param defaultValue 値取得失敗時の適用値 を設定。
 */
public void setDefaultValue(Long defaultValue) {
	this.defaultValue = defaultValue;
}
}
