/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * 文字列監視の判定情報を変更する抽象クラス<BR>
 * <p>
 * 文字列監視を行う各監視管理クラスで継承してください。
 *
 * @version 4.0.0
 * @since 2.1.0
 */
abstract public class ModifyMonitorStringValueType extends ModifyMonitor{

	/**
	 * 監視情報より文字列監視の判定情報を取得し、変更します。
	 * <p>
	 * <ol>
	 * <li>監視情報より判定情報を削除します。</li>
	 * <li>判定情報を作成し、監視情報に設定します。</li>
	 * </ol>
	 * @throws HinemosUnknown
	 * @throws NotifyNotFound
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	protected boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException, NotifyNotFound, HinemosUnknown {
		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();

		// 文字列監視判定情報を削除
		Collection ct = m_monitor.getMonitorStringValueInfo();
		if(ct != null && ct.size() > 0){
			Object[] infoArray = ct.toArray();
			for(int j = 0; j < infoArray.length; j++){
				MonitorStringValueInfoLocal info = (MonitorStringValueInfoLocal)infoArray[j];
				if(info != null){
					//文字列監視情報を削除
					info.remove();
				}
			}
		}

		// 文字列監視判定情報を設定
		ArrayList valueList = m_monitorInfo.getStringValueInfo();
		if(valueList == null){
			return true;
		}
		ArrayList<MonitorStringValueInfoLocal> valueLocalList = new ArrayList<MonitorStringValueInfoLocal>();

		MonitorStringValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorStringValueInfo)valueList.get(index);
			if(value != null){
				MonitorStringValueInfoLocal local = MonitorStringValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getOrderNo()),
						value.getDescription(),
						Integer.valueOf(value.getProcessType()),
						value.getPattern(),
						Integer.valueOf(value.getPriority()),
						value.getMessage(),
						ValidConstant.booleanToType(value.getCaseSensitivityFlg()),
						ValidConstant.booleanToType(value.isValidFlg())
				);
				valueLocalList.add(local);
			}
		}

		return true;
	}

}
