package com.clustercontrol.monitor.run.ejb.entity;

import javax.ejb.EntityBean;

/**
 * SNMPTRAP監視判定情報のCMP Entity Bean<BR>
 * 
 * @ejb.bean name="MonitorTrapValueInfo"
 *    jndi-name="MonitorTrapValueInfo"
 *    schema="MonitorTrapValueInfo"
 *    type="CMP"
 *    view-type="local"
 *    cmp-version="2.x"
 *    data-source="java:/DefaultDS"
 * 
 * @ejb.persistence
 *    table-name="public.cc_monitor_trap_value_info"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorTrapValueInfo as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.pk
 *    class="com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_trap_value_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 */
public abstract class MonitorTrapValueInfoBean implements EntityBean {

	/**
	 * Default Constructor
	 */
	public MonitorTrapValueInfoBean() {
		super();
	}

	/**
	 * SNMPTRAP監視TRAP情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param monitorId 監視項目ID
	 * @param mib MIB
	 * @param trapOid OID
	 * @param genericId Generic ID
	 * @param specificId Specific ID
	 * @param uei SNMPトラップ名
	 * @param validFlg 有効フラグ
	 * @param priority 重要度
	 * @param logmsg メッセージ
	 * @param descr オリジナルメッセージ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 */
	public MonitorTrapValueInfoPK ejbCreate(
			String monitorId,
			String mib,
			String trapOid,
			Integer genericId,
			Integer specificId,
			String uei,
			Integer validFlg,
			Integer priority,
			String logmsg,
			String descr
	) throws javax.ejb.CreateException {

		this.setMonitorId(monitorId);
		this.setMib(mib);
		this.setTrapOid(trapOid);
		this.setGenericId(genericId);
		this.setSpecificId(specificId);
		this.setUei(uei);
		this.setValidFlg(validFlg);
		this.setPriority(priority);
		this.setLogmsg(logmsg);
		this.setDescr(descr);

		return null;
	}

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);


	/**
	 * MIBを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="mib"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return MIB
	 */
	public abstract String getMib();

	/**
	 * MIBを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mib MIB
	 */
	public abstract void setMib(String mib);


	/**
	 * OIDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="trap_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return OID
	 */
	public abstract String getTrapOid();

	/**
	 * OIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param trapOid OID
	 */
	public abstract void setTrapOid(String trapOid);


	/**
	 * Generic IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="generic_id"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Generic ID
	 */
	public abstract Integer getGenericId();

	/**
	 * Generic IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param genericId Generic ID
	 */
	public abstract void setGenericId(Integer genericId);


	/**
	 * Specific IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="specific_id"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Specific ID
	 */
	public abstract Integer getSpecificId();

	/**
	 * Specific IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param specificId Specific ID
	 */
	public abstract void setSpecificId(Integer specificId);

	/**
	 * SNMPトラップ名を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="uei"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return uei
	 */
	public abstract String getUei();

	/**
	 * SNMPトラップ名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param uei
	 */
	public abstract void setUei(String uei);

	/**
	 * 有効フラグを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 有効フラグ
	 */
	public abstract Integer getValidFlg();

	/**
	 * 有効フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param validFlg 有効フラグ
	 */
	public abstract void setValidFlg(Integer validFlg);


	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 */
	public abstract Integer getPriority();

	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param validFlg 重要度
	 */
	public abstract void setPriority(Integer priority);


	/**
	 * メッセージを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="logmsg"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return メッセージ
	 */
	public abstract String getLogmsg();

	/**
	 * メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param logmsg メッセージ
	 */
	public abstract void setLogmsg(String logmsg);


	/**
	 * オリジナルメッセージを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="descr"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return オリジナルメッセージ
	 */
	public abstract String getDescr();

	/**
	 * オリジナルメッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param descr オリジナルメッセージ
	 */
	public abstract void setDescr(String descr);


	//	==========================================
	//	 CMR fields
	//	==========================================

	/**
	 * 監視情報を返します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="MonitorInfo-MonitorTrapValueInfo"
	 *    role-name="MonitorTrapValueInfo-MonitorInfo(multi)"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 *    batch-cascade-delete="true"
	 * 
	 * @return 監視情報
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 */
	public abstract MonitorInfoLocal getMonitorInfo();

	/**
	 * 監視情報を設定します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @param monitorInfo 監視情報
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 */
	public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
}
