/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.run.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 監視情報のCMP Entity Bean
 * 
 * @ejb.bean name="MonitorInfo"
 *    jndi-name="MonitorInfo"
 *    type="CMP"
 *    view-type="local"
 *    primkey-field="monitorId"
 *    schema="MonitorInfo"
 *    cmp-version="2.x"
 *    data-source="java:/DefaultDS"
 * 
 * @ejb.persistence
 *    table-name="public.cc_monitor_info"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAll()"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findByMonitorTypeId(java.lang.String monitorTypeId)"
 * 
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a WHERE a.monitorTypeId = ?1"
 *    signature="java.util.Collection findByMonitorTypeId(java.lang.String monitorTypeId)"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MonitorInfo as a WHERE a.facilityId = ?1"
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"
 * 
 * @ejb.pk
 *    class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 */
public abstract class MonitorInfoBean implements EntityBean {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( MonitorInfoBean.class );


	/**
	 * 監視情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @param monitorType 監視種別
	 * @param description 説明
	 * @param facilityId ファシリティID
	 * @param runInterval 実行間隔
	 * @param delayTime 実行遅延時間（秒）
	 * @param tiggerType スケジュール実行種別
	 * @param calendarId カレンダID
	 * @param failurePriority 値取得の失敗時の重要度
	 * @param application アプリケーション
	 * @param notifyGroupId 通知グループID
	 * @param monitorFlg 監視有効/無効フラグ
	 * @param collectorFlg 収集有効/無効フラグ
	 * @param itemName 収集値表示名
	 * @param measure 収集値単位
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 新規作成ユーザ
	 * @param updateUser 最終変更ユーザ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.String ejbCreate(
			String monitorId,
			String monitorTypeId,
			Integer monitorType,
			String description,
			String facilityId,
			Integer runInterval,
			Integer delayTime,
			String triggerType,
			String calendarId,
			Integer failurePriority,
			String application,
			String notifyGroupId,
			Integer monitorFlg,
			Integer collectorFlg,
			String itemName,
			String measure,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser
	) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setMonitorType(monitorType);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setRunInterval(runInterval);
		this.setDelayTime(delayTime);
		this.setTriggerType(triggerType);
		this.setCalendarId(calendarId);
		this.setFailurePriority(failurePriority);
		this.setApplication(application);
		this.setNotifyGroupId(notifyGroupId);
		this.setMonitorFlg(monitorFlg);
		this.setCollectorFlg(collectorFlg);
		this.setItemName(itemName);
		this.setMeasure(measure);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);

		return null;
	}


	/**
	 * 通知グループIDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public abstract String getNotifyGroupId();

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyGroupId 通知グループID
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);


	/**
	 * アプリケーションを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return アプリケーション
	 */
	public abstract String getApplication();

	/**
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param application アプリケーション
	 */
	public abstract void setApplication(String application);

	/**
	 * カレンダIDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public abstract String getCalendarId();

	/**
	 * カレンダIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendarId カレンダID
	 */
	public abstract void setCalendarId(String calendarId);

	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();

	/**
	 * 説明を設定します（未使用）。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);

	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);


	/**
	 * 値取得の失敗時の重要度を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getFailurePriority();

	/**
	 * 値取得の失敗時の重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failurePriority 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setFailurePriority(Integer failurePriority);

	/**
	 * 監視有効/無効フラグを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視有効/無効フラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getMonitorFlg();

	/**
	 * 監視有効/無効フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorFlg 監視有効/無効フラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setMonitorFlg(Integer monitorFlg);

	/**
	 * 収集有効/無効フラグを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="collector_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 収集有効/無効フラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getCollectorFlg();

	/**
	 * 収集有効/無効フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param collectorFlg 収集有効/無効フラグ
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setCollectorFlg(Integer collectorFlg);

	/**
	 * 収集値表示名を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="item_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 収集値表示名
	 */
	public abstract String getItemName();

	/**
	 * 収集値表示名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param itemName 収集値表示名
	 */
	public abstract void setItemName(String itemName);

	/**
	 * 収集値単位を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="measure"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 収集値単位
	 */
	public abstract String getMeasure();

	/**
	 * 収集値単位を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param measure 収集値単位
	 */
	public abstract void setMeasure(String measure);

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);

	/**
	 * 監視種別を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public abstract Integer getMonitorType();

	/**
	 * 監視種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorType 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public abstract void setMonitorType(Integer monitorType);

	/**
	 * 監視対象IDを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視対象ID
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視対象IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);


	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return regDate 作成日時
	 */
	public abstract Timestamp getRegDate();

	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);

	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();

	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);

	/**
	 * 実行間隔を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 実行間隔
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public abstract Integer getRunInterval();

	/**
	 * 実行間隔を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param runInterval 実行間隔
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public abstract void setRunInterval(Integer runInterval);

	/**
	 * 実行遅延時間（秒）を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="delay_time"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 実行遅延時間（秒）
	 */
	public abstract Integer getDelayTime();

	/**
	 * 実行遅延時間（秒）を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param delayTime 実行遅延時間（秒）
	 */
	public abstract void setDelayTime(Integer delayTime);

	/**
	 * スケジュール実行種別を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="trigger_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return 実行遅延時間（秒）
	 */
	public abstract String getTriggerType();

	/**
	 * スケジュール実行種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param delayTime スケジュール実行種別
	 */
	public abstract void setTriggerType(String triggerType);

	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return updateDate 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);

	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();

	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);

	//	==========================================
	//	 CMR fields
	//	==========================================

	/**
	 * 真偽値監視判定情報を返します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="MonitorInfo-MonitorTruthValueInfo"
	 *    role-name="MonitorInfo-MonitorTruthValueInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 * 
	 * @return 真偽値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 */
	public abstract Collection getMonitorTruthValueInfo();

	/**
	 * 真偽値監視判定情報を設定します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @param collection 真偽値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoBean
	 */
	public abstract void setMonitorTruthValueInfo(Collection collection);

	/**
	 * 数値監視判定情報を返します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="MonitorInfo-MonitorNumericValueInfo"
	 *    role-name="MonitorInfo-MonitorNumericValueInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 * 
	 * @return 数値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	public abstract Collection getMonitorNumericValueInfo();

	/**
	 * 数値監視判定情報を設定します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @param collection 数値監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	public abstract void setMonitorNumericValueInfo(Collection collection);

	/**
	 * 文字列監視判定情報を返します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="MonitorInfo-MonitorStringValueInfo"
	 *    role-name="MonitorInfo-MonitorStringValueInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 * 
	 * @return 文字列監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	public abstract Collection getMonitorStringValueInfo();

	/**
	 * 文字列監視判定情報を設定します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @param collection 文字列監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoBean
	 */
	public abstract void setMonitorStringValueInfo(Collection collection);

	/**
	 * SNMPTRAP監視判定情報を返します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *    name="MonitorInfo-MonitorTrapValueInfo"
	 *    role-name="MonitorInfo-MonitorTrapValueInfo(single)"
	 *    target-cascade-delete="true"
	 * 
	 * @jboss.target-relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 * 
	 * @return SNMPTRAP監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoBean
	 */
	public abstract Collection getMonitorTrapValueInfo();

	/**
	 * SNMPTRAP監視判定情報を設定します。
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @param collection SNMPTRAP監視判定情報のコレクション
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoBean
	 */
	public abstract void setMonitorTrapValueInfo(Collection collection);

}
