/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */


package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.clustercontrol.fault.EventLogNotFound;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.util.apllog.AplLogger;

public class ModifyEventComment {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( ModifyEventComment.class );

	/**
	 * 引数で指定されたイベント情報のコメントを更新します。
	 * 
	 * @param monitorId
	 * @param pluginId
	 * @param facilityId
	 * @param outputDate
	 * @param comment
	 * @param commentDate
	 * @param commentUser
	 * @throws NamingException
	 * @throws EventLogNotFound
	 */

	public void modifyComment(String monitorId, String monitorDetailId, String pluginId,
			String facilityId,
			Long outputDate, String comment, Long commentDate,
			String commentUser) throws NamingException, EventLogNotFound {

		try {
			// イベントログ情報を取得
			EventLogPK pk = new EventLogPK(
					monitorId,
					monitorDetailId,
					pluginId,
					facilityId,
					new Timestamp(outputDate));
			EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);

			commentDate = new Date().getTime();
			event.setCommentDate(new Timestamp (commentDate));

			event.setCommentUser(commentUser);
			event.setComment(comment);

		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("Mon", "mon");
			String[] args = {monitorId, pluginId, facilityId };
			apllog.put("SYS", "", args);
			m_log.warn("modifyComment():" + e.getMessage());
			throw new EventLogNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("Mon","mon");
			String[] args = {monitorId, pluginId, facilityId};
			apllog.put("SYS", "", args);
			m_log.warn("modifyComment():" + e.getMessage());
			throw e;
		}
	}
}
