/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.commons.util.CommonValidator;
import com.clustercontrol.maintenance.bean.MaintenanceInfo;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMst;
import com.clustercontrol.maintenance.factory.SelectMaintenanceTypeMst;
import com.clustercontrol.util.Messages;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * 履歴削除の入力チェッククラス
 * 
 * @since 4.0
 */
public class MaintenanceValidator {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( MaintenanceValidator.class );

	/**
	 * メンテナンス情報の妥当性チェック
	 * 
	 * @param maintenanceInfo
	 * @throws InvalidSetting
	 */
	public static void validateMaintenanceInfo(MaintenanceInfo maintenanceInfo) throws InvalidSetting, HinemosUnknown{
		// maintenanceId
		if (maintenanceInfo.getMaintenanceId() == null ||
				"".equals(maintenanceInfo.getMaintenanceId())) {
			throw new InvalidSetting(Messages.getString("message.maintenance.9"));
		}
		CommonValidator.validateId(Messages.getString("maintenance.id"), maintenanceInfo.getMaintenanceId(), 64);

		// schedule
		CommonValidator.validateScheduleHour(maintenanceInfo.getSchedule());

		// calendarId
		CommonValidator.validateCalenderId(maintenanceInfo.getCalendarId(), false);

		maintenanceInfo.getSchedule();

		// notifyId
		if(maintenanceInfo.getNotifyId() != null){
			for(NotifyRelationInfo notifyRelationInfo : maintenanceInfo.getNotifyId()){
				CommonValidator.validateNotifyId(notifyRelationInfo.getNotifyId(), true);
			}
		}

		// typeId
		String typeId = maintenanceInfo.getTypeId();
		if (typeId == null || "".equals(typeId)) {
			throw new InvalidSetting(Messages.getString("message.maintenance.16"));
		}
		SelectMaintenanceTypeMst select = new SelectMaintenanceTypeMst();
		boolean flag = true;
		try {
			for (MaintenanceTypeMst mst : select.getMaintenanceTypeList()) {
				if (typeId.equals(mst.getType_id())) {
					flag = false;
					break;
				}
			}
			if (flag) {
				throw new InvalidSetting(Messages.getString("message.maintenance.16"));
			}
		} catch (InvalidSetting e) {
			throw e;
		} catch (Exception e) {
			m_log.info("validateMaintenanceInfo " + e.getMessage());
		}

		// dataRetentionPeriod
		if(maintenanceInfo.getDataRetentionPeriod() == null
				|| maintenanceInfo.getDataRetentionPeriod().intValue() < 0){
			throw new InvalidSetting(Messages.getString("message.maintenance.17"));
		}

		// description
		CommonValidator.validateString(Messages.getString("description"),
				maintenanceInfo.getDescription(), false, 1, 256);

		// application
		if (maintenanceInfo.getApplication() == null ||
				"".equals(maintenanceInfo.getApplication())) {
			throw new InvalidSetting(Messages.getString("message.monitor.10"));
		}
		CommonValidator.validateString(Messages.getString("application"),
				maintenanceInfo.getApplication(), true, 1, 64);
	}
}
