/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.maintenance.bean.MaintenanceTypeMst;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceTypeMstLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceTypeMstUtil;

/**
 * 
 * メンテナンス種別に関する情報を検索するためのクラスです。
 * 
 * @since	2.2.0
 * @version	2.2.0
 *
 */
public class SelectMaintenanceTypeMst {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( SelectMaintenanceTypeMst.class );

	/**
	 * メンテナンス種別を取得する
	 * @param type_id
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	private MaintenanceTypeMst getMaintenanceType(String type_id) throws FinderException,NamingException{
		MaintenanceTypeMstLocal mst = MaintenanceTypeMstUtil.getLocalHome().findByPrimaryKey(type_id);

		MaintenanceTypeMst type  = new MaintenanceTypeMst();
		type.setType_id(mst.getType_id());
		type.setName_id(mst.getName_id());
		type.setOrder_no(mst.getOrder_no());
		return type;
	}

	/**
	 * メンテナンス種別一覧を取得する
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 */
	public ArrayList<MaintenanceTypeMst> getMaintenanceTypeList() throws FinderException, NamingException, CreateException {
		m_log.debug("getMaintenanceTypeList() : start");
		ArrayList<MaintenanceTypeMst> list = new ArrayList<MaintenanceTypeMst>();

		// メンテナンス種別マスタ一覧を取得
		Collection<MaintenanceTypeMstLocal> ct = MaintenanceTypeMstUtil.getLocalHome().findAll();

		for(MaintenanceTypeMstLocal info : ct){
			list.add(getMaintenanceType(info.getType_id()));
			// for debug
			if(m_log.isDebugEnabled()){
				m_log.debug("getMaintenanceTypeList() : " +
						"type_id = " + info.getType_id() +
						", name_id = " + info.getName_id() +
						", order_no = " + info.getOrder_no());
			}
		}

		return list;
	}
}
