/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.commons.util.ConnectionManager;

/**
 * ジョブ履歴の削除処理
 * 
 * @version 4.0.0
 * @since 3.1.0
 *
 */
public class MaintenanceJob extends MaintenanceObject{

	private static Log m_log = LogFactory.getLog( MaintenanceJob.class );

	/**
	 * ジョブ履歴のオブジェクト名。<BR>
	 * キャッシュをフラッシュするオブジェクト名を指定します。
	 */
	private static final String[] OBJECT_NAME_JOB =
	{"jboss.j2ee:jndiName=JobCommandInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobEndInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobFileInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobNoticeInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobParamInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobRelationInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobSessionLocal,service=EJB",
		"jboss.j2ee:jndiName=JobSessionJobLocal,service=EJB",
		"jboss.j2ee:jndiName=JobSessionNodeLocal,service=EJB",
		"jboss.j2ee:jndiName=JobStartInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobStartJobInfoLocal,service=EJB",
		"jboss.j2ee:jndiName=JobStartTimeInfoLocal,service=EJB"
	};

	/**
	 * コンストラクタ
	 */
	public MaintenanceJob() {
		super(OBJECT_NAME_JOB);
	}


	/**
	 * 削除処理
	 * @throws HinemosUnknown
	 * @throws NotifyNotFound
	 */
	@Override
	protected int _delete(Timestamp keep, boolean status) throws FinderException,
	NamingException, CreateException, SQLException, RemoveException, NotifyNotFound, HinemosUnknown {
		m_log.debug("_delete() start : keep = " + keep.toString() + ", status = " + status);

		int ret = 0;	// target job_session_id count
		int ret1 = 0;	// target notify_relation_info count
		int ret2 = 0;	// target monitor_status count
		int ret3 = 0;	// target notify_history
		Connection conn = null;
		Statement stmt = null;
		boolean autoCommit = false;

		try {
			///////////////////////////////////////////////
			// GET CONNECTION
			///////////////////////////////////////////////
			conn = ConnectionManager.getConnectionManager().getConnection();
			autoCommit = conn.getAutoCommit();
			conn.setAutoCommit(false);

			//SQL文のセット
			stmt = conn.createStatement();
			// for HA (縮退判定時間を延ばすため)、シングルには影響なし(0)
			if (_queryTimeout > 0) {
				stmt.setQueryTimeout(_queryTimeout);
			}

			///////////////////////////////////////////////
			// SET SQL STATEMENT
			///////////////////////////////////////////////

			// 削除対象となるsession_idを格納するテンポラリテーブル作成(スキーマ定義引継ぎ)
			String create_sessionId_table = "CREATE TABLE cc_job_completed_sessions AS SELECT session_id FROM cc_job_session LIMIT 0";
			// 削除対象となるsession_idを格納するテンポラリテーブル削除
			String drop_sessionId_table = "DROP TABLE cc_job_completed_sessions";

			StringBuffer statusCondition = new StringBuffer("");
			if(!status){
				statusCondition.append("(status='300' OR status='301') AND ");
			}

			// 削除対象となるsession_idの検索と挿入
			String insert_select_sessionId =
				"INSERT INTO cc_job_completed_sessions " +
				"SELECT session_id FROM cc_job_session_job " +
				"WHERE " + statusCondition.toString() +
				"start_date < '" + keep.toString() + "' AND " +
				"(jobunit_id, job_id, session_id ) IN (SELECT jobunit_id, job_id, session_id FROM cc_job_session)";

			// 削除:cc_job_sessionと関連テーブル(CASCADE)
			String detete_job_session = "DELETE FROM cc_job_session WHERE session_id IN (SELECT session_id FROM cc_job_completed_sessions)";
			// 削除:cc_notify_relation_info
			String detete_notify_relation_info = "DELETE FROM cc_notify_relation_info WHERE ( notify_group_id ) LIKE ANY (SELECT DISTINCT 'JOB_SES-' || session_id || '%' FROM cc_job_completed_sessions)";
			// 削除:cc_monitor_status
			String detete_monitor_status = "DELETE FROM cc_monitor_status WHERE plugin_id='JOB' AND monitor_id IN (SELECT session_id FROM cc_job_completed_sessions)";
			// 削除:cc_notify_history
			String detete_notify_history = "DELETE FROM cc_notify_history WHERE plugin_id='JOB' AND monitor_id IN (SELECT session_id FROM cc_job_completed_sessions)";

			///////////////////////////////////////////////
			// RUN SQL STATEMENT
			///////////////////////////////////////////////
			m_log.debug("_delete() : CREATE TEMPORARY TABLE AND INSERT JOB_SESSION_ID");
			m_log.debug("_delete() : sql = " + create_sessionId_table);
			stmt.execute(create_sessionId_table);
			m_log.debug("_delete() : sql = " + insert_select_sessionId);
			stmt.execute(insert_select_sessionId);

			m_log.debug("_delete() : DELETE cc_job_session");
			m_log.debug("_delete() : sql = " + detete_job_session);
			ret = stmt.executeUpdate(detete_job_session);
			m_log.debug("_delete() : DELETE cc_job_session COUNT = " + ret);


			m_log.debug("_delete() : DELETE cc_notify_relation_info");
			m_log.debug("_delete() : sql = " + detete_notify_relation_info);
			ret1 = stmt.executeUpdate(detete_notify_relation_info);
			m_log.debug("_delete() : DELETE cc_notify_relation_info COUNT = " + ret1);


			m_log.debug("_delete() : DELETE cc_monitor_status");
			m_log.debug("_delete() : sql = " + detete_monitor_status);
			ret2 = stmt.executeUpdate(detete_monitor_status);
			m_log.debug("_delete() : DELETE cc_monitor_status COUNT = " + ret2);

			m_log.debug("_delete() : DELETE cc_notify_history");
			m_log.debug("_delete() : sql = " + detete_notify_history);
			ret3 = stmt.executeUpdate(detete_notify_history);
			m_log.debug("_delete() : DELETE cc_notify_history COUNT = " + ret3);

			m_log.debug("_delete() : DROP TEMPORARY TABLE");
			m_log.debug("_delete() : sql = " + drop_sessionId_table);
			stmt.execute(drop_sessionId_table);

			///////////////////////////////////////////////
			// COMMIT
			///////////////////////////////////////////////
			conn.commit();

			m_log.debug("_delete() count : " + ret);
			return ret;

		} catch (SQLException e) {
			m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
			throw e;
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.setAutoCommit(autoCommit);
					conn.close();
				}
			} catch (SQLException e) {
				m_log.error("_delete() : keep = " + keep.toString() + ", status = " + status, e);
				throw e;
			}
		}
	}
}
