/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.fault.UserNotFound;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobManagementUserInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.JudgmentObjectConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobUserRelationMasterLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * ジョブ情報を検索するクラスです。
 *
 * @version 3.0.0
 * @since 1.0.0
 */
public class FullJob {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( FullJob.class );

	/** リポジトリ */
	private RepositoryControllerLocal repository = null;

	/**
	 * コンストラクタ
	 * <P>
	 * ジョブ管理プロパティファイルから、ファイル転送ジョブ展開表示設定を取得します。
	 */
	public FullJob(){

	}

	/**
	 * ジョブ情報{@link com.clustercontrol.jobmanagement.bean.JobInfo}を作成します。<BR>
	 * ジョブマスタを基に、ジョブ情報を作成します。
	 * 
	 * @param job ジョブマスタ
	 * @param treeOnly treeOnly true=ジョブ情報を含まない, false=ジョブ情報含む
	 * @return ジョブ情報
	 * @throws HinemosUnknown
	 * @throws NotifyNotFound
	 * @throws JobMasterNotFound
	 * @throws NamingException
	 * @throws FinderException
	 * @throws UserNotFound
	 * @throws CreateException
	 * @throws
	 * @throws NamingException
	 */
	public JobInfo getJobFull(JobInfo info)
	throws JobMasterNotFound, NamingException,
	NotifyNotFound, UserNotFound, HinemosUnknown, CreateException {

		m_log.debug("createJobData() : " + info.getJobunitId() + ", " + info.getId() + "," + info.isPropertyFull());
		if (info.isPropertyFull()) {
			return info;
		}

		//JobInfoを作成
		//JobInfo info = new JobInfo(jobInfo.getJobunitId(), jobInfo.getId(), job.getJob_name(), job.getJob_type().intValue());
		m_log.debug("createJobData() : " + info.getJobunitId() + ", " + info.getId());
		JobMasterPK pk = new JobMasterPK(info.getJobunitId(), info.getId());
		JobMasterLocal job = null;

		try {
			job = JobMasterUtil.getLocalHome().findByPrimaryKey(pk);
		} catch (FinderException e) {
			m_log.warn("getJobFull " + e.getMessage());
			throw new JobMasterNotFound(e.getMessage() , e);
		}

		info.setDescription(job.getDescription());
		if (job.getReg_date() != null) {
			info.setCreateTime(job.getReg_date().getTime());
		}
		if (job.getUpdate_date() != null) {
			info.setUpdateTime(job.getUpdate_date().getTime());
		}
		info.setCreateUser(job.getReg_user());
		info.setUpdateUser(job.getUpdate_user());
		//待ち条件を取得
		JobWaitRuleInfo waitRule = null;
		JobStartMasterLocal start = job.getJobStartMaster();
		if(start != null){
			//待ち条件を取得
			waitRule = new JobWaitRuleInfo();
			waitRule.setSuspend(start.getSuspend().intValue());
			waitRule.setCondition(start.getCondition_type().intValue());
			waitRule.setEndCondition(start.getUnmatch_end_flg().intValue());
			waitRule.setEndStatus(start.getUnmatch_end_status().intValue());
			waitRule.setEndValue(start.getUnmatch_end_value().intValue());
			waitRule.setSkip(start.getSkip().intValue());
			waitRule.setSkipEndStatus(start.getSkip_end_status().intValue());
			waitRule.setSkipEndValue(start.getSkip_end_value().intValue());
			waitRule.setCalendar(start.getCalendar().intValue());
			waitRule.setCalendarId(start.getCalendar_id());
			waitRule.setCalendarEndValue(start.getCalendar_end_value().intValue());

			waitRule.setStart_delay(start.getStart_delay().intValue());
			waitRule.setStart_delay_session(start.getStart_delay_session().intValue());
			waitRule.setStart_delay_session_value(start.getStart_delay_session_value().intValue());
			waitRule.setStart_delay_time(start.getStart_delay_time().intValue());
			if (start.getStart_delay_time_value() != null) {
				waitRule.setStart_delay_time_value(start.getStart_delay_time_value().getTime());
			}
			waitRule.setStart_delay_condition_type(start.getStart_delay_condition_type().intValue());
			waitRule.setStart_delay_notify(start.getStart_delay_notify().intValue());
			waitRule.setStart_delay_notify_priority(start.getStart_delay_notify_priority().intValue());
			waitRule.setStart_delay_operation(start.getStart_delay_operation().intValue());
			waitRule.setStart_delay_operation_type(start.getStart_delay_operation_type().intValue());
			waitRule.setStart_delay_operation_end_value(start.getStart_delay_operation_end_value().intValue());

			waitRule.setEnd_delay(start.getEnd_delay().intValue());
			waitRule.setEnd_delay_session(start.getEnd_delay_session().intValue());
			waitRule.setEnd_delay_session_value(start.getEnd_delay_session_value().intValue());
			waitRule.setEnd_delay_job(start.getEnd_delay_job().intValue());
			waitRule.setEnd_delay_job_value(start.getEnd_delay_job_value().intValue());
			waitRule.setEnd_delay_time(start.getEnd_delay_time().intValue());
			if (start.getEnd_delay_time_value() != null) {
				waitRule.setEnd_delay_time_value(start.getEnd_delay_time_value().getTime());
			}
			waitRule.setEnd_delay_condition_type(start.getEnd_delay_condition_type().intValue());
			waitRule.setEnd_delay_notify(start.getEnd_delay_notify().intValue());
			waitRule.setEnd_delay_notify_priority(start.getEnd_delay_notify_priority().intValue());
			waitRule.setEnd_delay_operation(start.getEnd_delay_operation().intValue());
			waitRule.setEnd_delay_operation_type(start.getEnd_delay_operation_type().intValue());
			waitRule.setEnd_delay_operation_end_value(start.getEnd_delay_operation_end_value().intValue());


			//待ち条件（ジョブ）を取得
			Collection startJobList = start.getJobStartJobMaster();
			ArrayList<JobObjectInfo> objectList = new ArrayList<JobObjectInfo>();
			if(startJobList != null && startJobList.size() > 0){
				Iterator itr = startJobList.iterator();
				while(itr.hasNext()){
					JobStartJobMasterLocal startJob = (JobStartJobMasterLocal)itr.next();
					if(startJob != null){
						JobObjectInfo objectInfo = new JobObjectInfo();
						objectInfo.setJobId(startJob.getTarget_job_id());
						try {
							//対象ジョブを取得
							JobMasterLocal targetJob = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(startJob.getTarget_jobunit_id(), startJob.getTarget_job_id()));
							objectInfo.setJobName(targetJob.getJob_name());
							objectInfo.setType(startJob.getTarget_job_type().intValue());
							objectInfo.setValue(startJob.getTarget_job_end_value().intValue());
							objectList.add(objectInfo);
						} catch (FinderException e) {
							m_log.warn("JobMasterLocal.findByPrimaryKey() : " + e.getMessage());
							JobMasterNotFound je = new JobMasterNotFound(e.getMessage(), e);
							je.setJobunitId(startJob.getJobunit_id());
							je.setJobId(startJob.getJob_id());
							throw je;
						} catch (NamingException e) {
							throw e;
						}
					}
				}
			}

			//待ち条件（時刻）を取得
			JobStartTimeMasterLocal startTime = start.getJobStartTimeMaster();
			if(startTime != null){
				JobObjectInfo objectInfo = new JobObjectInfo();
				objectInfo.setType(JudgmentObjectConstant.TYPE_TIME);
				if (startTime.getStart_time() != null) {
					objectInfo.setTime(startTime.getStart_time().getTime());
				}
				objectList.add(objectInfo);
			}

			waitRule.setObject(objectList);
			info.setWaitRule(waitRule);
		}

		//実行コマンドを取得
		JobCommandInfo commandInfo = null;
		JobCommandMasterLocal command = job.getJobCommandMaster();
		if(command != null){
			commandInfo = new JobCommandInfo();
			commandInfo.setFacilityID(command.getFacility_id());
			commandInfo.setProcessingMethod(command.getProcess_mode().intValue());
			commandInfo.setStartCommand(command.getStart_command());
			commandInfo.setStopCommand(command.getStop_command());
			commandInfo.setUser(command.getEffective_user());
			commandInfo.setErrorEndFlg(command.getError_end_flg().intValue());
			commandInfo.setErrorEndValue(command.getError_end_value().intValue());
			//リポジトリ(RepositoryControllerLocal)を取得
			if(repository == null)
				repository = RepositoryControllerUtil.getLocalHome().create();
			//ファシリティパスを取得
			commandInfo.setScope(repository.getFacilityPath(command.getFacility_id(), null));
			info.setCommand(commandInfo);
		}

		//ファイル転送を取得
		JobFileInfo fileInfo = null;
		JobFileMasterLocal file = job.getJobFileMaster();
		if(file != null){
			fileInfo = new JobFileInfo();
			fileInfo.setProcessingMethod(file.getProcess_mode().intValue());
			fileInfo.setSrcFacilityID(file.getSrc_facility_id());
			fileInfo.setDestFacilityID(file.getDest_facility_id());
			fileInfo.setSrcFile(file.getSrc_file());
			fileInfo.setSrcWorkDir(file.getSrc_work_dir());
			fileInfo.setDestDirectory(file.getDest_directory());
			fileInfo.setDestWorkDir(file.getDest_work_dir());
			fileInfo.setCompressionFlg(file.getCompression_flg().intValue());
			fileInfo.setCheckFlg(file.getCheck_flg().intValue());
			fileInfo.setUser(file.getEffective_user());
			//リポジトリ(RepositoryControllerLocal)を取得
			if(repository == null)
				repository = RepositoryControllerUtil.getLocalHome().create();
			//ファシリティパスを取得
			fileInfo.setSrcScope(repository.getFacilityPath(file.getSrc_facility_id(), null));
			fileInfo.setDestScope(repository.getFacilityPath(file.getDest_facility_id(), null));
			info.setFile(fileInfo);
		}

		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();

		//通知メッセージを取得
		ArrayList<JobNotificationsInfo> noticeList = new ArrayList<JobNotificationsInfo>();
		Collection notices = job.getJobNoticeMaster();
		if(notices != null){
			Iterator itr = notices.iterator();
			while(itr.hasNext()){
				JobNoticeMasterLocal notice = (JobNoticeMasterLocal)itr.next();
				JobNotificationsInfo notificationsInfo = new JobNotificationsInfo();
				notificationsInfo.setType(notice.getNotice_type().intValue());
				notificationsInfo.setPriority(notice.getPriority().intValue());
				notificationsInfo.setNotifyGroupId(notice.getNotifyGroupId());

				//正常終了の場合のみ通知をセット
				if(notificationsInfo.getType() == EndStatusConstant.TYPE_NORMAL ){
					//通知情報の取得
					notificationsInfo.setNotifyId(nc.getNotifyRelation(notice.getNotifyGroupId()));
				}
				noticeList.add(notificationsInfo);
			}
			info.setNotifications(noticeList);
		}

		//終了状態を取得
		ArrayList<JobEndStatusInfo> endList = new ArrayList<JobEndStatusInfo>();
		Collection ends = job.getJobEndMaster();
		if(ends != null){
			Iterator itr = ends.iterator();
			while(itr.hasNext()){
				JobEndMasterLocal end = (JobEndMasterLocal)itr.next();
				JobEndStatusInfo endInfo = new JobEndStatusInfo();
				endInfo.setType(end.getEnd_status().intValue());
				endInfo.setValue(end.getEnd_value().intValue());
				endInfo.setStartRangeValue(end.getEnd_value_from().intValue());
				endInfo.setEndRangeValue(end.getEnd_value_to().intValue());
				endList.add(endInfo);
			}
			info.setEndStatus(endList);
		}

		//パラメータを取得
		if (info.getType() == JobConstant.TYPE_JOBUNIT) {
			ArrayList<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
			Collection params = job.getJobParamMaster();
			if(params != null){
				Iterator itr = params.iterator();
				while(itr.hasNext()){
					JobParamMasterLocal param = (JobParamMasterLocal)itr.next();
					JobParameterInfo paramInfo = new JobParameterInfo();
					paramInfo.setParamId(param.getParam_id());
					paramInfo.setType(param.getParam_type().intValue());
					paramInfo.setDescription(param.getDescription());
					paramInfo.setValue(param.getValue());
					paramList.add(paramInfo);
				}
				info.setParam(paramList);
			}
		}

		//管理ユーザを取得
		if (info.getType() == JobConstant.TYPE_JOBUNIT) {
			ArrayList<JobManagementUserInfo> managementUserList = new ArrayList<JobManagementUserInfo>();
			Collection<JobUserRelationMasterLocal> userRelations = job.getJobUserRelationMaster();
			for (JobUserRelationMasterLocal userRelation : userRelations) {
				m_log.debug("managementUser : userId=" + userRelation.getUser_id());

				UserLocal user = null;
				try {
					user = UserUtil.getLocalHome().findByPrimaryKey(userRelation.getUser_id());

					JobManagementUserInfo managementUser = new JobManagementUserInfo();
					managementUser.setUserId(userRelation.getUser_id());
					managementUser.setUserName(user.getUserName());
					managementUser.setDescription(user.getDescription());

					managementUserList.add(managementUser);

				} catch (FinderException e) {
					m_log.warn("UserLocal.findByPrimaryKey() : " + e.getMessage());
					UserNotFound ue = new UserNotFound(e.getMessage(), e);
					ue.setUserId(userRelation.getUser_id());
					throw ue;
				}
			}
			m_log.debug("managementUserList : " + managementUserList.toString());
			info.setManagementUser(managementUserList);
		}

		info.setPropertyFull(true);
		return info;
	}

	/**
	 * ジョブツリー配下のジョブを全てfullProperty=trueにする。
	 * @param item
	 * @throws JobMasterNotFound
	 * @throws NotifyNotFound
	 * @throws UserNotFound
	 * @throws HinemosUnknown
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void setJobTreeFull (JobTreeItem item)
	throws JobMasterNotFound, NotifyNotFound, UserNotFound, HinemosUnknown, NamingException, CreateException {
		JobInfo jobInfo = item.getData();
		if (!jobInfo.isPropertyFull()) {
			item.setData(getJobFull(item.getData()));
		}
		if (item.getChildren() == null) {
			return;
		}
		for (JobTreeItem child : item.getChildren()) {
			setJobTreeFull(child);
		}
	}
}
