/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.priority.util.PriorityJudgment;

/**
 * ジョブの終了状態を判定するクラスです。
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class EndJudgment extends PriorityJudgment {

	/**
	 * 終了状態を判定パターンに当てはめて判定します。
	 * 
	 * @param stausList 終了状態の配列
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public static Integer judgment(ArrayList stausList) {
		Integer priority = null;
		Integer endStatus = null;
		boolean normal = false;
		boolean abnormal = false;
		boolean warning = false;
		boolean unknown = false;

		for(int i =0; i < stausList.size(); i++){
			Integer status = (Integer)stausList.get(i);

			if(status.intValue() == EndStatusConstant.TYPE_NORMAL){
				normal = true;
			}
			else if(status.intValue() == EndStatusConstant.TYPE_WARNING){
				warning = true;
			}
			else if(status.intValue() == EndStatusConstant.TYPE_ABNORMAL){
				abnormal = true;
			}
		}

		if(normal && !warning && !abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン 1: ○　 | ×　 | ×　 | ×
			priority = m_patternMap.get(PATTERN_1);
		}
		else if(normal && warning && !abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン 3: ○　 | ○　 | ×　 | ×
			priority = m_patternMap.get(PATTERN_3);
		}
		else if(!normal && warning && !abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン 5: ×　 | ○　 | ×　 | ×
			priority = m_patternMap.get(PATTERN_5);
		}
		else if(normal && !warning && abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン 7: ○　 | ×　 | ○　 | ×
			priority = m_patternMap.get(PATTERN_7);
		}
		else if(normal && warning && abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン 9: ○　 | ○　 | ○　 | ×
			priority = m_patternMap.get(PATTERN_9);
		}
		else if(!normal && warning && abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン11: ×　 | ○　 | ○　 | ×
			priority = m_patternMap.get(PATTERN_11);
		}
		else if(!normal && !warning && abnormal && !unknown){
			// 　　　　    正常 | 警告 | 異常 | 不明
			// パターン13: ×　 | ×　 | ○　 | ×
			priority = m_patternMap.get(PATTERN_13);
		}
		else{
			return null;
		}

		//重要度から終了状態に変換
		endStatus = changePriorityToEndStatus(priority);

		return endStatus;
	}

	/**
	 * 重要度から終了状態に変換します。
	 * 
	 * @param priority 重要度
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	private static Integer changePriorityToEndStatus(Integer priority) {
		if(priority.intValue() == PriorityConstant.TYPE_INFO){
			return Integer.valueOf(EndStatusConstant.TYPE_NORMAL);
		}
		else if(priority.intValue() == PriorityConstant.TYPE_WARNING){
			return Integer.valueOf(EndStatusConstant.TYPE_WARNING);
		}
		else if(priority.intValue() == PriorityConstant.TYPE_CRITICAL){
			return Integer.valueOf(EndStatusConstant.TYPE_ABNORMAL);
		}
		else {
			return null;
		}
	}
}
