/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.JobInfoNotFound;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl;
import com.clustercontrol.jobmanagement.factory.CreateFileJob;
import com.clustercontrol.jobmanagement.factory.CreateSessionId;
import com.clustercontrol.notify.bean.OutputBasicInfo;

/**
 * セッションのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobSession"
 *    jndi-name="JobSession"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Log BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobSessionDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO
 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl
 */
public abstract class JobSessionBean implements javax.ejb.EntityBean {
	/** セッションID */
	protected String session_id;
	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** 開始予定日時 */
	protected Date schedule_date;
	/** 操作指示(未使用) */
	protected Integer operation_flg;
	/** 実行契機種別（0:スケジュール、1:監視連動、2:手動実行） */
	protected Integer trigger_type;
	/** 実行契機情報
	 * 
	 * スケジュール：スケジュール名（スケジュールID）
	 * 監視連動　　：監視管理ID（プラグインID）
	 * 手動実行　　：ユーザ名
	 */
	protected String trigger_info;

	/**
	 * セッションを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param session_id セッションID
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param schedule_date 開始予定日時
	 * @param operation_flg 操作指示
	 * @param trigger_type ジョブ実行契機種別
	 * @param trigger_info 実行契機種別
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 */
	public JobSessionPK ejbCreate(
			String session_id,
			String jobunit_id,
			String job_id,
			Date schedule_date,
			Integer operation_flg,
			Integer trigger_type,
			String trigger_info
	) throws javax.ejb.CreateException {
		this.session_id = session_id;
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.schedule_date = schedule_date;
		this.operation_flg = operation_flg;
		this.trigger_type = trigger_type;
		this.trigger_info = trigger_info;
		return null;
	}

	/**
	 * 全てのセッションを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するセッションを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl#findByPrimaryKey(JobSessionPK)
	 */
	public JobSessionPK ejbFindByPrimaryKey(JobSessionPK pk) throws FinderException {
		return null;
	}

	/**
	 * 引数に一致するセッションを検索します。
	 * 
	 * @param userId ログインユーザのユーザID
	 * @param startFromDate 開始日時FROM
	 * @param startToDate 開始日時TO
	 * @param endFromDate 終了日時FROM
	 * @param endToDate 終了日時TO
	 * @param jobId ジョブID
	 * @param status 実行状態
	 * @param triggerType 実行契機種別
	 * @param triggerInfo 実行契機情報
	 * @param limit 最大数
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl#findHistory(Date, Date, Date, Date, String, Integer, Integer, String, Integer)
	 */
	public Collection ejbFindHistory(
			String userId,
			Date startFromDate,
			Date startToDate,
			Date endFromDate,
			Date endToDate,
			String jobId,
			Integer status,
			Integer triggerTyep,
			String triggerInfo,
			Integer limit) throws FinderException {
		return null;
	}

	/**
	 * 引数に一致するセッションのレコード数を返します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param startFromDate 開始日時FROM
	 * @param startToDate 開始日時TO
	 * @param endFromDate 終了日時FROM
	 * @param endToDate 終了日時TO
	 * @param jobId ジョブID
	 * @param status 実行状態
	 * @param triggerType 実行契機種別
	 * @param triggerInfo 実行契機情報
	 * @return レコード数
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl#countHistory(Date, Date, Date, Date, String, Integer, Integer, String)
	 */
	public int ejbHomeCountHistory(
			Date startFromDate,
			Date startToDate,
			Date endFromDate,
			Date endToDate,
			String jobId,
			Integer status,
			Integer triggerTyep,
			String triggerInfo)
	throws SQLException {
		JobSessionDAOImpl dao = new JobSessionDAOImpl();

		return dao.countHistory(
				startFromDate,
				startToDate,
				endFromDate,
				endToDate,
				jobId,
				status,
				triggerTyep,
				triggerInfo
		);
	}

	/**
	 * 未終了のセッション情報を返します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 */
	public Collection ejbFindUnendSessions() throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
	public java.lang.String getSession_id() {
		return session_id;
	}

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
	public void setSession_id(java.lang.String session_id) {
		this.session_id = session_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}

	/**
	 * 開始予定日時を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 開始予定日時
	 */
	public java.util.Date getSchedule_date() {
		return schedule_date;
	}

	/**
	 * 開始予定日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_date 開始予定日時
	 */
	public void setSchedule_date(java.util.Date schedule_date) {
		this.schedule_date = schedule_date;
	}

	/**
	 * 操作指示を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 操作指示
	 */
	public java.lang.Integer getOperation_flg() {
		return operation_flg;
	}

	/**
	 * 操作指示を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param operation_flg 操作指示
	 */
	public void setOperation_flg(java.lang.Integer operation_flg) {
		this.operation_flg = operation_flg;
	}

	/**
	 * 実行契機種別を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 実行契機種別
	 */
	public Integer getTrigger_type() {
		return trigger_type;
	}

	/**
	 * 実行契機種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param trigger_type 実行契機種別
	 */
	public void setTrigger_type(Integer trigger_type) {
		this.trigger_type = trigger_type;
	}

	/**
	 * 実行契機情報を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 実行契機情報
	 */
	public String getTrigger_info() {
		return trigger_info;
	}

	/**
	 * 実行契機情報を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param trigger_info 実行契機情報
	 */
	public void setTrigger_info(String trigger_info) {
		this.trigger_info = trigger_info;
	}

	/**
	 * セッションジョブを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return セッションジョブのコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobBean#ejbFindBySessionId(java.lang.String)
	 */
	public Collection getJobSessionJob() {
		Collection collection = null;
		try {
			collection = JobSessionJobUtil.getLocalHome().findBySessionId(getSession_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}

	/**
	 * 引数で渡されたジョブIDの履歴情報を作成する。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @param jobId ジョブID
	 * @param info ログ出力情報
	 * @param triggerInfo 実行契機情報
	 * @return セッションID
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FacilityNotFound
	 * @throws JobMasterNotFound
	 * @throws JobInfoNotFound
	 */
	public String ejbHomeMakeSession(String jobunitId, String jobId, OutputBasicInfo info, JobTriggerInfo triggerInfo) throws CreateException, NamingException, FacilityNotFound, JobMasterNotFound, JobInfoNotFound{

		String sessionId=null;

		JobMasterLocal job;
		try {
			job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobunitId, jobId));

			if(job != null){

				sessionId = CreateSessionId.create();

				//JobSessionを作成
				JobSessionUtil.getLocalHome().create(
						sessionId,
						jobunitId,
						job.getJob_id(),
						new Date(),
						Integer.valueOf(0),
						triggerInfo.getTrigger_type(),
						triggerInfo.getTrigger_info());
			}
		} catch (CreateException e) {
			throw e;
		}catch (FinderException e) {
			JobMasterNotFound je = new JobMasterNotFound(e.getMessage(), e);
			je.setJobunitId(jobunitId);
			je.setJobId(jobId);
			throw je;

		}catch (NamingException e) {
			throw e;
		}

		Collection jobs;
		Collection fileJobs;
		try {
			jobs = JobRelationMasterUtil.getLocalHome().getJobsList(jobunitId, jobId);

			//JobSessionJob
			JobSessionJobUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobRelationInfo
			JobRelationInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobInfo
			JobInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobStartInfo
			JobStartInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobStartJobInfo
			JobStartJobInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobStartTimeInfo
			JobStartTimeInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobParamInfo
			JobParamInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobId,info);

			//JobCommandInfo
			JobCommandInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobSessionNode
			JobSessionNodeUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobFileInfo
			fileJobs=JobFileInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);


			//JobNoticeInfo
			JobNoticeInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);

			//JobEndInfo
			JobEndInfoUtil.getLocalHome().makeSession(sessionId, jobunitId, jobs);



			Iterator it = fileJobs.iterator();
			Hashtable ht = null;

			while(it.hasNext()){
				ht = (Hashtable)it.next();
				jobId=(String)ht.get("jobId");
				job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobunitId, jobId));

				new CreateFileJob().createGetFileListJob(job, sessionId);
			}

		} catch (FacilityNotFound e) {
			throw e;
		} catch (FinderException e) {
			JobMasterNotFound je = new JobMasterNotFound(e.getMessage(), e);
			je.setJobunitId(jobunitId);
			je.setJobId(jobId);
			throw je;
		} catch (NamingException e) {
			throw e;
		}

		return sessionId;
	}
}
